/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.util.MovingFunction;

class MovingAverage {
    private final MovingFunction sum;
    private final MovingFunction count;

    public MovingAverage(long samplePeriodMs, long sampleUpdateMs, int numSignificantBuckets, int numSignificantSamples) {
        this.sum = new MovingFunction(samplePeriodMs, sampleUpdateMs, numSignificantBuckets, numSignificantSamples, Sum.ofLongs());
        this.count = new MovingFunction(samplePeriodMs, sampleUpdateMs, numSignificantBuckets, numSignificantSamples, Sum.ofLongs());
    }

    public void add(long nowMsSinceEpoch, long value) {
        this.sum.add(nowMsSinceEpoch, value);
        this.count.add(nowMsSinceEpoch, 1L);
    }

    public long get(long nowMsSinceEpoch) {
        return this.sum.get(nowMsSinceEpoch) / this.count.get(nowMsSinceEpoch);
    }

    public boolean hasValue(long nowMsSinceEpoch) {
        return this.sum.isSignificant() && this.count.isSignificant() && this.count.get(nowMsSinceEpoch) > 0L;
    }
}

