/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.CreateTableHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CreateTableDestinations<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, PCollection<KV<DestinationT, ElementT>>> {
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final BigQueryServices bqServices;
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;
    private final @Nullable String kmsKey;

    public CreateTableDestinations(BigQueryIO.Write.CreateDisposition createDisposition, DynamicDestinations<?, DestinationT> dynamicDestinations) {
        this(createDisposition, new BigQueryServicesImpl(), dynamicDestinations, null);
    }

    public CreateTableDestinations(BigQueryIO.Write.CreateDisposition createDisposition, BigQueryServices bqServices, DynamicDestinations<?, DestinationT> dynamicDestinations, @Nullable String kmsKey) {
        this.createDisposition = createDisposition;
        this.bqServices = bqServices;
        this.dynamicDestinations = dynamicDestinations;
        this.kmsKey = kmsKey;
    }

    CreateTableDestinations<DestinationT, ElementT> withKmsKey(String kmsKey) {
        return new CreateTableDestinations<DestinationT, ElementT>(this.createDisposition, this.bqServices, this.dynamicDestinations, kmsKey);
    }

    CreateTableDestinations<DestinationT, ElementT> withTestServices(BigQueryServices bqServices) {
        return new CreateTableDestinations<DestinationT, ElementT>(this.createDisposition, bqServices, this.dynamicDestinations, this.kmsKey);
    }

    public PCollection<KV<DestinationT, ElementT>> expand(PCollection<KV<DestinationT, ElementT>> input) {
        ArrayList sideInputs = Lists.newArrayList();
        sideInputs.addAll(this.dynamicDestinations.getSideInputs());
        return (PCollection)input.apply("CreateTables", (PTransform)ParDo.of((DoFn)new CreateTablesFn()).withSideInputs((Iterable)sideInputs));
    }

    private class CreateTablesFn
    extends DoFn<KV<DestinationT, ElementT>, KV<DestinationT, ElementT>> {
        private Map<DestinationT, TableDestination> destinations = Maps.newHashMap();

        private CreateTablesFn() {
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.destinations = Maps.newHashMap();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context, @DoFn.Element KV<DestinationT, ElementT> element, DoFn.OutputReceiver<KV<DestinationT, ElementT>> o) {
            CreateTableDestinations.this.dynamicDestinations.setSideInputAccessorFromProcessContext(context);
            this.destinations.computeIfAbsent(element.getKey(), dest -> {
                @Nullable TableDestination tableDestination1 = CreateTableDestinations.this.dynamicDestinations.getTable(dest);
                Preconditions.checkArgument((tableDestination1 != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may not return null, but %s returned null for destination %s", (Object)CreateTableDestinations.this.dynamicDestinations, (Object)dest);
                @Nullable Coder<DestinationT> destinationCoder = CreateTableDestinations.this.dynamicDestinations.getDestinationCoder();
                @Nullable Supplier schemaSupplier = () -> CreateTableDestinations.this.dynamicDestinations.getSchema(dest);
                return CreateTableHelpers.possiblyCreateTable(context, tableDestination1, (Supplier<TableSchema>)schemaSupplier, CreateTableDestinations.this.createDisposition, destinationCoder, CreateTableDestinations.this.kmsKey, CreateTableDestinations.this.bqServices);
            });
            o.output(element);
        }
    }
}

