/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.UUID;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.CountingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BigQueryRowWriter<T>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryRowWriter.class);
    private ResourceId resourceId;
    private WritableByteChannel channel;
    private CountingOutputStream out;
    private boolean isClosed = false;

    BigQueryRowWriter(String basename, String mimeType) throws Exception {
        String uId = UUID.randomUUID().toString();
        this.resourceId = FileSystems.matchNewResource((String)(basename + uId), (boolean)false);
        LOG.info("Opening {} to {}.", (Object)this.getClass().getSimpleName(), (Object)this.resourceId);
        this.channel = FileSystems.create((ResourceId)this.resourceId, (String)mimeType);
        this.out = new CountingOutputStream(Channels.newOutputStream(this.channel));
    }

    protected OutputStream getOutputStream() {
        return this.out;
    }

    abstract void write(T var1) throws Exception;

    long getByteSize() {
        return this.out.getCount();
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"Already closed");
        this.isClosed = true;
        this.channel.close();
    }

    Result getResult() {
        Preconditions.checkState((boolean)this.isClosed, (Object)"Not yet closed");
        return new Result(this.resourceId, this.out.getCount());
    }

    static final class Result {
        final ResourceId resourceId;
        final long byteSize;

        public Result(ResourceId resourceId, long byteSize) {
            this.resourceId = resourceId;
            this.byteSize = byteSize;
        }
    }
}

