/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.extensions.gcp.util.GceMetadataUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

final class BigQueryIOMetadata {
    private @Nullable String beamJobId;
    private static final Pattern VALID_CLOUD_LABEL_PATTERN = Pattern.compile("^[a-z0-9\\_\\-]{1,63}$");

    private BigQueryIOMetadata(@Nullable String beamJobId) {
        this.beamJobId = beamJobId;
    }

    public static BigQueryIOMetadata create() {
        String dataflowJobId = GceMetadataUtil.fetchDataflowJobId();
        boolean isDataflowRunner = dataflowJobId != null && !dataflowJobId.isEmpty();
        String beamJobId = null;
        if (isDataflowRunner && BigQueryIOMetadata.isValidCloudLabel(dataflowJobId)) {
            beamJobId = dataflowJobId;
        }
        return new BigQueryIOMetadata(beamJobId);
    }

    public Map<String, String> addAdditionalJobLabels(Map<String, String> jobLabels) {
        if (this.beamJobId != null && !jobLabels.containsKey("beam_job_id")) {
            jobLabels.put("beam_job_id", this.beamJobId);
        }
        return jobLabels;
    }

    public @Nullable String getBeamJobId() {
        return this.beamJobId;
    }

    public static boolean isValidCloudLabel(String value) {
        Matcher m = VALID_CLOUD_LABEL_PATTERN.matcher(value);
        return m.find();
    }
}

