/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dao;

import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.Options;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataAdminDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;

public class DaoFactory
implements Serializable {
    private static final long serialVersionUID = 7929063669009832487L;
    private static PartitionMetadataAdminDao partitionMetadataAdminDao;
    private static PartitionMetadataDao partitionMetadataDaoInstance;
    private static ChangeStreamDao changeStreamDaoInstance;
    private final SpannerConfig changeStreamSpannerConfig;
    private final SpannerConfig metadataSpannerConfig;
    private final String changeStreamName;
    private final String partitionMetadataTableName;
    private final Options.RpcPriority rpcPriority;
    private final String jobName;

    public DaoFactory(SpannerConfig changeStreamSpannerConfig, String changeStreamName, SpannerConfig metadataSpannerConfig, String partitionMetadataTableName, Options.RpcPriority rpcPriority, String jobName) {
        if (metadataSpannerConfig.getInstanceId() == null) {
            throw new IllegalArgumentException("Metadata instance can not be null");
        }
        if (metadataSpannerConfig.getDatabaseId() == null) {
            throw new IllegalArgumentException("Metadata database can not be null");
        }
        this.changeStreamSpannerConfig = changeStreamSpannerConfig;
        this.changeStreamName = changeStreamName;
        this.metadataSpannerConfig = metadataSpannerConfig;
        this.partitionMetadataTableName = partitionMetadataTableName;
        this.rpcPriority = rpcPriority;
        this.jobName = jobName;
    }

    public synchronized PartitionMetadataAdminDao getPartitionMetadataAdminDao() {
        if (partitionMetadataAdminDao == null) {
            DatabaseAdminClient databaseAdminClient = SpannerAccessor.getOrCreate(this.metadataSpannerConfig).getDatabaseAdminClient();
            partitionMetadataAdminDao = new PartitionMetadataAdminDao(databaseAdminClient, (String)this.metadataSpannerConfig.getInstanceId().get(), (String)this.metadataSpannerConfig.getDatabaseId().get(), this.partitionMetadataTableName);
        }
        return partitionMetadataAdminDao;
    }

    public synchronized PartitionMetadataDao getPartitionMetadataDao() {
        SpannerAccessor spannerAccessor = SpannerAccessor.getOrCreate(this.metadataSpannerConfig);
        if (partitionMetadataDaoInstance == null) {
            partitionMetadataDaoInstance = new PartitionMetadataDao(this.partitionMetadataTableName, spannerAccessor.getDatabaseClient());
        }
        return partitionMetadataDaoInstance;
    }

    public synchronized ChangeStreamDao getChangeStreamDao() {
        SpannerAccessor spannerAccessor = SpannerAccessor.getOrCreate(this.changeStreamSpannerConfig);
        if (changeStreamDaoInstance == null) {
            changeStreamDaoInstance = new ChangeStreamDao(this.changeStreamName, spannerAccessor.getDatabaseClient(), this.rpcPriority, this.jobName);
        }
        return changeStreamDaoInstance;
    }
}

