/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.sdk.transforms.DoFn;

class ReadSpannerSchema
extends DoFn<Void, SpannerSchema> {
    private final SpannerConfig config;
    private transient SpannerAccessor spannerAccessor;

    public ReadSpannerSchema(SpannerConfig config) {
        this.config = config;
    }

    @DoFn.Setup
    public void setup() throws Exception {
        this.spannerAccessor = SpannerAccessor.getOrCreate(this.config);
    }

    @DoFn.Teardown
    public void teardown() throws Exception {
        this.spannerAccessor.close();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        SpannerSchema.Builder builder = SpannerSchema.builder();
        DatabaseClient databaseClient = this.spannerAccessor.getDatabaseClient();
        try (ReadOnlyTransaction tx = databaseClient.readOnlyTransaction();){
            String columnName;
            String tableName;
            ResultSet resultSet = this.readTableInfo(tx);
            while (resultSet.next()) {
                tableName = resultSet.getString(0);
                columnName = resultSet.getString(1);
                String type = resultSet.getString(2);
                long cellsMutated = resultSet.getLong(3);
                builder.addColumn(tableName, columnName, type, cellsMutated);
            }
            resultSet = this.readPrimaryKeyInfo(tx);
            while (resultSet.next()) {
                tableName = resultSet.getString(0);
                columnName = resultSet.getString(1);
                String ordering = resultSet.getString(2);
                builder.addKeyPart(tableName, columnName, "DESC".equalsIgnoreCase(ordering));
            }
        }
        c.output((Object)builder.build());
    }

    private ResultSet readTableInfo(ReadOnlyTransaction tx) {
        return tx.executeQuery(Statement.of((String)"SELECT    c.table_name  , c.column_name  , c.spanner_type  , (1 + COALESCE(t.indices, 0)) AS cells_mutated  FROM (    SELECT c.table_name, c.column_name, c.spanner_type, c.ordinal_position     FROM information_schema.columns as c     WHERE c.table_catalog = '' AND c.table_schema = '') AS c  LEFT OUTER JOIN (    SELECT t.table_name, t.column_name, COUNT(*) AS indices      FROM information_schema.index_columns AS t       WHERE t.index_name != 'PRIMARY_KEY' AND t.table_catalog = ''      AND t.table_schema = ''      GROUP BY t.table_name, t.column_name) AS t  USING (table_name, column_name)  ORDER BY c.table_name, c.ordinal_position"), new Options.QueryOption[0]);
    }

    private ResultSet readPrimaryKeyInfo(ReadOnlyTransaction tx) {
        return tx.executeQuery(Statement.of((String)"SELECT t.table_name, t.column_name, t.column_ordering FROM information_schema.index_columns AS t  WHERE t.index_name = 'PRIMARY_KEY' AND t.table_catalog = '' AND t.table_schema = '' ORDER BY t.table_name, t.ordinal_position"), new Options.QueryOption[0]);
    }
}

