/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.wire.Subscriber;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.cloud.pubsublite.proto.Subscription;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.BlockingCommitter;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.InitialOffsetReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.ManagedBacklogReaderFactoryImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteRange;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteRangeTracker;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.PerSubscriptionPartitionSdf;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriberAssembler;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartition;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionLoader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessor;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessorImpl;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TrackerWithProgress;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.math.LongMath;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class SubscribeTransform
extends PTransform<PBegin, PCollection<SequencedMessage>> {
    private static final long MEBIBYTE = 0x100000L;
    private final SubscriberOptions options;

    public SubscribeTransform(SubscriberOptions options) {
        this.options = options;
    }

    private void checkSubscription(SubscriptionPartition subscriptionPartition) throws ApiException {
        UncheckedApiPreconditions.checkArgument((boolean)subscriptionPartition.subscription().equals(this.options.subscriptionPath()));
    }

    private Subscriber newSubscriber(Partition partition, Offset initialOffset, Consumer<List<SequencedMessage>> consumer) {
        try {
            return new SubscriberAssembler(this.options, partition).getSubscriberFactory(initialOffset).newSubscriber(messages -> consumer.accept(messages.stream().map(message -> message.toProto()).collect(Collectors.toList())));
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private SubscriptionPartitionProcessor newPartitionProcessor(SubscriptionPartition subscriptionPartition, RestrictionTracker<OffsetByteRange, OffsetByteProgress> tracker, DoFn.OutputReceiver<SequencedMessage> receiver) throws ApiException {
        this.checkSubscription(subscriptionPartition);
        return new SubscriptionPartitionProcessorImpl(tracker, receiver, consumer -> this.newSubscriber(subscriptionPartition.partition(), Offset.of((long)((OffsetByteRange)tracker.currentRestriction()).getRange().getFrom()), (Consumer<List<SequencedMessage>>)consumer), this.options.flowControlSettings());
    }

    private TopicBacklogReader newBacklogReader(SubscriptionPartition subscriptionPartition) {
        this.checkSubscription(subscriptionPartition);
        return new SubscriberAssembler(this.options, subscriptionPartition.partition()).getBacklogReader();
    }

    private long calculateMinWindowBytes() {
        long minFromFlowControl = LongMath.saturatedMultiply((long)this.options.flowControlSettings().bytesOutstanding(), (long)10L);
        return Math.min(minFromFlowControl, 0x2EE00000L);
    }

    private TrackerWithProgress newRestrictionTracker(TopicBacklogReader backlogReader, OffsetByteRange initial) {
        return new OffsetByteRangeTracker(initial, backlogReader, Stopwatch.createUnstarted(), this.options.minBundleTimeout(), this.calculateMinWindowBytes());
    }

    private InitialOffsetReader newInitialOffsetReader(SubscriptionPartition subscriptionPartition) {
        this.checkSubscription(subscriptionPartition);
        return new SubscriberAssembler(this.options, subscriptionPartition.partition()).getInitialOffsetReader();
    }

    private BlockingCommitter newCommitter(SubscriptionPartition subscriptionPartition) {
        this.checkSubscription(subscriptionPartition);
        return new SubscriberAssembler(this.options, subscriptionPartition.partition()).getCommitter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TopicPath getTopicPath() {
        try (AdminClient admin = AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setRegion(this.options.subscriptionPath().location().extractRegion()).build());){
            TopicPath topicPath = TopicPath.parse((String)((Subscription)admin.getSubscription(this.options.subscriptionPath()).get()).getTopic());
            return topicPath;
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    public PCollection<SequencedMessage> expand(PBegin input) {
        PCollection subscriptionPartitions = (PCollection)input.apply((PTransform)new SubscriptionPartitionLoader(this.getTopicPath(), this.options.subscriptionPath()));
        return (PCollection)subscriptionPartitions.apply((PTransform)ParDo.of((DoFn)new PerSubscriptionPartitionSdf(this.options.minBundleTimeout().plus((ReadableDuration)Duration.standardSeconds((long)5L)), new ManagedBacklogReaderFactoryImpl((SerializableFunction<SubscriptionPartition, TopicBacklogReader>)((SerializableFunction & Serializable)this::newBacklogReader)), (SerializableFunction<SubscriptionPartition, InitialOffsetReader>)((SerializableFunction & Serializable)this::newInitialOffsetReader), (SerializableBiFunction<TopicBacklogReader, OffsetByteRange, TrackerWithProgress>)((SerializableBiFunction & Serializable)this::newRestrictionTracker), this::newPartitionProcessor, (SerializableFunction<SubscriptionPartition, BlockingCommitter>)((SerializableFunction & Serializable)this::newCommitter))));
    }
}

