/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.Mode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.BaseEncoding;

public class TableRowToStorageApiProto {
    static final Map<String, DescriptorProtos.FieldDescriptorProto.Type> PRIMITIVE_TYPES = ImmutableMap.builder().put((Object)"INT64", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)"INTEGER", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)"FLOAT64", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).put((Object)"FLOAT", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).put((Object)"STRING", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)"BOOL", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).put((Object)"BOOLEAN", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).put((Object)"BYTES", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)"NUMERIC", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)"BIGNUMERIC", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)"GEOGRAPHY", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)"DATE", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)"TIME", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)"DATETIME", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)"TIMESTAMP", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)"JSON", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).build();
    private static final Map<Descriptors.FieldDescriptor.Type, Function<String, Object>> JSON_PROTO_STRING_PARSERS = ImmutableMap.builder().put((Object)Descriptors.FieldDescriptor.Type.INT32, Integer::valueOf).put((Object)Descriptors.FieldDescriptor.Type.INT64, Long::valueOf).put((Object)Descriptors.FieldDescriptor.Type.FLOAT, Float::valueOf).put((Object)Descriptors.FieldDescriptor.Type.DOUBLE, Double::valueOf).put((Object)Descriptors.FieldDescriptor.Type.BOOL, Boolean::valueOf).put((Object)Descriptors.FieldDescriptor.Type.STRING, str -> str).put((Object)Descriptors.FieldDescriptor.Type.BYTES, b64 -> ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)b64))).build();

    public static Descriptors.Descriptor getDescriptorFromTableSchema(TableSchema jsonSchema) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.DescriptorProto descriptorProto = TableRowToStorageApiProto.descriptorSchemaFromTableSchema(jsonSchema);
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
        return (Descriptors.Descriptor)Iterables.getOnlyElement((Iterable)fileDescriptor.getMessageTypes());
    }

    public static DynamicMessage messageFromMap(Descriptors.Descriptor descriptor, AbstractMap<String, Object> map) {
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(entry.getKey().toLowerCase());
            if (fieldDescriptor == null) {
                throw new RuntimeException("TableRow contained unexpected field with name " + entry.getKey());
            }
            Object value = TableRowToStorageApiProto.messageValueFromFieldValue(fieldDescriptor, entry.getValue());
            if (value == null) continue;
            builder.setField(fieldDescriptor, value);
        }
        return builder.build();
    }

    public static DynamicMessage messageFromTableRow(Descriptors.Descriptor descriptor, TableRow tableRow) {
        List cells = tableRow.getF();
        if (cells != null) {
            DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
            if (cells.size() > descriptor.getFields().size()) {
                throw new RuntimeException("TableRow contained too many fields");
            }
            for (int i = 0; i < cells.size(); ++i) {
                TableCell cell = (TableCell)cells.get(i);
                Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)descriptor.getFields().get(i);
                Object value = TableRowToStorageApiProto.messageValueFromFieldValue(fieldDescriptor, cell.getV());
                if (value == null) continue;
                builder.setField(fieldDescriptor, value);
            }
            return builder.build();
        }
        return TableRowToStorageApiProto.messageFromMap(descriptor, (AbstractMap<String, Object>)tableRow);
    }

    @VisibleForTesting
    static DescriptorProtos.DescriptorProto descriptorSchemaFromTableSchema(TableSchema tableSchema) {
        return TableRowToStorageApiProto.descriptorSchemaFromTableFieldSchemas(tableSchema.getFields());
    }

    private static DescriptorProtos.DescriptorProto descriptorSchemaFromTableFieldSchemas(Iterable<TableFieldSchema> tableFieldSchemas) {
        DescriptorProtos.DescriptorProto.Builder descriptorBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        descriptorBuilder.setName("D" + UUID.randomUUID().toString().replace("-", "_"));
        int i = 1;
        for (TableFieldSchema fieldSchema : tableFieldSchemas) {
            TableRowToStorageApiProto.fieldDescriptorFromTableField(fieldSchema, i++, descriptorBuilder);
        }
        return descriptorBuilder.build();
    }

    private static void fieldDescriptorFromTableField(TableFieldSchema fieldSchema, int fieldNumber, DescriptorProtos.DescriptorProto.Builder descriptorBuilder) {
        DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
        fieldDescriptorBuilder = fieldDescriptorBuilder.setName(fieldSchema.getName().toLowerCase());
        fieldDescriptorBuilder = fieldDescriptorBuilder.setNumber(fieldNumber);
        switch (fieldSchema.getType()) {
            case "STRUCT": 
            case "RECORD": {
                DescriptorProtos.DescriptorProto nested = TableRowToStorageApiProto.descriptorSchemaFromTableFieldSchemas(fieldSchema.getFields());
                descriptorBuilder.addNestedType(nested);
                fieldDescriptorBuilder = fieldDescriptorBuilder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).setTypeName(nested.getName());
                break;
            }
            default: {
                DescriptorProtos.FieldDescriptorProto.Type type = PRIMITIVE_TYPES.get(fieldSchema.getType());
                if (type == null) {
                    throw new UnsupportedOperationException("Converting BigQuery type " + fieldSchema.getType() + " to Beam type is unsupported");
                }
                fieldDescriptorBuilder = fieldDescriptorBuilder.setType(type);
            }
        }
        Optional<Mode> fieldMode = Optional.ofNullable(fieldSchema.getMode()).map(Mode::valueOf);
        fieldDescriptorBuilder = fieldMode.filter(m -> m == Mode.REPEATED).isPresent() ? fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED) : (!fieldMode.isPresent() || fieldMode.filter(m -> m == Mode.NULLABLE).isPresent() ? fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL) : fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED));
        descriptorBuilder.addField(fieldDescriptorBuilder.build());
    }

    @Nullable
    private static Object messageValueFromFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Object bqValue) {
        if (bqValue == null) {
            if (fieldDescriptor.isOptional()) {
                return null;
            }
            if (fieldDescriptor.isRepeated()) {
                return Collections.emptyList();
            }
            throw new IllegalArgumentException("Received null value for non-nullable field " + fieldDescriptor.getName());
        }
        return TableRowToStorageApiProto.toProtoValue(fieldDescriptor, bqValue, fieldDescriptor.isRepeated());
    }

    @Nullable
    @VisibleForTesting
    static Object toProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object jsonBQValue, boolean isRepeated) {
        if (isRepeated) {
            return ((List)jsonBQValue).stream().map(v -> TableRowToStorageApiProto.toProtoValue(fieldDescriptor, v, false)).collect(Collectors.toList());
        }
        if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            if (jsonBQValue instanceof TableRow) {
                TableRow tableRow = (TableRow)jsonBQValue;
                return TableRowToStorageApiProto.messageFromTableRow(fieldDescriptor.getMessageType(), tableRow);
            }
            if (jsonBQValue instanceof AbstractMap) {
                AbstractMap map = (AbstractMap)jsonBQValue;
                return TableRowToStorageApiProto.messageFromMap(fieldDescriptor.getMessageType(), map);
            }
            throw new RuntimeException("Unexpected value " + jsonBQValue + " Expected a JSON map.");
        }
        Object scalarValue = TableRowToStorageApiProto.scalarToProtoValue(fieldDescriptor, jsonBQValue);
        if (scalarValue == null) {
            return TableRowToStorageApiProto.toProtoValue(fieldDescriptor, jsonBQValue.toString(), isRepeated);
        }
        return scalarValue;
    }

    @Nullable
    @VisibleForTesting
    static Object scalarToProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object jsonBQValue) {
        if (jsonBQValue instanceof String) {
            Function<String, Object> mapper = JSON_PROTO_STRING_PARSERS.get(fieldDescriptor.getType());
            if (mapper == null) {
                throw new UnsupportedOperationException("Converting BigQuery type '" + jsonBQValue.getClass() + "' to '" + fieldDescriptor + "' is not supported");
            }
            return mapper.apply((String)jsonBQValue);
        }
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                if (!(jsonBQValue instanceof Boolean)) break;
                return jsonBQValue;
            }
            case BYTES: {
                break;
            }
            case INT64: {
                if (jsonBQValue instanceof Integer) {
                    return (long)((Integer)jsonBQValue).intValue();
                }
                if (!(jsonBQValue instanceof Long)) break;
                return jsonBQValue;
            }
            case INT32: {
                if (!(jsonBQValue instanceof Integer)) break;
                return jsonBQValue;
            }
            case STRING: {
                break;
            }
            case DOUBLE: {
                if (jsonBQValue instanceof Double) {
                    return jsonBQValue;
                }
                if (!(jsonBQValue instanceof Float)) break;
                return (double)((Float)jsonBQValue).floatValue();
            }
            default: {
                throw new RuntimeException("Unsupported proto type " + fieldDescriptor.getType());
            }
        }
        return null;
    }

    @VisibleForTesting
    public static TableRow tableRowFromMessage(Message message) {
        TableRow tableRow = new TableRow();
        for (Map.Entry field : message.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)field.getKey();
            Object fieldValue = field.getValue();
            tableRow.putIfAbsent((Object)fieldDescriptor.getName(), TableRowToStorageApiProto.jsonValueFromMessageValue(fieldDescriptor, fieldValue, true));
        }
        return tableRow;
    }

    public static Object jsonValueFromMessageValue(Descriptors.FieldDescriptor fieldDescriptor, Object fieldValue, boolean expandRepeated) {
        if (expandRepeated && fieldDescriptor.isRepeated()) {
            List valueList = (List)fieldValue;
            return valueList.stream().map(v -> TableRowToStorageApiProto.jsonValueFromMessageValue(fieldDescriptor, v, false)).collect(Collectors.toList());
        }
        switch (fieldDescriptor.getType()) {
            case GROUP: 
            case MESSAGE: {
                return TableRowToStorageApiProto.tableRowFromMessage((Message)fieldValue);
            }
            case BYTES: {
                return BaseEncoding.base64().encode(((ByteString)fieldValue).toByteArray());
            }
            case ENUM: {
                throw new RuntimeException("Enumerations not supported");
            }
        }
        return fieldValue.toString();
    }
}

