/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.time.Duration;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;

public class StorageApiDynamicDestinationsTableRow<T, DestinationT>
extends StorageApiDynamicDestinations<T, DestinationT> {
    private final SerializableFunction<T, TableRow> formatFunction;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final Cache<DestinationT, Descriptors.Descriptor> destinationDescriptorCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(15L)).build();

    StorageApiDynamicDestinationsTableRow(DynamicDestinations<T, DestinationT> inner, SerializableFunction<T, TableRow> formatFunction, BigQueryIO.Write.CreateDisposition createDisposition) {
        super(inner);
        this.formatFunction = formatFunction;
        this.createDisposition = createDisposition;
    }

    @Override
    public StorageApiDynamicDestinations.MessageConverter<T> getMessageConverter(final DestinationT destination, final BigQueryServices.DatasetService datasetService) throws Exception {
        return new StorageApiDynamicDestinations.MessageConverter<T>(){
            Descriptors.Descriptor descriptor;
            {
                this.descriptor = (Descriptors.Descriptor)StorageApiDynamicDestinationsTableRow.this.destinationDescriptorCache.get(destination, () -> {
                    TableSchema tableSchema = StorageApiDynamicDestinationsTableRow.this.getSchema(destination);
                    if (tableSchema == null) {
                        TableReference tableReference = StorageApiDynamicDestinationsTableRow.this.getTable(destination).getTableReference();
                        Table table = datasetService.getTable(tableReference);
                        if (table == null) {
                            if (StorageApiDynamicDestinationsTableRow.this.createDisposition == BigQueryIO.Write.CreateDisposition.CREATE_NEVER) {
                                throw new RuntimeException("BigQuery table " + tableReference + " not found. If you wanted to automatically create the table, set the create disposition to CREATE_IF_NEEDED and specify a schema.");
                            }
                            throw new RuntimeException("Schema must be set for table " + tableReference + " when writing TableRows using Storage API and using a create disposition of CREATE_IF_NEEDED.");
                        }
                        tableSchema = table.getSchema();
                    }
                    return TableRowToStorageApiProto.getDescriptorFromTableSchema(tableSchema);
                });
            }

            @Override
            public Descriptors.Descriptor getSchemaDescriptor() {
                return this.descriptor;
            }

            @Override
            public Message toMessage(T element) {
                return TableRowToStorageApiProto.messageFromTableRow(this.descriptor, (TableRow)StorageApiDynamicDestinationsTableRow.this.formatFunction.apply(element));
            }
        };
    }
}

