/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Queues;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.joda.time.Duration;

class RetryManager<ResultT, ContextT extends Operation.Context<ResultT>> {
    private Queue<Operation<ResultT, ContextT>> operations = Queues.newArrayDeque();
    private final BackOff backoff;
    private static final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("BeamBQRetryManager-%d").build());

    RetryManager(Duration initialBackoff, Duration maxBackoff, int maxRetries) {
        this.backoff = FluentBackoff.DEFAULT.withInitialBackoff(initialBackoff).withMaxBackoff(maxBackoff).withMaxRetries(maxRetries).backoff();
    }

    void addOperation(Function<ContextT, ApiFuture<ResultT>> runOperation, Function<Iterable<ContextT>, RetryType> onError, Consumer<ContextT> onSuccess, ContextT context) throws Exception {
        this.addOperation(runOperation, onError, onSuccess, r -> true, context);
    }

    void addOperation(Function<ContextT, ApiFuture<ResultT>> runOperation, Function<Iterable<ContextT>, RetryType> onError, Consumer<ContextT> onSuccess, Function<ResultT, Boolean> hasSucceeded, ContextT context) throws Exception {
        this.addOperation(new Operation<ResultT, ContextT>(runOperation, onError, onSuccess, hasSucceeded, context));
    }

    void addAndRunOperation(Function<ContextT, ApiFuture<ResultT>> runOperation, Function<Iterable<ContextT>, RetryType> onError, Consumer<ContextT> onSuccess, ContextT context) throws Exception {
        this.addAndRunOperation(new Operation<Object, ContextT>(runOperation, onError, onSuccess, r -> true, context));
    }

    void addAndRunOperation(Function<ContextT, ApiFuture<ResultT>> runOperation, Function<Iterable<ContextT>, RetryType> onError, Consumer<ContextT> onSuccess, Function<ResultT, Boolean> hasSucceeded, ContextT context) throws Exception {
        this.addAndRunOperation(new Operation<ResultT, ContextT>(runOperation, onError, onSuccess, hasSucceeded, context));
    }

    void addOperation(Operation<ResultT, ContextT> operation) {
        this.operations.add(operation);
    }

    void addAndRunOperation(Operation<ResultT, ContextT> operation) {
        operation.run(executor);
        this.operations.add(operation);
    }

    void run(boolean await) throws Exception {
        for (Operation operation : this.operations) {
            operation.run(executor);
        }
        if (await) {
            this.await();
        }
    }

    void await() throws Exception {
        while (!this.operations.isEmpty()) {
            Operation<ResultT, ContextT> operation = this.operations.element();
            boolean failed = operation.await();
            if (failed) {
                Throwable failure = ((Operation)operation).callback.getFailure();
                ((Operation.Context)operation.context).setError(failure);
                RetryType retryType = (RetryType)((Object)((Operation)operation).onError.apply((Iterable)this.operations.stream().map(o -> o.context).collect(Collectors.toList())));
                if (retryType == RetryType.DONT_RETRY) {
                    this.operations.clear();
                    continue;
                }
                Preconditions.checkState((RetryType.RETRY_ALL_OPERATIONS == retryType ? 1 : 0) != 0);
                if (!BackOffUtils.next((Sleeper)Sleeper.DEFAULT, (BackOff)this.backoff)) {
                    throw new RuntimeException(failure);
                }
                for (Operation operation2 : this.operations) {
                    operation2.await();
                }
                this.run(false);
                continue;
            }
            ((Operation.Context)operation.context).setResult((Object)((Operation)operation).future.get());
            ((Operation)operation).onSuccess.accept(operation.context);
            this.operations.remove();
        }
    }

    private static class Callback<ResultT>
    implements ApiFutureCallback<ResultT> {
        private final CountDownLatch waiter = new CountDownLatch(1);
        private final Function<ResultT, Boolean> hasSucceeded;
        @Nullable
        private Throwable failure = null;
        boolean failed = false;

        Callback(Function<ResultT, Boolean> hasSucceeded) {
            this.hasSucceeded = hasSucceeded;
        }

        void await() throws InterruptedException {
            this.waiter.await();
        }

        boolean await(long timeoutSec) throws InterruptedException {
            return this.waiter.await(timeoutSec, TimeUnit.SECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(Throwable t) {
            Callback callback = this;
            synchronized (callback) {
                this.failure = t;
                this.failed = true;
            }
            this.waiter.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(ResultT result) {
            Callback callback = this;
            synchronized (callback) {
                if (this.hasSucceeded.apply(result).booleanValue()) {
                    this.failure = null;
                } else {
                    this.failure = new WrappedFailure(result);
                    this.failed = true;
                }
            }
            this.waiter.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        Throwable getFailure() {
            Callback callback = this;
            synchronized (callback) {
                return this.failure;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean getFailed() {
            Callback callback = this;
            synchronized (callback) {
                return this.failed;
            }
        }
    }

    static class Operation<ResultT, ContextT extends Context<ResultT>> {
        private final Function<ContextT, ApiFuture<ResultT>> runOperation;
        private final Function<Iterable<ContextT>, RetryType> onError;
        private final Consumer<ContextT> onSuccess;
        private final Function<ResultT, Boolean> hasSucceeded;
        @Nullable
        private ApiFuture<ResultT> future = null;
        @Nullable
        private Callback<ResultT> callback = null;
        @Nullable
        ContextT context = null;

        public Operation(Function<ContextT, ApiFuture<ResultT>> runOperation, Function<Iterable<ContextT>, RetryType> onError, Consumer<ContextT> onSuccess, Function<ResultT, Boolean> hasSucceeded, ContextT context) {
            this.runOperation = runOperation;
            this.onError = onError;
            this.onSuccess = onSuccess;
            this.hasSucceeded = hasSucceeded;
            this.context = context;
        }

        void run(Executor executor) {
            this.future = this.runOperation.apply(this.context);
            this.callback = new Callback<ResultT>(this.hasSucceeded);
            ApiFutures.addCallback(this.future, this.callback, (Executor)executor);
        }

        boolean await() throws Exception {
            this.callback.await();
            return this.callback.getFailed();
        }

        static class Context<ResultT> {
            @Nullable
            private Throwable error = null;
            @Nullable
            private ResultT result = null;

            Context() {
            }

            public void setError(@Nullable Throwable error) {
                this.error = error;
            }

            @Nullable
            public Throwable getError() {
                return this.error;
            }

            public void setResult(@Nullable ResultT result) {
                this.result = result;
            }

            @Nullable
            public ResultT getResult() {
                return this.result;
            }
        }
    }

    static class WrappedFailure
    extends Throwable {
        @Nullable
        private final Object result;

        public WrappedFailure(@Nullable Object result) {
            this.result = result;
        }

        @Nullable
        Object getResult() {
            return this.result;
        }
    }

    static enum RetryType {
        DONT_RETRY,
        RETRY_ALL_OPERATIONS;

    }
}

