/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.Type;
import com.google.common.collect.ArrayListMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerSchema_Column;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerSchema_KeyPart;

class SpannerSchema
implements Serializable {
    private final List<String> tables;
    private final ArrayListMultimap<String, Column> columns;
    private final ArrayListMultimap<String, KeyPart> keyParts;

    public static Builder builder() {
        return new Builder();
    }

    private SpannerSchema(ArrayListMultimap<String, Column> columns, ArrayListMultimap<String, KeyPart> keyParts) {
        this.columns = columns;
        this.keyParts = keyParts;
        this.tables = new ArrayList<String>(columns.keySet());
    }

    public List<String> getTables() {
        return this.tables;
    }

    public List<Column> getColumns(String table) {
        return this.columns.get((Object)table);
    }

    public List<KeyPart> getKeyParts(String table) {
        return this.keyParts.get((Object)table);
    }

    @AutoValue
    static abstract class Column
    implements Serializable {
        Column() {
        }

        static Column create(String name, Type type) {
            return new AutoValue_SpannerSchema_Column(name, type);
        }

        static Column create(String name, String spannerType) {
            return Column.create(name, Column.parseSpannerType(spannerType));
        }

        public abstract String getName();

        public abstract Type getType();

        private static Type parseSpannerType(String spannerType) {
            if ((spannerType = spannerType.toUpperCase()).equals("BOOL")) {
                return Type.bool();
            }
            if (spannerType.equals("INT64")) {
                return Type.int64();
            }
            if (spannerType.equals("FLOAT64")) {
                return Type.float64();
            }
            if (spannerType.startsWith("STRING")) {
                return Type.string();
            }
            if (spannerType.startsWith("BYTES")) {
                return Type.bytes();
            }
            if (spannerType.equals("TIMESTAMP")) {
                return Type.timestamp();
            }
            if (spannerType.equals("DATE")) {
                return Type.date();
            }
            if (spannerType.startsWith("ARRAY")) {
                String spannerArrayType = spannerType.substring(6, spannerType.length() - 1);
                Type itemType = Column.parseSpannerType(spannerArrayType);
                return Type.array((Type)itemType);
            }
            throw new IllegalArgumentException("Unknown spanner type " + spannerType);
        }
    }

    @AutoValue
    static abstract class KeyPart
    implements Serializable {
        KeyPart() {
        }

        static KeyPart create(String field, boolean desc) {
            return new AutoValue_SpannerSchema_KeyPart(field, desc);
        }

        abstract String getField();

        abstract boolean isDesc();
    }

    static class Builder {
        private final ArrayListMultimap<String, Column> columns = ArrayListMultimap.create();
        private final ArrayListMultimap<String, KeyPart> keyParts = ArrayListMultimap.create();

        Builder() {
        }

        public Builder addColumn(String table, String name, String type) {
            this.addColumn(table, Column.create(name.toLowerCase(), type));
            return this;
        }

        private Builder addColumn(String table, Column column) {
            this.columns.put((Object)table.toLowerCase(), (Object)column);
            return this;
        }

        public Builder addKeyPart(String table, String column, boolean desc) {
            this.keyParts.put((Object)table, (Object)KeyPart.create(column.toLowerCase(), desc));
            return this;
        }

        public SpannerSchema build() {
            return new SpannerSchema(this.columns, this.keyParts);
        }
    }
}

