/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteTables<DestinationT>
extends PTransform<PCollection<KV<ShardedKey<DestinationT>, List<String>>>, PCollection<KV<TableDestination, String>>> {
    private static final Logger LOG = LoggerFactory.getLogger(WriteTables.class);
    private final boolean singlePartition;
    private final BigQueryServices bqServices;
    private final PCollectionView<String> jobIdToken;
    private final BigQueryIO.Write.WriteDisposition firstPaneWriteDisposition;
    private final BigQueryIO.Write.CreateDisposition firstPaneCreateDisposition;
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;
    private final List<PCollectionView<?>> sideInputs;
    private final TupleTag<KV<TableDestination, String>> mainOutputTag;
    private final TupleTag<String> temporaryFilesTag;

    public WriteTables(boolean singlePartition, BigQueryServices bqServices, PCollectionView<String> jobIdToken, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, List<PCollectionView<?>> sideInputs, DynamicDestinations<?, DestinationT> dynamicDestinations) {
        this.singlePartition = singlePartition;
        this.bqServices = bqServices;
        this.jobIdToken = jobIdToken;
        this.firstPaneWriteDisposition = writeDisposition;
        this.firstPaneCreateDisposition = createDisposition;
        this.sideInputs = sideInputs;
        this.dynamicDestinations = dynamicDestinations;
        this.mainOutputTag = new TupleTag("WriteTablesMainOutput");
        this.temporaryFilesTag = new TupleTag("TemporaryFiles");
    }

    public PCollection<KV<TableDestination, String>> expand(PCollection<KV<ShardedKey<DestinationT>, List<String>>> input) {
        PCollectionTuple writeTablesOutputs = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new WriteTablesDoFn()).withSideInputs(this.sideInputs).withOutputTags(this.mainOutputTag, TupleTagList.of(this.temporaryFilesTag)));
        ((PCollection)((PCollection)((PCollection)((PCollection)writeTablesOutputs.get(this.temporaryFilesTag).setCoder((Coder)StringUtf8Coder.of()).apply((PTransform)WithKeys.of((Object)null))).setCoder((Coder)KvCoder.of((Coder)VoidCoder.of(), (Coder)StringUtf8Coder.of())).apply((PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)1))).discardingFiredPanes())).apply((PTransform)GroupByKey.create())).apply((PTransform)Values.create())).apply((PTransform)ParDo.of((DoFn)new GarbageCollectTemporaryFiles()));
        return writeTablesOutputs.get(this.mainOutputTag);
    }

    private void load(BigQueryServices.JobService jobService, BigQueryServices.DatasetService datasetService, String jobIdPrefix, TableReference ref, TimePartitioning timePartitioning, @Nullable TableSchema schema, List<String> gcsUris, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, @Nullable String tableDescription) throws InterruptedException, IOException {
        JobConfigurationLoad loadConfig = new JobConfigurationLoad().setDestinationTable(ref).setSchema(schema).setSourceUris(gcsUris).setWriteDisposition(writeDisposition.name()).setCreateDisposition(createDisposition.name()).setSourceFormat("NEWLINE_DELIMITED_JSON");
        if (timePartitioning != null) {
            loadConfig.setTimePartitioning(timePartitioning);
        }
        String projectId = ref.getProjectId();
        Job lastFailedLoadJob = null;
        block5: for (int i = 0; i < 3; ++i) {
            String jobId = jobIdPrefix + "-" + i;
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId);
            jobService.startLoadJob(jobRef, loadConfig);
            Job loadJob = jobService.pollJob(jobRef, Integer.MAX_VALUE);
            BigQueryHelpers.Status jobStatus = BigQueryHelpers.parseStatus(loadJob);
            switch (jobStatus) {
                case SUCCEEDED: {
                    if (tableDescription != null) {
                        datasetService.patchTableDescription(ref.clone().setTableId(BigQueryHelpers.stripPartitionDecorator(ref.getTableId())), tableDescription);
                    }
                    return;
                }
                case UNKNOWN: {
                    throw new RuntimeException(String.format("UNKNOWN status of load job [%s]: %s.", jobId, BigQueryHelpers.jobToPrettyString(loadJob)));
                }
                case FAILED: {
                    lastFailedLoadJob = loadJob;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected status [%s] of load job: %s.", new Object[]{jobStatus, BigQueryHelpers.jobToPrettyString(loadJob)}));
                }
            }
        }
        throw new RuntimeException(String.format("Failed to create load job with id prefix %s, reached max retries: %d, last failed load job: %s.", jobIdPrefix, 3, BigQueryHelpers.jobToPrettyString(lastFailedLoadJob)));
    }

    static void removeTemporaryFiles(Iterable<String> files) throws IOException {
        ImmutableList.Builder fileResources = ImmutableList.builder();
        for (String file : files) {
            fileResources.add((Object)FileSystems.matchNewResource((String)file, (boolean)false));
        }
        FileSystems.delete((Collection)fileResources.build(), (MoveOptions[])new MoveOptions[0]);
    }

    private class GarbageCollectTemporaryFiles
    extends DoFn<Iterable<String>, Void> {
        private GarbageCollectTemporaryFiles() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            WriteTables.removeTemporaryFiles((Iterable)c.element());
        }
    }

    private class WriteTablesDoFn
    extends DoFn<KV<ShardedKey<DestinationT>, List<String>>, KV<TableDestination, String>> {
        private Map<DestinationT, String> jsonSchemas = Maps.newHashMap();

        private WriteTablesDoFn() {
        }

        @DoFn.StartBundle
        public void startBundle(DoFn.StartBundleContext c) {
            this.jsonSchemas.clear();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            TableSchema tableSchema;
            WriteTables.this.dynamicDestinations.setSideInputAccessorFromProcessContext(c);
            Object destination = ((ShardedKey)((KV)c.element()).getKey()).getKey();
            if (WriteTables.this.firstPaneCreateDisposition == BigQueryIO.Write.CreateDisposition.CREATE_NEVER) {
                tableSchema = null;
            } else if (this.jsonSchemas.containsKey(destination)) {
                tableSchema = BigQueryHelpers.fromJsonString(this.jsonSchemas.get(destination), TableSchema.class);
            } else {
                tableSchema = WriteTables.this.dynamicDestinations.getSchema(destination);
                Preconditions.checkArgument((tableSchema != null ? 1 : 0) != 0, (String)"Unless create disposition is %s, a schema must be specified, i.e. DynamicDestinations.getSchema() may not return null. However, create disposition is %s, and %s returned null for destination %s", (Object)((Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER), (Object)((Object)WriteTables.this.firstPaneCreateDisposition), (Object)WriteTables.this.dynamicDestinations, (Object)destination);
                this.jsonSchemas.put(destination, BigQueryHelpers.toJsonString(tableSchema));
            }
            TableDestination tableDestination = WriteTables.this.dynamicDestinations.getTable(destination);
            Preconditions.checkArgument((tableDestination != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may not return null, but %s returned null for destination %s", (Object)WriteTables.this.dynamicDestinations, (Object)destination);
            TableReference tableReference = tableDestination.getTableReference();
            if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
                tableReference.setProjectId(((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)).getProject());
                tableDestination = new TableDestination(tableReference, tableDestination.getTableDescription());
            }
            Integer partition = ((ShardedKey)((KV)c.element()).getKey()).getShardNumber();
            ArrayList partitionFiles = Lists.newArrayList((Iterable)((Iterable)((KV)c.element()).getValue()));
            String jobIdPrefix = BigQueryHelpers.createJobId((String)c.sideInput(WriteTables.this.jobIdToken), tableDestination, partition, c.pane().getIndex());
            if (!WriteTables.this.singlePartition) {
                tableReference.setTableId(jobIdPrefix);
            }
            BigQueryIO.Write.WriteDisposition writeDisposition = c.pane().getIndex() == 0L ? WriteTables.this.firstPaneWriteDisposition : BigQueryIO.Write.WriteDisposition.WRITE_APPEND;
            BigQueryIO.Write.CreateDisposition createDisposition = c.pane().getIndex() == 0L ? WriteTables.this.firstPaneCreateDisposition : BigQueryIO.Write.CreateDisposition.CREATE_NEVER;
            WriteTables.this.load(WriteTables.this.bqServices.getJobService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)), WriteTables.this.bqServices.getDatasetService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)), jobIdPrefix, tableReference, tableDestination.getTimePartitioning(), tableSchema, partitionFiles, writeDisposition, createDisposition, tableDestination.getTableDescription());
            c.output(WriteTables.this.mainOutputTag, (Object)KV.of((Object)tableDestination, (Object)BigQueryHelpers.toJsonString(tableReference)));
            for (String file : partitionFiles) {
                c.output(WriteTables.this.temporaryFilesTag, (Object)file);
            }
        }
    }
}

