/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.WriteBundlesToFiles;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ShardedKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteGroupedRecordsToFiles<DestinationT>
extends DoFn<KV<ShardedKey<DestinationT>, Iterable<TableRow>>, WriteBundlesToFiles.Result<DestinationT>> {
    private static final Logger LOG = LoggerFactory.getLogger(WriteGroupedRecordsToFiles.class);
    private final PCollectionView<String> tempFilePrefix;
    private final long maxFileSize;

    WriteGroupedRecordsToFiles(PCollectionView<String> tempFilePrefix, long maxFileSize) {
        this.tempFilePrefix = tempFilePrefix;
        this.maxFileSize = maxFileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        String tempFilePrefix = (String)c.sideInput(this.tempFilePrefix);
        try (TableRowWriter writer = new TableRowWriter(tempFilePrefix);){
            for (TableRow tableRow : (Iterable)((KV)c.element()).getValue()) {
                if (writer.getByteSize() > this.maxFileSize) {
                    writer.close();
                    writer = new TableRowWriter(tempFilePrefix);
                    TableRowWriter.Result result = writer.getResult();
                    c.output(new WriteBundlesToFiles.Result<Object>(result.resourceId.toString(), result.byteSize, ((ShardedKey)((KV)c.element()).getKey()).getKey()));
                }
                writer.write(tableRow);
            }
        }
        TableRowWriter.Result result = writer.getResult();
        c.output(new WriteBundlesToFiles.Result<Object>(result.resourceId.toString(), result.byteSize, ((ShardedKey)((KV)c.element()).getKey()).getKey()));
    }
}

