/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.TableReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
class BigQueryQuerySource<T>
extends BigQuerySourceBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryQuerySource.class);
    private final ValueProvider<String> query;
    private final Boolean flattenResults;
    private final Boolean useLegacySql;
    private transient AtomicReference<JobStatistics> dryRunJobStats;

    static <T> BigQueryQuerySource<T> create(String stepUuid, ValueProvider<String> query, Boolean flattenResults, Boolean useLegacySql, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<SchemaAndRecord, T> parseFn) {
        return new BigQueryQuerySource<T>(stepUuid, query, flattenResults, useLegacySql, bqServices, coder, parseFn);
    }

    private BigQueryQuerySource(String stepUuid, ValueProvider<String> query, Boolean flattenResults, Boolean useLegacySql, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<SchemaAndRecord, T> parseFn) {
        super(stepUuid, bqServices, coder, parseFn);
        this.query = (ValueProvider)Preconditions.checkNotNull(query, (Object)"query");
        this.flattenResults = (Boolean)Preconditions.checkNotNull((Object)flattenResults, (Object)"flattenResults");
        this.useLegacySql = (Boolean)Preconditions.checkNotNull((Object)useLegacySql, (Object)"useLegacySql");
        this.dryRunJobStats = new AtomicReference();
    }

    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        return this.dryRunQueryIfNeeded(bqOptions).getTotalBytesProcessed();
    }

    @Override
    protected TableReference getTableToExtract(BigQueryOptions bqOptions) throws IOException, InterruptedException {
        String location = null;
        List referencedTables = this.dryRunQueryIfNeeded(bqOptions).getQuery().getReferencedTables();
        BigQueryServices.DatasetService tableService = this.bqServices.getDatasetService(bqOptions);
        if (referencedTables != null && !referencedTables.isEmpty()) {
            TableReference queryTable = (TableReference)referencedTables.get(0);
            location = tableService.getTable(queryTable).getLocation();
        }
        TableReference tableToExtract = BigQueryHelpers.createTempTableReference(bqOptions.getProject(), BigQueryHelpers.createJobIdToken(bqOptions.getJobName(), this.stepUuid));
        LOG.info("Creating temporary dataset {} for query results", (Object)tableToExtract.getDatasetId());
        tableService.createDataset(tableToExtract.getProjectId(), tableToExtract.getDatasetId(), location, "Temporary tables for query results of job " + bqOptions.getJobName(), 86400000L);
        String queryJobId = BigQueryHelpers.createJobIdToken(bqOptions.getJobName(), this.stepUuid) + "-query";
        LOG.info("Exporting query results into temporary table {} using job {}", (Object)tableToExtract, (Object)queryJobId);
        this.executeQuery(bqOptions.getProject(), queryJobId, tableToExtract, this.bqServices.getJobService(bqOptions));
        LOG.info("Query job {} completed", (Object)queryJobId);
        return tableToExtract;
    }

    @Override
    protected void cleanupTempResource(BigQueryOptions bqOptions) throws Exception {
        TableReference tableToRemove = BigQueryHelpers.createTempTableReference(bqOptions.getProject(), BigQueryHelpers.createJobIdToken(bqOptions.getJobName(), this.stepUuid));
        BigQueryServices.DatasetService tableService = this.bqServices.getDatasetService(bqOptions);
        LOG.info("Deleting temporary table with query results {}", (Object)tableToRemove);
        tableService.deleteTable(tableToRemove);
        LOG.info("Deleting temporary dataset with query results {}", (Object)tableToRemove.getDatasetId());
        tableService.deleteDataset(tableToRemove.getProjectId(), tableToRemove.getDatasetId());
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"query", this.query));
    }

    private synchronized JobStatistics dryRunQueryIfNeeded(BigQueryOptions bqOptions) throws InterruptedException, IOException {
        if (this.dryRunJobStats.get() == null) {
            JobStatistics jobStats = this.bqServices.getJobService(bqOptions).dryRunQuery(bqOptions.getProject(), this.createBasicQueryConfig());
            this.dryRunJobStats.compareAndSet(null, jobStats);
        }
        return this.dryRunJobStats.get();
    }

    private void executeQuery(String executingProject, String jobId, TableReference destinationTable, BigQueryServices.JobService jobService) throws IOException, InterruptedException {
        JobReference jobRef = new JobReference().setProjectId(executingProject).setJobId(jobId);
        JobConfigurationQuery queryConfig = this.createBasicQueryConfig().setAllowLargeResults(Boolean.valueOf(true)).setCreateDisposition("CREATE_IF_NEEDED").setDestinationTable(destinationTable).setPriority("BATCH").setWriteDisposition("WRITE_EMPTY");
        jobService.startQueryJob(jobRef, queryConfig);
        Job job = jobService.pollJob(jobRef, Integer.MAX_VALUE);
        if (BigQueryHelpers.parseStatus(job) != BigQueryHelpers.Status.SUCCEEDED) {
            throw new IOException(String.format("Query job %s failed, status: %s.", jobId, BigQueryHelpers.statusToPrettyString(job.getStatus())));
        }
    }

    private JobConfigurationQuery createBasicQueryConfig() {
        return new JobConfigurationQuery().setFlattenResults(this.flattenResults).setQuery((String)this.query.get()).setUseLegacySql(this.useLegacySql);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.dryRunJobStats = new AtomicReference();
    }
}

