/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsublite.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReader;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Stopwatch;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

class OffsetByteRangeTracker
extends RestrictionTracker<OffsetRange, OffsetByteProgress>
implements RestrictionTracker.HasProgress {
    private final @UnknownKeyFor @NonNull @Initialized TopicBacklogReader backlogReader;
    private final @UnknownKeyFor @NonNull @Initialized Duration minTrackingTime;
    private final @UnknownKeyFor @NonNull @Initialized long minBytesReceived;
    private final @UnknownKeyFor @NonNull @Initialized Stopwatch stopwatch;
    private @UnknownKeyFor @NonNull @Initialized OffsetRange range;
    @Nullable
    private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long lastClaimed;
    private @UnknownKeyFor @NonNull @Initialized long byteCount = 0L;

    public OffsetByteRangeTracker(@UnknownKeyFor @NonNull @Initialized OffsetRange range, @UnknownKeyFor @NonNull @Initialized TopicBacklogReader backlogReader, @UnknownKeyFor @NonNull @Initialized Stopwatch stopwatch, @UnknownKeyFor @NonNull @Initialized Duration minTrackingTime, @UnknownKeyFor @NonNull @Initialized long minBytesReceived) {
        Preconditions.checkArgument((range.getTo() == Long.MAX_VALUE ? 1 : 0) != 0);
        this.backlogReader = backlogReader;
        this.minTrackingTime = minTrackingTime;
        this.minBytesReceived = minBytesReceived;
        this.stopwatch = stopwatch.reset().start();
        this.range = range;
    }

    public void finalize() {
        this.backlogReader.close();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
        return RestrictionTracker.IsBounded.UNBOUNDED;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized OffsetByteProgress position) {
        long toClaim = position.lastOffset().value();
        Preconditions.checkArgument((this.lastClaimed == null || toClaim > this.lastClaimed ? 1 : 0) != 0, (String)"Trying to claim offset %s while last attempted was %s", (long)position.lastOffset().value(), (Object)this.lastClaimed);
        Preconditions.checkArgument((toClaim >= this.range.getFrom() ? 1 : 0) != 0, (String)"Trying to claim offset %s before start of the range %s", (long)toClaim, (Object)this.range);
        if (this.range.getTo() != Long.MAX_VALUE) {
            boolean isRangeEmpty = this.range.getTo() == this.range.getFrom();
            boolean isValidClosedRange = this.nextOffset() == this.range.getTo();
            Preconditions.checkState((isRangeEmpty || isValidClosedRange ? 1 : 0) != 0, (Object)"Violated class precondition: offset range improperly split. Please report a beam bug.");
            return false;
        }
        this.lastClaimed = toClaim;
        this.byteCount += position.batchBytes();
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized OffsetRange currentRestriction() {
        return this.range;
    }

    private @UnknownKeyFor @NonNull @Initialized long nextOffset() {
        Preconditions.checkState((this.lastClaimed == null || this.lastClaimed < Long.MAX_VALUE ? 1 : 0) != 0);
        return this.lastClaimed == null ? this.currentRestriction().getFrom() : this.lastClaimed + 1L;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean receivedEnough() {
        Duration duration = Duration.millis((long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
        if (duration.isLongerThan((ReadableDuration)this.minTrackingTime)) {
            return true;
        }
        return this.byteCount >= this.minBytesReceived;
    }

    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized OffsetRange> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
        if (this.range.getTo() != Long.MAX_VALUE) {
            return null;
        }
        if (!this.receivedEnough()) {
            return null;
        }
        this.range = new OffsetRange(this.currentRestriction().getFrom(), this.nextOffset());
        return SplitResult.of((Object)this.range, (Object)new OffsetRange(this.nextOffset(), Long.MAX_VALUE));
    }

    public void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
        if (this.range.getFrom() == this.range.getTo()) {
            return;
        }
        Preconditions.checkState((this.lastClaimed != null ? 1 : 0) != 0, (String)"Last attempted offset should not be null. No work was claimed in non-empty range %s.", (Object)this.range);
        long lastClaimedNotNull = (Long)Preconditions.checkNotNull((Object)this.lastClaimed);
        Preconditions.checkState((lastClaimedNotNull >= this.range.getTo() - 1L ? 1 : 0) != 0, (String)"Last attempted offset was %s in range %s, claiming work in [%s, %s) was not attempted", (Object)lastClaimedNotNull, (Object)this.range, (Object)(lastClaimedNotNull + 1L), (Object)this.range.getTo());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress() {
        ComputeMessageStatsResponse stats = this.backlogReader.computeMessageStats(Offset.of((long)this.nextOffset()));
        return RestrictionTracker.Progress.from((double)this.byteCount, (double)stats.getMessageBytes());
    }
}

