/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessageToRow;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubSchemaIOProvider;
import org.apache.beam.sdk.schemas.Schema;

final class AutoValue_PubsubMessageToRow
extends PubsubMessageToRow {
    private final Schema messageSchema;
    private final boolean useDlq;
    private final boolean useFlatSchema;
    private final PubsubSchemaIOProvider.PayloadFormat payloadFormat;

    private AutoValue_PubsubMessageToRow(Schema messageSchema, boolean useDlq, boolean useFlatSchema, PubsubSchemaIOProvider.PayloadFormat payloadFormat) {
        this.messageSchema = messageSchema;
        this.useDlq = useDlq;
        this.useFlatSchema = useFlatSchema;
        this.payloadFormat = payloadFormat;
    }

    @Override
    public Schema messageSchema() {
        return this.messageSchema;
    }

    @Override
    public boolean useDlq() {
        return this.useDlq;
    }

    @Override
    public boolean useFlatSchema() {
        return this.useFlatSchema;
    }

    @Override
    public PubsubSchemaIOProvider.PayloadFormat payloadFormat() {
        return this.payloadFormat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PubsubMessageToRow) {
            PubsubMessageToRow that = (PubsubMessageToRow)o;
            return this.messageSchema.equals((Object)that.messageSchema()) && this.useDlq == that.useDlq() && this.useFlatSchema == that.useFlatSchema() && this.payloadFormat.equals((Object)that.payloadFormat());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.messageSchema.hashCode();
        h$ *= 1000003;
        h$ ^= this.useDlq ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.useFlatSchema ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.payloadFormat.hashCode();
    }

    static final class Builder
    extends PubsubMessageToRow.Builder {
        private Schema messageSchema;
        private Boolean useDlq;
        private Boolean useFlatSchema;
        private PubsubSchemaIOProvider.PayloadFormat payloadFormat;

        Builder() {
        }

        @Override
        public PubsubMessageToRow.Builder messageSchema(Schema messageSchema) {
            if (messageSchema == null) {
                throw new NullPointerException("Null messageSchema");
            }
            this.messageSchema = messageSchema;
            return this;
        }

        @Override
        public PubsubMessageToRow.Builder useDlq(boolean useDlq) {
            this.useDlq = useDlq;
            return this;
        }

        @Override
        public PubsubMessageToRow.Builder useFlatSchema(boolean useFlatSchema) {
            this.useFlatSchema = useFlatSchema;
            return this;
        }

        @Override
        public PubsubMessageToRow.Builder payloadFormat(PubsubSchemaIOProvider.PayloadFormat payloadFormat) {
            if (payloadFormat == null) {
                throw new NullPointerException("Null payloadFormat");
            }
            this.payloadFormat = payloadFormat;
            return this;
        }

        @Override
        public PubsubMessageToRow build() {
            String missing = "";
            if (this.messageSchema == null) {
                missing = missing + " messageSchema";
            }
            if (this.useDlq == null) {
                missing = missing + " useDlq";
            }
            if (this.useFlatSchema == null) {
                missing = missing + " useFlatSchema";
            }
            if (this.payloadFormat == null) {
                missing = missing + " payloadFormat";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PubsubMessageToRow(this.messageSchema, this.useDlq, this.useFlatSchema, this.payloadFormat);
        }
    }
}

