/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.Clock;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_PubsubIO_Read<T>
extends PubsubIO.Read<T> {
    private final @Nullable ValueProvider<PubsubIO.PubsubTopic> topicProvider;
    private final PubsubClient.PubsubClientFactory pubsubClientFactory;
    private final @Nullable ValueProvider<PubsubIO.PubsubSubscription> subscriptionProvider;
    private final @Nullable String timestampAttribute;
    private final @Nullable String idAttribute;
    private final Coder<T> coder;
    private final @Nullable SerializableFunction<PubsubMessage, T> parseFn;
    private final @Nullable Schema beamSchema;
    private final @Nullable TypeDescriptor<T> typeDescriptor;
    private final @Nullable SerializableFunction<T, Row> toRowFn;
    private final @Nullable SerializableFunction<Row, T> fromRowFn;
    private final @Nullable Clock clock;
    private final boolean needsAttributes;
    private final boolean needsMessageId;

    private AutoValue_PubsubIO_Read(@Nullable ValueProvider<PubsubIO.PubsubTopic> topicProvider, PubsubClient.PubsubClientFactory pubsubClientFactory, @Nullable ValueProvider<PubsubIO.PubsubSubscription> subscriptionProvider, @Nullable String timestampAttribute, @Nullable String idAttribute, Coder<T> coder, @Nullable SerializableFunction<PubsubMessage, T> parseFn, @Nullable Schema beamSchema, @Nullable TypeDescriptor<T> typeDescriptor, @Nullable SerializableFunction<T, Row> toRowFn, @Nullable SerializableFunction<Row, T> fromRowFn, @Nullable Clock clock, boolean needsAttributes, boolean needsMessageId) {
        this.topicProvider = topicProvider;
        this.pubsubClientFactory = pubsubClientFactory;
        this.subscriptionProvider = subscriptionProvider;
        this.timestampAttribute = timestampAttribute;
        this.idAttribute = idAttribute;
        this.coder = coder;
        this.parseFn = parseFn;
        this.beamSchema = beamSchema;
        this.typeDescriptor = typeDescriptor;
        this.toRowFn = toRowFn;
        this.fromRowFn = fromRowFn;
        this.clock = clock;
        this.needsAttributes = needsAttributes;
        this.needsMessageId = needsMessageId;
    }

    @Override
    @Nullable ValueProvider<PubsubIO.PubsubTopic> getTopicProvider() {
        return this.topicProvider;
    }

    @Override
    PubsubClient.PubsubClientFactory getPubsubClientFactory() {
        return this.pubsubClientFactory;
    }

    @Override
    @Nullable ValueProvider<PubsubIO.PubsubSubscription> getSubscriptionProvider() {
        return this.subscriptionProvider;
    }

    @Override
    @Nullable String getTimestampAttribute() {
        return this.timestampAttribute;
    }

    @Override
    @Nullable String getIdAttribute() {
        return this.idAttribute;
    }

    @Override
    Coder<T> getCoder() {
        return this.coder;
    }

    @Override
    @Nullable SerializableFunction<PubsubMessage, T> getParseFn() {
        return this.parseFn;
    }

    @Override
    @Experimental(value=Experimental.Kind.SCHEMAS)
    @Nullable Schema getBeamSchema() {
        return this.beamSchema;
    }

    @Override
    @Nullable TypeDescriptor<T> getTypeDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    @Nullable SerializableFunction<T, Row> getToRowFn() {
        return this.toRowFn;
    }

    @Override
    @Nullable SerializableFunction<Row, T> getFromRowFn() {
        return this.fromRowFn;
    }

    @Override
    @Nullable Clock getClock() {
        return this.clock;
    }

    @Override
    boolean getNeedsAttributes() {
        return this.needsAttributes;
    }

    @Override
    boolean getNeedsMessageId() {
        return this.needsMessageId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PubsubIO.Read) {
            PubsubIO.Read that = (PubsubIO.Read)((Object)o);
            return (this.topicProvider == null ? that.getTopicProvider() == null : this.topicProvider.equals(that.getTopicProvider())) && this.pubsubClientFactory.equals(that.getPubsubClientFactory()) && (this.subscriptionProvider == null ? that.getSubscriptionProvider() == null : this.subscriptionProvider.equals(that.getSubscriptionProvider())) && (this.timestampAttribute == null ? that.getTimestampAttribute() == null : this.timestampAttribute.equals(that.getTimestampAttribute())) && (this.idAttribute == null ? that.getIdAttribute() == null : this.idAttribute.equals(that.getIdAttribute())) && this.coder.equals(that.getCoder()) && (this.parseFn == null ? that.getParseFn() == null : this.parseFn.equals(that.getParseFn())) && (this.beamSchema == null ? that.getBeamSchema() == null : this.beamSchema.equals((Object)that.getBeamSchema())) && (this.typeDescriptor == null ? that.getTypeDescriptor() == null : this.typeDescriptor.equals(that.getTypeDescriptor())) && (this.toRowFn == null ? that.getToRowFn() == null : this.toRowFn.equals(that.getToRowFn())) && (this.fromRowFn == null ? that.getFromRowFn() == null : this.fromRowFn.equals(that.getFromRowFn())) && (this.clock == null ? that.getClock() == null : this.clock.equals(that.getClock())) && this.needsAttributes == that.getNeedsAttributes() && this.needsMessageId == that.getNeedsMessageId();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.topicProvider == null ? 0 : this.topicProvider.hashCode();
        h$ *= 1000003;
        h$ ^= this.pubsubClientFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.subscriptionProvider == null ? 0 : this.subscriptionProvider.hashCode();
        h$ *= 1000003;
        h$ ^= this.timestampAttribute == null ? 0 : this.timestampAttribute.hashCode();
        h$ *= 1000003;
        h$ ^= this.idAttribute == null ? 0 : this.idAttribute.hashCode();
        h$ *= 1000003;
        h$ ^= this.coder.hashCode();
        h$ *= 1000003;
        h$ ^= this.parseFn == null ? 0 : this.parseFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.beamSchema == null ? 0 : this.beamSchema.hashCode();
        h$ *= 1000003;
        h$ ^= this.typeDescriptor == null ? 0 : this.typeDescriptor.hashCode();
        h$ *= 1000003;
        h$ ^= this.toRowFn == null ? 0 : this.toRowFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.fromRowFn == null ? 0 : this.fromRowFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.clock == null ? 0 : this.clock.hashCode();
        h$ *= 1000003;
        h$ ^= this.needsAttributes ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.needsMessageId ? 1231 : 1237;
    }

    @Override
    PubsubIO.Read.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends PubsubIO.Read.Builder<T> {
        private @Nullable ValueProvider<PubsubIO.PubsubTopic> topicProvider;
        private PubsubClient.PubsubClientFactory pubsubClientFactory;
        private @Nullable ValueProvider<PubsubIO.PubsubSubscription> subscriptionProvider;
        private @Nullable String timestampAttribute;
        private @Nullable String idAttribute;
        private Coder<T> coder;
        private @Nullable SerializableFunction<PubsubMessage, T> parseFn;
        private @Nullable Schema beamSchema;
        private @Nullable TypeDescriptor<T> typeDescriptor;
        private @Nullable SerializableFunction<T, Row> toRowFn;
        private @Nullable SerializableFunction<Row, T> fromRowFn;
        private @Nullable Clock clock;
        private Boolean needsAttributes;
        private Boolean needsMessageId;

        Builder() {
        }

        private Builder(PubsubIO.Read<T> source) {
            this.topicProvider = source.getTopicProvider();
            this.pubsubClientFactory = source.getPubsubClientFactory();
            this.subscriptionProvider = source.getSubscriptionProvider();
            this.timestampAttribute = source.getTimestampAttribute();
            this.idAttribute = source.getIdAttribute();
            this.coder = source.getCoder();
            this.parseFn = source.getParseFn();
            this.beamSchema = source.getBeamSchema();
            this.typeDescriptor = source.getTypeDescriptor();
            this.toRowFn = source.getToRowFn();
            this.fromRowFn = source.getFromRowFn();
            this.clock = source.getClock();
            this.needsAttributes = source.getNeedsAttributes();
            this.needsMessageId = source.getNeedsMessageId();
        }

        @Override
        PubsubIO.Read.Builder<T> setTopicProvider(ValueProvider<PubsubIO.PubsubTopic> topicProvider) {
            this.topicProvider = topicProvider;
            return this;
        }

        @Override
        PubsubIO.Read.Builder<T> setPubsubClientFactory(PubsubClient.PubsubClientFactory pubsubClientFactory) {
            if (pubsubClientFactory == null) {
                throw new NullPointerException("Null pubsubClientFactory");
            }
            this.pubsubClientFactory = pubsubClientFactory;
            return this;
        }

        @Override
        PubsubIO.Read.Builder<T> setSubscriptionProvider(ValueProvider<PubsubIO.PubsubSubscription> subscriptionProvider) {
            this.subscriptionProvider = subscriptionProvider;
            return this;
        }

        @Override
        PubsubIO.Read.Builder<T> setTimestampAttribute(String timestampAttribute) {
            this.timestampAttribute = timestampAttribute;
            return this;
        }

        @Override
        PubsubIO.Read.Builder<T> setIdAttribute(String idAttribute) {
            this.idAttribute = idAttribute;
            return this;
        }

        @Override
        PubsubIO.Read.Builder<T> setCoder(Coder<T> coder) {
            if (coder == null) {
                throw new NullPointerException("Null coder");
            }
            this.coder = coder;
            return this;
        }

        @Override
        PubsubIO.Read.Builder<T> setParseFn(SerializableFunction<PubsubMessage, T> parseFn) {
            this.parseFn = parseFn;
            return this;
        }

        @Override
        PubsubIO.Read.Builder<T> setBeamSchema(@Nullable Schema beamSchema) {
            this.beamSchema = beamSchema;
            return this;
        }

        @Override
        PubsubIO.Read.Builder<T> setTypeDescriptor(@Nullable TypeDescriptor<T> typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        @Override
        PubsubIO.Read.Builder<T> setToRowFn(@Nullable SerializableFunction<T, Row> toRowFn) {
            this.toRowFn = toRowFn;
            return this;
        }

        @Override
        PubsubIO.Read.Builder<T> setFromRowFn(@Nullable SerializableFunction<Row, T> fromRowFn) {
            this.fromRowFn = fromRowFn;
            return this;
        }

        @Override
        PubsubIO.Read.Builder<T> setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        @Override
        PubsubIO.Read.Builder<T> setNeedsAttributes(boolean needsAttributes) {
            this.needsAttributes = needsAttributes;
            return this;
        }

        @Override
        PubsubIO.Read.Builder<T> setNeedsMessageId(boolean needsMessageId) {
            this.needsMessageId = needsMessageId;
            return this;
        }

        @Override
        PubsubIO.Read<T> build() {
            String missing = "";
            if (this.pubsubClientFactory == null) {
                missing = missing + " pubsubClientFactory";
            }
            if (this.coder == null) {
                missing = missing + " coder";
            }
            if (this.needsAttributes == null) {
                missing = missing + " needsAttributes";
            }
            if (this.needsMessageId == null) {
                missing = missing + " needsMessageId";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PubsubIO_Read(this.topicProvider, this.pubsubClientFactory, this.subscriptionProvider, this.timestampAttribute, this.idAttribute, this.coder, this.parseFn, this.beamSchema, this.typeDescriptor, this.toRowFn, this.fromRowFn, this.clock, this.needsAttributes, this.needsMessageId);
        }
    }
}

