/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.healthcare.v1beta1.model.Message;
import com.google.api.services.healthcare.v1beta1.model.SchematizedData;
import java.io.IOException;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class HL7v2Message {
    private final @UnknownKeyFor @NonNull @Initialized String name;
    private final @UnknownKeyFor @NonNull @Initialized String messageType;
    private final @UnknownKeyFor @NonNull @Initialized String sendTime;
    private final @UnknownKeyFor @NonNull @Initialized String createTime;
    private final @UnknownKeyFor @NonNull @Initialized String data;
    private final @UnknownKeyFor @NonNull @Initialized String sendFacility;
    private @UnknownKeyFor @NonNull @Initialized String schematizedData;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> labels;

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            return this.getData();
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized HL7v2Message fromModel(@UnknownKeyFor @NonNull @Initialized Message msg) {
        SchematizedData schematizedData = msg.getSchematizedData();
        return new HL7v2Message(msg.getName(), msg.getMessageType(), msg.getSendTime(), msg.getCreateTime(), msg.getData(), msg.getSendFacility(), schematizedData != null ? schematizedData.getData() : null, msg.getLabels());
    }

    public @UnknownKeyFor @NonNull @Initialized Message toModel() {
        Message out = new Message();
        out.setName(this.getName());
        out.setMessageType(this.getMessageType());
        out.setSendTime(this.getSendTime());
        out.setCreateTime(this.getCreateTime());
        out.setData(this.getData());
        out.setSendFacility(this.getSendFacility());
        out.setSchematizedData(new SchematizedData().setData(this.schematizedData));
        out.setLabels(this.labels);
        return out;
    }

    public HL7v2Message(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String messageType, @UnknownKeyFor @NonNull @Initialized String sendTime, @UnknownKeyFor @NonNull @Initialized String createTime, @UnknownKeyFor @NonNull @Initialized String data, @UnknownKeyFor @NonNull @Initialized String sendFacility, @Nullable @UnknownKeyFor @Initialized String schematizedData, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> labels) {
        this.name = name;
        this.messageType = messageType;
        this.sendTime = sendTime;
        this.createTime = createTime;
        this.data = data;
        this.sendFacility = sendFacility;
        this.schematizedData = schematizedData;
        this.labels = labels;
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.name;
    }

    public @UnknownKeyFor @NonNull @Initialized String getMessageType() {
        return this.messageType;
    }

    public @UnknownKeyFor @NonNull @Initialized String getSendTime() {
        return this.sendTime;
    }

    public @UnknownKeyFor @NonNull @Initialized String getCreateTime() {
        return this.createTime;
    }

    public @UnknownKeyFor @NonNull @Initialized String getData() {
        return this.data;
    }

    public @UnknownKeyFor @NonNull @Initialized String getSendFacility() {
        return this.sendFacility;
    }

    public @UnknownKeyFor @NonNull @Initialized String getSchematizedData() {
        return this.schematizedData;
    }

    public void setSchematizedData(@UnknownKeyFor @NonNull @Initialized String schematizedData) {
        this.schematizedData = schematizedData;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getLabels() {
        return this.labels;
    }
}

