/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryInsertError;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class WriteResult
implements POutput {
    private final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableRow> failedInsertsTag;
    private final @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> failedInserts;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> failedInsertsWithErrTag;
    private final @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> failedInsertsWithErr;

    static @UnknownKeyFor @NonNull @Initialized WriteResult in(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableRow> failedInsertsTag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> failedInserts) {
        return new WriteResult(pipeline, failedInsertsTag, failedInserts, null, null);
    }

    static @UnknownKeyFor @NonNull @Initialized WriteResult withExtendedErrors(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> failedInsertsTag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> failedInserts) {
        return new WriteResult(pipeline, null, null, failedInsertsTag, failedInserts);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
        if (this.failedInsertsTag != null) {
            return ImmutableMap.of(this.failedInsertsTag, this.failedInserts);
        }
        return ImmutableMap.of(this.failedInsertsWithErrTag, this.failedInsertsWithErr);
    }

    private WriteResult(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized TableRow> failedInsertsTag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> failedInserts, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> failedInsertsWithErrTag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> failedInsertsWithErr) {
        this.pipeline = pipeline;
        this.failedInsertsTag = failedInsertsTag;
        this.failedInserts = failedInserts;
        this.failedInsertsWithErrTag = failedInsertsWithErrTag;
        this.failedInsertsWithErr = failedInsertsWithErr;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> getFailedInserts() {
        Preconditions.checkArgument((this.failedInsertsTag != null ? 1 : 0) != 0, (Object)"Cannot use getFailedInserts as this WriteResult uses extended errors information. Use getFailedInsertsWithErr instead");
        return this.failedInserts;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized BigQueryInsertError> getFailedInsertsWithErr() {
        Preconditions.checkArgument((this.failedInsertsWithErrTag != null ? 1 : 0) != 0, (Object)"Cannot use getFailedInsertsWithErr as this WriteResult does not use extended errors. Use getFailedInserts instead");
        return this.failedInsertsWithErr;
    }

    public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
        return this.pipeline;
    }

    public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
    }
}

