/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV2;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CreateTables<@UnknownKeyFor DestinationT, @UnknownKeyFor ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, PCollection<KV<TableDestination, ElementT>>> {
    private final @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition;
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations;
    private final @UnknownKeyFor @NonNull @Initialized String kmsKey;
    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> createdTables = Collections.newSetFromMap(new ConcurrentHashMap());

    public CreateTables(@UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations) {
        this(createDisposition, new BigQueryServicesImpl(), dynamicDestinations, null);
    }

    private CreateTables(@UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized String kmsKey) {
        this.createDisposition = createDisposition;
        this.bqServices = bqServices;
        this.dynamicDestinations = dynamicDestinations;
        this.kmsKey = kmsKey;
    }

    @UnknownKeyFor @NonNull @Initialized CreateTables<DestinationT, ElementT> withKmsKey(@UnknownKeyFor @NonNull @Initialized String kmsKey) {
        return new CreateTables<DestinationT, ElementT>(this.createDisposition, this.bqServices, this.dynamicDestinations, kmsKey);
    }

    @UnknownKeyFor @NonNull @Initialized CreateTables<DestinationT, ElementT> withTestServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        return new CreateTables<DestinationT, ElementT>(this.createDisposition, bqServices, this.dynamicDestinations, this.kmsKey);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized TableDestination, ElementT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input) {
        ArrayList sideInputs = Lists.newArrayList();
        sideInputs.addAll(this.dynamicDestinations.getSideInputs());
        return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new CreateTablesFn()).withSideInputs((Iterable)sideInputs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clearCreatedTables() {
        Set<String> set = createdTables;
        synchronized (set) {
            createdTables.clear();
        }
    }

    private class CreateTablesFn
    extends DoFn<KV<DestinationT, ElementT>, KV<TableDestination, ElementT>> {
        private @UnknownKeyFor @NonNull @Initialized Map<DestinationT, @UnknownKeyFor @NonNull @Initialized TableDestination> destinations;

        private CreateTablesFn() {
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.destinations = Maps.newHashMap();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            CreateTables.this.dynamicDestinations.setSideInputAccessorFromProcessContext(context);
            context.output((Object)KV.of((Object)this.destinations.computeIfAbsent(((KV)context.element()).getKey(), dest -> this.getTableDestination(context, dest)), (Object)((KV)context.element()).getValue()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private @UnknownKeyFor @NonNull @Initialized TableDestination getTableDestination(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, DestinationT destination) {
            TableDestination tableDestination = CreateTables.this.dynamicDestinations.getTable(destination);
            Preconditions.checkArgument((tableDestination != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may not return null, but %s returned null for destination %s", (Object)CreateTables.this.dynamicDestinations, destination);
            Preconditions.checkArgument((tableDestination.getTableSpec() != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() must return a TableDestination with a non-null table spec, but %s returned %s for destination %s,which has a null table spec", (Object)CreateTables.this.dynamicDestinations, (Object)tableDestination, destination);
            boolean destinationCoderSupportsClustering = !(CreateTables.this.dynamicDestinations.getDestinationCoder() instanceof TableDestinationCoderV2);
            Preconditions.checkArgument((tableDestination.getClustering() == null || destinationCoderSupportsClustering ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may only return destinations with clustering configured if a destination coder is supplied that supports clustering, but %s is configured to use TableDestinationCoderV2. Set withClustering() on BigQueryIO.write() and,  if you provided a custom DynamicDestinations instance, override getDestinationCoder() to return TableDestinationCoderV3.", (Object)CreateTables.this.dynamicDestinations);
            TableReference tableReference = tableDestination.getTableReference().clone();
            if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
                tableReference.setProjectId(((BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class)).getProject());
                tableDestination = tableDestination.withTableReference(tableReference);
            }
            if (CreateTables.this.createDisposition == BigQueryIO.Write.CreateDisposition.CREATE_NEVER) {
                return tableDestination;
            }
            String tableSpec = BigQueryHelpers.stripPartitionDecorator(tableDestination.getTableSpec());
            if (!createdTables.contains(tableSpec)) {
                Set set = createdTables;
                synchronized (set) {
                    if (!createdTables.contains(tableSpec)) {
                        this.tryCreateTable(context, destination, tableDestination, tableSpec, CreateTables.this.kmsKey);
                    }
                }
            }
            return tableDestination;
        }

        private void tryCreateTable(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, DestinationT destination, @UnknownKeyFor @NonNull @Initialized TableDestination tableDestination, @UnknownKeyFor @NonNull @Initialized String tableSpec, @UnknownKeyFor @NonNull @Initialized String kmsKey) {
            BigQueryServices.DatasetService datasetService = CreateTables.this.bqServices.getDatasetService((BigQueryOptions)context.getPipelineOptions().as(BigQueryOptions.class));
            TableReference tableReference = tableDestination.getTableReference().clone();
            tableReference.setTableId(BigQueryHelpers.stripPartitionDecorator(tableReference.getTableId()));
            try {
                if (datasetService.getTable(tableReference) == null) {
                    TableSchema tableSchema = CreateTables.this.dynamicDestinations.getSchema(destination);
                    Preconditions.checkArgument((tableSchema != null ? 1 : 0) != 0, (String)"Unless create disposition is %s, a schema must be specified, i.e. DynamicDestinations.getSchema() may not return null. However, create disposition is %s, and  %s returned null for destination %s", (Object)((Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER), (Object)((Object)CreateTables.this.createDisposition), (Object)CreateTables.this.dynamicDestinations, destination);
                    Table table = new Table().setTableReference(tableReference).setSchema(tableSchema).setDescription(tableDestination.getTableDescription());
                    if (tableDestination.getTimePartitioning() != null) {
                        table.setTimePartitioning(tableDestination.getTimePartitioning());
                        if (tableDestination.getClustering() != null) {
                            table.setClustering(tableDestination.getClustering());
                        }
                    }
                    if (kmsKey != null) {
                        table.setEncryptionConfiguration(new EncryptionConfiguration().setKmsKeyName(kmsKey));
                    }
                    datasetService.createTable(table);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            createdTables.add(tableSpec);
        }
    }
}

