/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Description(value="Options that are used to configure Google BigQuery. See https://cloud.google.com/bigquery/what-is-bigquery for details on BigQuery.")
public interface BigQueryOptions
extends ApplicationNameOptions,
GcpOptions,
PipelineOptions,
StreamingOptions {
    @Description(value="Temporary dataset for BigQuery table operations. Supported values are \"bigquery.googleapis.com/{dataset}\"")
    @Default.String(value="bigquery.googleapis.com/cloud_dataflow")
    public @UnknownKeyFor @NonNull @Initialized String getTempDatasetId();

    public void setTempDatasetId(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="Timeout for HTTP requests to BigQuery service in milliseconds. Set to 0 to disable.")
    @Default.Integer(value=900000)
    public @UnknownKeyFor @NonNull @Initialized Integer getHTTPWriteTimeout();

    public void setHTTPWriteTimeout(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="If specified, the given number of maximum concurrent threads will be used to insert rows from one bundle to BigQuery service with streaming insert API.")
    @Default.Integer(value=3)
    public @UnknownKeyFor @NonNull @Initialized Integer getInsertBundleParallelism();

    public void setInsertBundleParallelism(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The number of keys used per table when doing streaming inserts to BigQuery.")
    @Default.Integer(value=50)
    public @UnknownKeyFor @NonNull @Initialized Integer getNumStreamingKeys();

    public void setNumStreamingKeys(@UnknownKeyFor @NonNull @Initialized Integer var1);

    @Description(value="The maximum number of rows to batch in a single streaming insert to BigQuery.")
    @Default.Long(value=500L)
    public @UnknownKeyFor @NonNull @Initialized Long getMaxStreamingRowsToBatch();

    public void setMaxStreamingRowsToBatch(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="The maximum byte size of a single streaming insert to BigQuery.")
    @Default.Long(value=65536L)
    public @UnknownKeyFor @NonNull @Initialized Long getMaxStreamingBatchSize();

    public void setMaxStreamingBatchSize(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="The minimum duration in seconds between percentile latencies logging. The interval might be longer than the specified value due to each bundle processing time.")
    @Default.Integer(value=180)
    public @UnknownKeyFor @NonNull @Initialized Integer getLatencyLoggingFrequency();

    public void setLatencyLoggingFrequency(@UnknownKeyFor @NonNull @Initialized Integer var1);
}

