/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsublite.AddUuidsTransform;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteSink;
import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteUnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.UuidDeduplicationOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.UuidDeduplicationTransform;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;

@Experimental
public final class PubsubLiteIO {
    private PubsubLiteIO() {
    }

    public static Read.Unbounded<SequencedMessage> read(SubscriberOptions options) {
        return Read.from((UnboundedSource)new PubsubLiteUnboundedSource(options));
    }

    public static PTransform<PCollection<SequencedMessage>, PCollection<SequencedMessage>> deduplicate(UuidDeduplicationOptions options) {
        return new UuidDeduplicationTransform(options);
    }

    public static PTransform<PCollection<PubSubMessage>, PCollection<PubSubMessage>> addUuids() {
        return new AddUuidsTransform();
    }

    public static PTransform<PCollection<PubSubMessage>, PDone> write(final PublisherOptions options) {
        return new PTransform<PCollection<PubSubMessage>, PDone>("PubsubLiteIO"){

            public PDone expand(PCollection<PubSubMessage> input) {
                PubsubLiteSink sink = new PubsubLiteSink(options);
                input.apply("Write", (PTransform)ParDo.of((DoFn)sink));
                return PDone.in((Pipeline)input.getPipeline());
            }
        };
    }
}

