/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import io.grpc.StatusException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DelegateCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.gcp.pubsublite.OffsetFinalizer;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

class OffsetCheckpointMark
implements UnboundedSource.CheckpointMark {
    private final Optional<OffsetFinalizer> finalizer;
    final Map<Partition, Offset> partitionOffsetMap;

    OffsetCheckpointMark(OffsetFinalizer finalizer, Map<Partition, Offset> partitionOffsetMap) {
        this.finalizer = Optional.of(finalizer);
        this.partitionOffsetMap = partitionOffsetMap;
    }

    private OffsetCheckpointMark(Map<Long, Long> encodedMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            for (Map.Entry<Long, Long> entry : encodedMap.entrySet()) {
                builder.put((Object)Partition.of((long)entry.getKey()), (Object)Offset.of((long)entry.getValue()));
            }
        }
        catch (StatusException e) {
            throw e.getStatus().asRuntimeException();
        }
        this.finalizer = Optional.empty();
        this.partitionOffsetMap = builder.build();
    }

    public void finalizeCheckpoint() throws IOException {
        if (!this.finalizer.isPresent()) {
            return;
        }
        try {
            this.finalizer.get().finalizeOffsets(this.partitionOffsetMap);
        }
        catch (StatusException e) {
            throw new IOException(e);
        }
    }

    static Coder<OffsetCheckpointMark> getCoder() {
        return DelegateCoder.of((Coder)MapCoder.of((Coder)BigEndianLongCoder.of(), (Coder)BigEndianLongCoder.of()), (DelegateCoder.CodingFunction & Serializable)mark -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            mark.partitionOffsetMap.forEach((key, value) -> builder.put((Object)key.value(), (Object)value.value()));
            return builder.build();
        }, OffsetCheckpointMark::new);
    }
}

