/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.schemas.transforms.DropFields;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.ToJson;
import org.apache.beam.sdk.transforms.WithTimestamps;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

class RowToPubsubMessage
extends PTransform<PCollection<Row>, PCollection<PubsubMessage>> {
    private final boolean useTimestampAttribute;

    private RowToPubsubMessage(boolean useTimestampAttribute) {
        this.useTimestampAttribute = useTimestampAttribute;
    }

    public static RowToPubsubMessage withTimestampAttribute(boolean useTimestampAttribute) {
        return new RowToPubsubMessage(useTimestampAttribute);
    }

    public PCollection<PubsubMessage> expand(PCollection<Row> input) {
        PCollection withTimestamp = this.useTimestampAttribute ? (PCollection)input.apply((PTransform)WithTimestamps.of((SerializableFunction & Serializable)row -> row.getDateTime("event_timestamp").toInstant())) : input;
        return (PCollection)((PCollection)((PCollection)withTimestamp.apply((PTransform)DropFields.fields((String[])new String[]{"event_timestamp"}))).apply((PTransform)ToJson.of())).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(PubsubMessage.class)).via((SerializableFunction & Serializable)json -> new PubsubMessage(json.getBytes(StandardCharsets.ISO_8859_1), (Map<String, String>)ImmutableMap.of())));
    }
}

