/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental
public final class ExternalRead
implements ExternalTransformRegistrar {
    public static final String URN = "beam:external:java:pubsub:read:v1";

    public Map<String, Class<? extends ExternalTransformBuilder<?, ?, ?>>> knownBuilders() {
        return ImmutableMap.of((Object)URN, ReadBuilder.class);
    }

    private static class ParsePayloadAsPubsubMessageProto
    implements SerializableFunction<PubsubMessage, byte[]> {
        private ParsePayloadAsPubsubMessageProto() {
        }

        public byte[] apply(PubsubMessage input) {
            Map<String, String> attributes = input.getAttributeMap();
            PubsubMessage.Builder message = com.google.pubsub.v1.PubsubMessage.newBuilder().setData(ByteString.copyFrom((byte[])input.getPayload()));
            if (attributes != null) {
                message.putAllAttributes(attributes);
            }
            return message.build().toByteArray();
        }
    }

    public static class ReadBuilder
    implements ExternalTransformBuilder<Configuration, PBegin, PCollection<byte[]>> {
        public PTransform<PBegin, PCollection<byte[]>> buildExternal(Configuration config) {
            PubsubIO.Read.Builder<Object> readBuilder;
            if (config.needsAttributes) {
                readBuilder = PubsubIO.Read.newBuilder(new ParsePayloadAsPubsubMessageProto());
                readBuilder.setNeedsAttributes(true);
            } else {
                readBuilder = PubsubIO.Read.newBuilder(PubsubMessage::getPayload);
            }
            readBuilder.setCoder((Coder<Object>)ByteArrayCoder.of());
            if (config.topic != null) {
                ValueProvider.StaticValueProvider topic = ValueProvider.StaticValueProvider.of((Object)config.topic);
                readBuilder.setTopicProvider((ValueProvider<PubsubIO.PubsubTopic>)ValueProvider.NestedValueProvider.of((ValueProvider)topic, PubsubIO.PubsubTopic::fromPath));
            }
            if (config.subscription != null) {
                ValueProvider.StaticValueProvider subscription = ValueProvider.StaticValueProvider.of((Object)config.subscription);
                readBuilder.setSubscriptionProvider((ValueProvider<PubsubIO.PubsubSubscription>)ValueProvider.NestedValueProvider.of((ValueProvider)subscription, PubsubIO.PubsubSubscription::fromPath));
            }
            if (config.idAttribute != null) {
                readBuilder.setIdAttribute(config.idAttribute);
            }
            if (config.timestampAttribute != null) {
                readBuilder.setTimestampAttribute(config.timestampAttribute);
            }
            return readBuilder.build();
        }
    }

    public static class Configuration {
        private @Nullable String topic;
        private @Nullable String subscription;
        private @Nullable String idAttribute;
        private @Nullable String timestampAttribute;
        private boolean needsAttributes;

        public void setTopic(@Nullable String topic) {
            this.topic = topic;
        }

        public void setSubscription(@Nullable String subscription) {
            this.subscription = subscription;
        }

        public void setIdLabel(@Nullable String idAttribute) {
            this.idAttribute = idAttribute;
        }

        public void setTimestampAttribute(@Nullable String timestampAttribute) {
            this.timestampAttribute = timestampAttribute;
        }

        public void setWithAttributes(Boolean needsAttributes) {
            this.needsAttributes = needsAttributes;
        }
    }
}

