/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.storage.v1beta1.ReadOptions;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageStreamSource;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
abstract class BigQueryStorageSourceBase<T>
extends BoundedSource<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BigQueryStorageSourceBase.class);
    private static final int MAX_SPLIT_COUNT = 10000;
    private static final int MIN_SPLIT_COUNT = 10;
    protected final ReadOptions.TableReadOptions tableReadOptions;
    protected final ValueProvider<List<String>> selectedFieldsProvider;
    protected final ValueProvider<String> rowRestrictionProvider;
    protected final SerializableFunction<SchemaAndRecord, T> parseFn;
    protected final Coder<T> outputCoder;
    protected final BigQueryServices bqServices;

    BigQueryStorageSourceBase(@Nullable ReadOptions.TableReadOptions tableReadOptions, @Nullable ValueProvider<List<String>> selectedFieldsProvider, @Nullable ValueProvider<String> rowRestrictionProvider, SerializableFunction<SchemaAndRecord, T> parseFn, Coder<T> outputCoder, BigQueryServices bqServices) {
        Preconditions.checkArgument((tableReadOptions == null || selectedFieldsProvider == null && rowRestrictionProvider == null ? 1 : 0) != 0, (Object)"tableReadOptions is mutually exclusive with selectedFieldsProvider and rowRestrictionProvider");
        this.tableReadOptions = tableReadOptions;
        this.selectedFieldsProvider = selectedFieldsProvider;
        this.rowRestrictionProvider = rowRestrictionProvider;
        this.parseFn = (SerializableFunction)Preconditions.checkNotNull(parseFn, (Object)"parseFn");
        this.outputCoder = (Coder)Preconditions.checkNotNull(outputCoder, (Object)"outputCoder");
        this.bqServices = (BigQueryServices)Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
    }

    protected abstract Table getTargetTable(BigQueryOptions var1) throws Exception;

    public Coder<T> getOutputCoder() {
        return this.outputCoder;
    }

    public List<BigQueryStorageStreamSource<T>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
        Storage.ReadSession readSession;
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        Table targetTable = this.getTargetTable(bqOptions);
        int streamCount = 0;
        if (desiredBundleSizeBytes > 0L) {
            long tableSizeBytes = targetTable != null ? targetTable.getNumBytes() : 0L;
            streamCount = (int)Math.min(tableSizeBytes / desiredBundleSizeBytes, 10000L);
        }
        streamCount = Math.max(streamCount, 10);
        Storage.CreateReadSessionRequest.Builder requestBuilder = Storage.CreateReadSessionRequest.newBuilder().setParent("projects/" + bqOptions.getProject()).setTableReference(BigQueryHelpers.toTableRefProto(targetTable.getTableReference())).setRequestedStreams(streamCount).setUnknownFields(UnknownFieldSet.newBuilder().addField(7, UnknownFieldSet.Field.newBuilder().addVarint(2L).build()).build());
        if (this.selectedFieldsProvider != null || this.rowRestrictionProvider != null) {
            ReadOptions.TableReadOptions.Builder builder = ReadOptions.TableReadOptions.newBuilder();
            if (this.selectedFieldsProvider != null) {
                builder.addAllSelectedFields((Iterable)this.selectedFieldsProvider.get());
            }
            if (this.rowRestrictionProvider != null) {
                builder.setRowRestriction((String)this.rowRestrictionProvider.get());
            }
            requestBuilder.setReadOptions(builder);
        } else if (this.tableReadOptions != null) {
            requestBuilder.setReadOptions(this.tableReadOptions);
        }
        BigQueryServices.StorageClient client = this.bqServices.getStorageClient(bqOptions);
        Object object = null;
        try {
            Storage.CreateReadSessionRequest request = requestBuilder.build();
            readSession = client.createReadSession(request);
            LOGGER.info("Sent BigQuery Storage API CreateReadSession request '{}'; received response '{}'.", (Object)request, (Object)readSession);
        }
        catch (Throwable request) {
            object = request;
            throw request;
        }
        finally {
            if (client != null) {
                if (object != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable request) {
                        ((Throwable)object).addSuppressed(request);
                    }
                } else {
                    client.close();
                }
            }
        }
        if (readSession.getStreamsList().isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList sources = Lists.newArrayList();
        for (Storage.Stream stream : readSession.getStreamsList()) {
            sources.add(BigQueryStorageStreamSource.create(readSession, stream, targetTable.getSchema(), this.parseFn, this.outputCoder, this.bqServices));
        }
        return ImmutableList.copyOf((Collection)sources);
    }

    public BoundedSource.BoundedReader<T> createReader(PipelineOptions options) throws IOException {
        throw new UnsupportedOperationException("BigQuery storage source must be split before reading");
    }
}

