/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.ShardedKey;

class GenerateShardedTable<ElementT>
extends DoFn<KV<TableDestination, ElementT>, KV<ShardedKey<String>, ElementT>> {
    private final int numShards;

    GenerateShardedTable(int numShards) {
        this.numShards = numShards;
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext context, BoundedWindow window) throws IOException {
        ThreadLocalRandom randomGenerator = ThreadLocalRandom.current();
        String tableSpec = ((TableDestination)((KV)context.element()).getKey()).getTableSpec();
        context.output((Object)KV.of((Object)ShardedKey.of((Object)tableSpec, (int)randomGenerator.nextInt(0, this.numShards)), (Object)((KV)context.element()).getValue()));
    }
}

