/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.CountingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TableRowWriter
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(TableRowWriter.class);
    private static final Coder<TableRow> CODER = TableRowJsonCoder.of();
    private static final byte[] NEWLINE = "\n".getBytes(StandardCharsets.UTF_8);
    private ResourceId resourceId;
    private WritableByteChannel channel;
    private CountingOutputStream out;
    private boolean isClosed = false;

    TableRowWriter(String basename) throws Exception {
        String uId = UUID.randomUUID().toString();
        this.resourceId = FileSystems.matchNewResource((String)(basename + uId), (boolean)false);
        LOG.info("Opening TableRowWriter to {}.", (Object)this.resourceId);
        this.channel = FileSystems.create((ResourceId)this.resourceId, (String)"text/plain");
        this.out = new CountingOutputStream(Channels.newOutputStream(this.channel));
    }

    void write(TableRow value) throws Exception {
        CODER.encode((Object)value, (OutputStream)this.out, Coder.Context.OUTER);
        this.out.write(NEWLINE);
    }

    long getByteSize() {
        return this.out.getCount();
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"Already closed");
        this.isClosed = true;
        this.channel.close();
    }

    Result getResult() {
        Preconditions.checkState((boolean)this.isClosed, (Object)"Not yet closed");
        return new Result(this.resourceId, this.out.getCount());
    }

    static final class Result {
        final ResourceId resourceId;
        final long byteSize;

        public Result(ResourceId resourceId, long byteSize) {
            this.resourceId = resourceId;
            this.byteSize = byteSize;
        }
    }
}

