/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.io.gcp.bigquery.AvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.Mode;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.io.gcp.bigquery.StandardSQLTypeName;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class BigQueryUtils {
    private static final Map<Schema.TypeName, StandardSQLTypeName> BEAM_TO_BIGQUERY_TYPE_MAPPING = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.INT16, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.INT32, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.INT64, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.FLOAT, (Object)StandardSQLTypeName.FLOAT64).put((Object)Schema.TypeName.DOUBLE, (Object)StandardSQLTypeName.FLOAT64).put((Object)Schema.TypeName.DECIMAL, (Object)StandardSQLTypeName.NUMERIC).put((Object)Schema.TypeName.BOOLEAN, (Object)StandardSQLTypeName.BOOL).put((Object)Schema.TypeName.ARRAY, (Object)StandardSQLTypeName.ARRAY).put((Object)Schema.TypeName.ROW, (Object)StandardSQLTypeName.STRUCT).put((Object)Schema.TypeName.DATETIME, (Object)StandardSQLTypeName.TIMESTAMP).put((Object)Schema.TypeName.STRING, (Object)StandardSQLTypeName.STRING).build();
    private static final Map<Schema.TypeName, Function<String, Object>> JSON_VALUE_PARSERS = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, Byte::valueOf).put((Object)Schema.TypeName.INT16, Short::valueOf).put((Object)Schema.TypeName.INT32, Integer::valueOf).put((Object)Schema.TypeName.INT64, Long::valueOf).put((Object)Schema.TypeName.FLOAT, Float::valueOf).put((Object)Schema.TypeName.DOUBLE, Double::valueOf).put((Object)Schema.TypeName.DECIMAL, BigDecimal::new).put((Object)Schema.TypeName.BOOLEAN, Boolean::valueOf).put((Object)Schema.TypeName.STRING, str -> str).put((Object)Schema.TypeName.DATETIME, str -> new DateTime((long)(Double.parseDouble(str) * 1000.0), (Chronology)ISOChronology.getInstanceUTC())).build();
    private static final Map<String, StandardSQLTypeName> BEAM_TO_BIGQUERY_LOGICAL_MAPPING = ImmutableMap.builder().put((Object)"SqlDateType", (Object)StandardSQLTypeName.DATE).put((Object)"SqlTimeType", (Object)StandardSQLTypeName.TIME).put((Object)"SqlTimeWithLocalTzType", (Object)StandardSQLTypeName.TIME).put((Object)"SqlTimestampWithLocalTzType", (Object)StandardSQLTypeName.TIMESTAMP).put((Object)"SqlCharType", (Object)StandardSQLTypeName.STRING).build();
    private static final SerializableFunction<Row, TableRow> TO_TABLE_ROW = new ToTableRow();

    private static StandardSQLTypeName toStandardSQLTypeName(Schema.FieldType fieldType) {
        StandardSQLTypeName foundType;
        if (fieldType.getTypeName().isLogicalType() && (foundType = BEAM_TO_BIGQUERY_LOGICAL_MAPPING.get(fieldType.getLogicalType().getIdentifier())) != null) {
            return foundType;
        }
        return BEAM_TO_BIGQUERY_TYPE_MAPPING.get(fieldType.getTypeName());
    }

    private static List<TableFieldSchema> toTableFieldSchema(Schema schema) {
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>(schema.getFieldCount());
        for (Schema.Field schemaField : schema.getFields()) {
            Schema.FieldType type = schemaField.getType();
            TableFieldSchema field = new TableFieldSchema().setName(schemaField.getName());
            if (schemaField.getDescription() != null && !"".equals(schemaField.getDescription())) {
                field.setDescription(schemaField.getDescription());
            }
            if (!schemaField.getType().getNullable().booleanValue()) {
                field.setMode(Mode.REQUIRED.toString());
            }
            if (Schema.TypeName.ARRAY == type.getTypeName()) {
                type = type.getCollectionElementType();
                field.setMode(Mode.REPEATED.toString());
            }
            if (Schema.TypeName.ROW == type.getTypeName()) {
                Schema subType = type.getRowSchema();
                field.setFields(BigQueryUtils.toTableFieldSchema(subType));
            }
            field.setType(BigQueryUtils.toStandardSQLTypeName(type).toString());
            fields.add(field);
        }
        return fields;
    }

    public static TableSchema toTableSchema(Schema schema) {
        return new TableSchema().setFields(BigQueryUtils.toTableFieldSchema(schema));
    }

    public static TableSchema toTableSchema(PCollection<Row> rows) {
        RowCoder coder = (RowCoder)rows.getCoder();
        return BigQueryUtils.toTableSchema(coder.getSchema());
    }

    public static SerializableFunction<Row, TableRow> toTableRow() {
        return TO_TABLE_ROW;
    }

    public static SerializableFunction<SchemaAndRecord, Row> toBeamRow(Schema schema) {
        return new ToBeamRow(schema);
    }

    public static Row toBeamRow(GenericRecord record, Schema schema) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < record.getSchema().getFields().size(); ++i) {
            Schema.Field avroField = (Schema.Field)record.getSchema().getFields().get(i);
            values.add(AvroUtils.convertAvroFormat(schema.getField(i), record.get(avroField.name())));
        }
        return Row.withSchema((Schema)schema).addValues(values).build();
    }

    public static TableRow toTableRow(Row row) {
        TableRow output = new TableRow();
        for (int i = 0; i < row.getFieldCount(); ++i) {
            ArrayList<TableRow> value = row.getValue(i);
            Schema.Field schemaField = row.getSchema().getField(i);
            Schema.TypeName type = schemaField.getType().getTypeName();
            switch (type) {
                case ARRAY: {
                    type = schemaField.getType().getCollectionElementType().getTypeName();
                    if (Schema.TypeName.ROW != type) break;
                    List rows = value;
                    ArrayList<TableRow> tableRows = new ArrayList<TableRow>(rows.size());
                    for (int j = 0; j < rows.size(); ++j) {
                        tableRows.add(BigQueryUtils.toTableRow((Row)rows.get(j)));
                    }
                    value = tableRows;
                    break;
                }
                case ROW: {
                    value = BigQueryUtils.toTableRow((Row)value);
                    break;
                }
                case DATETIME: {
                    DateTimeFormatter patternFormat = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZZ").toFormatter();
                    value = value == null ? null : ((Instant)value).toDateTime().toString(patternFormat);
                    break;
                }
                default: {
                    value = row.getValue(i);
                }
            }
            output = output.set(schemaField.getName(), (Object)value);
        }
        return output;
    }

    public static Row toBeamRow(Schema rowSchema, TableSchema bqSchema, TableRow jsonBqRow) {
        List bqFields = bqSchema.getFields();
        Map<String, Integer> bqFieldIndices = IntStream.range(0, bqFields.size()).boxed().collect(Collectors.toMap(i -> ((TableFieldSchema)bqFields.get((int)i)).getName(), i -> i));
        List rawJsonValues = rowSchema.getFields().stream().map(field -> (Integer)bqFieldIndices.get(field.getName())).map(index -> ((TableCell)jsonBqRow.getF().get((int)index)).getV()).collect(Collectors.toList());
        return (Row)IntStream.range(0, rowSchema.getFieldCount()).boxed().map(index -> BigQueryUtils.toBeamValue(rowSchema.getField(index.intValue()).getType(), rawJsonValues.get((int)index))).collect(Row.toRow((Schema)rowSchema));
    }

    private static Object toBeamValue(Schema.FieldType fieldType, Object jsonBQValue) {
        if (jsonBQValue instanceof String && JSON_VALUE_PARSERS.containsKey(fieldType.getTypeName())) {
            return JSON_VALUE_PARSERS.get(fieldType.getTypeName()).apply((String)jsonBQValue);
        }
        if (jsonBQValue instanceof List) {
            return ((List)jsonBQValue).stream().map(v -> ((Map)v).get("v")).map(v -> BigQueryUtils.toBeamValue(fieldType.getCollectionElementType(), v)).collect(Collectors.toList());
        }
        throw new UnsupportedOperationException("Converting BigQuery type '" + jsonBQValue.getClass() + "' to '" + fieldType + "' is not supported");
    }

    private static class ToBeamRow
    implements SerializableFunction<SchemaAndRecord, Row> {
        private Schema schema;

        public ToBeamRow(Schema schema) {
            this.schema = schema;
        }

        public Row apply(SchemaAndRecord input) {
            GenericRecord record = input.getRecord();
            Preconditions.checkState((this.schema.getFields().size() == record.getSchema().getFields().size() ? 1 : 0) != 0, (Object)"Schema sizes are different.");
            return BigQueryUtils.toBeamRow(record, this.schema);
        }
    }

    private static class ToTableRow
    implements SerializableFunction<Row, TableRow> {
        private ToTableRow() {
        }

        public TableRow apply(Row input) {
            return BigQueryUtils.toTableRow(input);
        }
    }
}

