/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationExtract;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.AvroSource;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BigQuerySourceBase<T>
extends BoundedSource<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BigQuerySourceBase.class);
    protected static final int JOB_POLL_MAX_RETRIES = Integer.MAX_VALUE;
    protected final String stepUuid;
    protected final BigQueryServices bqServices;
    private transient List<BoundedSource<T>> cachedSplitResult;
    private SerializableFunction<SchemaAndRecord, T> parseFn;
    private Coder<T> coder;

    BigQuerySourceBase(String stepUuid, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<SchemaAndRecord, T> parseFn) {
        this.stepUuid = (String)Preconditions.checkNotNull((Object)stepUuid, (Object)"stepUuid");
        this.bqServices = (BigQueryServices)Preconditions.checkNotNull((Object)bqServices, (Object)"bqServices");
        this.coder = (Coder)Preconditions.checkNotNull(coder, (Object)"coder");
        this.parseFn = (SerializableFunction)Preconditions.checkNotNull(parseFn, (Object)"parseFn");
    }

    protected ExtractResult extractFiles(PipelineOptions options) throws Exception {
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        TableReference tableToExtract = this.getTableToExtract(bqOptions);
        BigQueryServices.DatasetService datasetService = this.bqServices.getDatasetService(bqOptions);
        Table table = datasetService.getTable(tableToExtract);
        if (table == null) {
            throw new IOException(String.format("Cannot start an export job since table %s does not exist", BigQueryHelpers.toTableSpec(tableToExtract)));
        }
        TableSchema schema = table.getSchema();
        BigQueryServices.JobService jobService = this.bqServices.getJobService(bqOptions);
        String extractJobId = BigQueryHelpers.getExtractJobId(BigQueryHelpers.createJobIdToken(options.getJobName(), this.stepUuid));
        String extractDestinationDir = BigQueryHelpers.resolveTempLocation(bqOptions.getTempLocation(), "BigQueryExtractTemp", this.stepUuid);
        String bqLocation = BigQueryHelpers.getDatasetLocation(datasetService, tableToExtract.getProjectId(), tableToExtract.getDatasetId());
        List<ResourceId> tempFiles = this.executeExtract(extractJobId, tableToExtract, jobService, bqOptions.getProject(), extractDestinationDir, bqLocation);
        return new ExtractResult(schema, tempFiles);
    }

    public List<BoundedSource<T>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
        if (this.cachedSplitResult == null) {
            ExtractResult res = this.extractFiles(options);
            LOG.info("Extract job produced {} files", (Object)res.extractedFiles.size());
            this.cleanupTempResource((BigQueryOptions)options.as(BigQueryOptions.class));
            this.cachedSplitResult = (List)Preconditions.checkNotNull(this.createSources(res.extractedFiles, res.schema));
        }
        return this.cachedSplitResult;
    }

    protected abstract TableReference getTableToExtract(BigQueryOptions var1) throws Exception;

    protected abstract void cleanupTempResource(BigQueryOptions var1) throws Exception;

    public BoundedSource.BoundedReader<T> createReader(PipelineOptions options) throws IOException {
        throw new UnsupportedOperationException("BigQuery source must be split before being read");
    }

    public void validate() {
    }

    public Coder<T> getOutputCoder() {
        return this.coder;
    }

    private List<ResourceId> executeExtract(String jobId, TableReference table, BigQueryServices.JobService jobService, String executingProject, String extractDestinationDir, String bqLocation) throws InterruptedException, IOException {
        JobReference jobRef = new JobReference().setProjectId(executingProject).setLocation(bqLocation).setJobId(jobId);
        String destinationUri = BigQueryIO.getExtractDestinationUri(extractDestinationDir);
        JobConfigurationExtract extract = new JobConfigurationExtract().setSourceTable(table).setDestinationFormat("AVRO").setDestinationUris((List)ImmutableList.of((Object)destinationUri));
        LOG.info("Starting BigQuery extract job: {}", (Object)jobId);
        jobService.startExtractJob(jobRef, extract);
        Job extractJob = jobService.pollJob(jobRef, Integer.MAX_VALUE);
        if (BigQueryHelpers.parseStatus(extractJob) != BigQueryHelpers.Status.SUCCEEDED) {
            throw new IOException(String.format("Extract job %s failed, status: %s.", extractJob.getJobReference().getJobId(), BigQueryHelpers.statusToPrettyString(extractJob.getStatus())));
        }
        LOG.info("BigQuery extract job completed: {}", (Object)jobId);
        return BigQueryIO.getExtractFilePaths(extractDestinationDir, extractJob);
    }

    List<BoundedSource<T>> createSources(List<ResourceId> files, TableSchema schema) throws IOException, InterruptedException {
        final String jsonSchema = BigQueryIO.JSON_FACTORY.toString((Object)schema);
        SerializableFunction fnWrapper = new SerializableFunction<GenericRecord, T>(){
            private Supplier<TableSchema> schema;
            {
                this.schema = Suppliers.memoize((Supplier)Suppliers.compose((Function)new TableSchemaFunction(), (Supplier)Suppliers.ofInstance((Object)jsonSchema)));
            }

            public T apply(GenericRecord input) {
                return BigQuerySourceBase.this.parseFn.apply((Object)new SchemaAndRecord(input, (TableSchema)this.schema.get()));
            }
        };
        ArrayList avroSources = Lists.newArrayList();
        for (ResourceId file : files) {
            avroSources.add(AvroSource.from((String)file.toString()).withParseFn(fnWrapper, this.getOutputCoder()));
        }
        return ImmutableList.copyOf((Collection)avroSources);
    }

    private static class TableSchemaFunction
    implements Serializable,
    Function<String, TableSchema> {
        private TableSchemaFunction() {
        }

        @Nullable
        public TableSchema apply(@Nullable String input) {
            return BigQueryHelpers.fromJsonString(input, TableSchema.class);
        }
    }

    protected static class ExtractResult {
        public final TableSchema schema;
        public final List<ResourceId> extractedFiles;

        public ExtractResult(TableSchema schema, List<ResourceId> extractedFiles) {
            this.schema = schema;
            this.extractedFiles = extractedFiles;
        }
    }
}

