/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.io.gcp.bigquery.ShardedKey;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.KV;

class GenerateShardedTable
extends DoFn<KV<TableDestination, TableRow>, KV<ShardedKey<String>, TableRow>> {
    private final int numShards;

    GenerateShardedTable(int numShards) {
        this.numShards = numShards;
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext context, BoundedWindow window) throws IOException {
        ThreadLocalRandom randomGenerator = ThreadLocalRandom.current();
        String tableSpec = ((TableDestination)((KV)context.element()).getKey()).getTableSpec();
        context.output((Object)KV.of(ShardedKey.of(tableSpec, randomGenerator.nextInt(0, this.numShards)), (Object)((KV)context.element()).getValue()));
    }
}

