/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.json.JsonFactory;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryIO_Read;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryIO_Write;
import org.apache.beam.sdk.io.gcp.bigquery.BatchLoads;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQuerySource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryTableSource;
import org.apache.beam.sdk.io.gcp.bigquery.CreateTables;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinationsHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.PassThroughThenCleanup;
import org.apache.beam.sdk.io.gcp.bigquery.PrepareWrite;
import org.apache.beam.sdk.io.gcp.bigquery.StreamingInserts;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.Transport;
import org.apache.beam.sdk.util.gcsfs.GcsPath;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryIO {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryIO.class);
    static final JsonFactory JSON_FACTORY = Transport.getJsonFactory();
    private static final String PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]{4,61}[a-z0-9]";
    private static final String DATASET_REGEXP = "[-\\w.]{1,1024}";
    private static final String TABLE_REGEXP = "[-\\w$@]{1,1024}";
    private static final String DATASET_TABLE_REGEXP = String.format("((?<PROJECT>%s):)?(?<DATASET>%s)\\.(?<TABLE>%s)", "[a-z][-a-z0-9:.]{4,61}[a-z0-9]", "[-\\w.]{1,1024}", "[-\\w$@]{1,1024}");
    static final Pattern TABLE_SPEC = Pattern.compile(DATASET_TABLE_REGEXP);
    static final SerializableFunction<TableRow, TableRow> IDENTITY_FORMATTER = new SerializableFunction<TableRow, TableRow>(){

        public TableRow apply(TableRow input) {
            return input;
        }
    };

    public static Read read() {
        return new AutoValue_BigQueryIO_Read.Builder().setValidate(true).setBigQueryServices(new BigQueryServicesImpl()).build();
    }

    static String getExtractDestinationUri(String extractDestinationDir) {
        return String.format("%s/%s", extractDestinationDir, "*.avro");
    }

    static List<ResourceId> getExtractFilePaths(String extractDestinationDir, Job extractJob) throws IOException {
        JobStatistics jobStats = extractJob.getStatistics();
        List counts = jobStats.getExtract().getDestinationUriFileCounts();
        if (counts.size() != 1) {
            String errorMessage = counts.size() == 0 ? "No destination uri file count received." : String.format("More than one destination uri file count received. First two are %s, %s", counts.get(0), counts.get(1));
            throw new RuntimeException(errorMessage);
        }
        long filesCount = (Long)counts.get(0);
        ImmutableList.Builder paths = ImmutableList.builder();
        ResourceId extractDestinationDirResourceId = FileSystems.matchNewResource((String)extractDestinationDir, (boolean)true);
        for (long i = 0L; i < filesCount; ++i) {
            ResourceId filePath = extractDestinationDirResourceId.resolve(String.format("%012d%s", i, ".avro"), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
            paths.add((Object)filePath);
        }
        return paths.build();
    }

    public static <T> Write<T> write() {
        return new AutoValue_BigQueryIO_Write.Builder().setValidate(true).setBigQueryServices(new BigQueryServicesImpl()).setCreateDisposition(Write.CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(Write.WriteDisposition.WRITE_EMPTY).build();
    }

    public static Write<TableRow> writeTableRows() {
        return BigQueryIO.write().withFormatFunction(IDENTITY_FORMATTER);
    }

    @VisibleForTesting
    static void clearCreatedTables() {
        CreateTables.clearCreatedTables();
    }

    private BigQueryIO() {
    }

    public static abstract class Write<T>
    extends PTransform<PCollection<T>, WriteResult> {
        @Nullable
        abstract ValueProvider<String> getJsonTableRef();

        @Nullable
        abstract SerializableFunction<ValueInSingleWindow<T>, TableDestination> getTableFunction();

        @Nullable
        abstract SerializableFunction<T, TableRow> getFormatFunction();

        @Nullable
        abstract DynamicDestinations<T, ?> getDynamicDestinations();

        @Nullable
        abstract PCollectionView<Map<String, String>> getSchemaFromView();

        @Nullable
        abstract ValueProvider<String> getJsonSchema();

        abstract CreateDisposition getCreateDisposition();

        abstract WriteDisposition getWriteDisposition();

        @Nullable
        abstract String getTableDescription();

        abstract boolean getValidate();

        abstract BigQueryServices getBigQueryServices();

        @Nullable
        abstract Integer getMaxFilesPerBundle();

        @Nullable
        abstract Long getMaxFileSize();

        abstract Builder<T> toBuilder();

        public Write<T> to(String tableSpec) {
            return this.to((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableSpec));
        }

        public Write<T> to(TableReference table) {
            return this.to((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toTableSpec(table)));
        }

        public Write<T> to(ValueProvider<String> tableSpec) {
            return this.toBuilder().setJsonTableRef((ValueProvider<String>)ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.NestedValueProvider.of(tableSpec, (SerializableFunction)new BigQueryHelpers.TableSpecToTableRef()), (SerializableFunction)new BigQueryHelpers.TableRefToJson())).build();
        }

        public Write<T> to(SerializableFunction<ValueInSingleWindow<T>, TableDestination> tableFunction) {
            return this.toBuilder().setTableFunction(tableFunction).build();
        }

        public Write<T> to(DynamicDestinations<T, ?> dynamicDestinations) {
            return this.toBuilder().setDynamicDestinations(dynamicDestinations).build();
        }

        public Write<T> withFormatFunction(SerializableFunction<T, TableRow> formatFunction) {
            return this.toBuilder().setFormatFunction(formatFunction).build();
        }

        public Write<T> withSchema(TableSchema schema) {
            return this.withJsonSchema((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(schema)));
        }

        public Write<T> withSchema(ValueProvider<TableSchema> schema) {
            return this.withJsonSchema((ValueProvider<String>)ValueProvider.NestedValueProvider.of(schema, (SerializableFunction)new BigQueryHelpers.TableSchemaToJsonSchema()));
        }

        public Write<T> withJsonSchema(String jsonSchema) {
            return this.withJsonSchema((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)jsonSchema));
        }

        public Write<T> withJsonSchema(ValueProvider<String> jsonSchema) {
            return this.toBuilder().setJsonSchema(jsonSchema).build();
        }

        public Write<T> withSchemaFromView(PCollectionView<Map<String, String>> view) {
            return this.toBuilder().setSchemaFromView(view).build();
        }

        public Write<T> withCreateDisposition(CreateDisposition createDisposition) {
            return this.toBuilder().setCreateDisposition(createDisposition).build();
        }

        public Write<T> withWriteDisposition(WriteDisposition writeDisposition) {
            return this.toBuilder().setWriteDisposition(writeDisposition).build();
        }

        public Write<T> withTableDescription(String tableDescription) {
            return this.toBuilder().setTableDescription(tableDescription).build();
        }

        public Write<T> withoutValidation() {
            return this.toBuilder().setValidate(false).build();
        }

        @VisibleForTesting
        Write<T> withTestServices(BigQueryServices testServices) {
            return this.toBuilder().setBigQueryServices(testServices).build();
        }

        @VisibleForTesting
        Write<T> withMaxFilesPerBundle(int maxFilesPerBundle) {
            return this.toBuilder().setMaxFilesPerBundle(maxFilesPerBundle).build();
        }

        @VisibleForTesting
        Write<T> withMaxFileSize(long maxFileSize) {
            return this.toBuilder().setMaxFileSize(maxFileSize).build();
        }

        public void validate(PipelineOptions pipelineOptions) {
            BigQueryOptions options = (BigQueryOptions)pipelineOptions.as(BigQueryOptions.class);
            if (this.getJsonTableRef() != null && this.getJsonTableRef().isAccessible() && this.getValidate()) {
                TableReference table = (TableReference)this.getTableWithDefaultProject(options).get();
                BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(options);
                BigQueryHelpers.verifyDatasetPresence(datasetService, table);
                if (this.getCreateDisposition() == CreateDisposition.CREATE_NEVER) {
                    BigQueryHelpers.verifyTablePresence(datasetService, table);
                }
                if (this.getWriteDisposition() == WriteDisposition.WRITE_EMPTY) {
                    BigQueryHelpers.verifyTableNotExistOrEmpty(datasetService, table);
                }
            }
        }

        public WriteResult expand(PCollection<T> input) {
            Preconditions.checkState((this.getTableFunction() != null || this.getJsonTableRef() != null || this.getDynamicDestinations() != null ? 1 : 0) != 0, (Object)"must set the table reference of a BigQueryIO.Write transform");
            Preconditions.checkArgument((this.getFormatFunction() != null ? 1 : 0) != 0, (Object)"A function must be provided to convert type into a TableRow. use BigQueryIO.Write.withFormatFunction to provide a formatting function.");
            Preconditions.checkArgument((this.getCreateDisposition() != CreateDisposition.CREATE_IF_NEEDED || this.getJsonSchema() != null || this.getDynamicDestinations() != null || this.getSchemaFromView() != null ? 1 : 0) != 0, (Object)"CreateDisposition is CREATE_IF_NEEDED, however no schema was provided.");
            ArrayList allToArgs = Lists.newArrayList((Object[])new Serializable[]{this.getJsonTableRef(), this.getTableFunction(), this.getDynamicDestinations()});
            Preconditions.checkArgument((1 == Iterables.size((Iterable)Iterables.filter((Iterable)allToArgs, (Predicate)Predicates.notNull())) ? 1 : 0) != 0, (Object)"Exactly one of jsonTableRef, tableFunction, or dynamicDestinations must be set");
            ArrayList allSchemaArgs = Lists.newArrayList((Object[])new Serializable[]{this.getJsonSchema(), this.getSchemaFromView(), this.getDynamicDestinations()});
            Preconditions.checkArgument((2 > Iterables.size((Iterable)Iterables.filter((Iterable)allSchemaArgs, (Predicate)Predicates.notNull())) ? 1 : 0) != 0, (Object)"No more than one of jsonSchema, schemaFromView, or dynamicDestinations may be set");
            DynamicDestinations<T, ?> dynamicDestinations = this.getDynamicDestinations();
            if (dynamicDestinations == null) {
                if (this.getJsonTableRef() != null) {
                    dynamicDestinations = DynamicDestinationsHelpers.ConstantTableDestinations.fromJsonTableRef(this.getJsonTableRef(), this.getTableDescription());
                } else if (this.getTableFunction() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.TableFunctionDestinations<T>(this.getTableFunction());
                }
                if (this.getJsonSchema() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.ConstantSchemaDestinations<T>(dynamicDestinations, this.getJsonSchema());
                } else if (this.getSchemaFromView() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.SchemaFromViewDestinations<T>(dynamicDestinations, this.getSchemaFromView());
                }
            }
            return this.expandTyped(input, dynamicDestinations);
        }

        private <DestinationT> WriteResult expandTyped(PCollection<T> input, DynamicDestinations<T, DestinationT> dynamicDestinations) {
            Coder<DestinationT> destinationCoder = null;
            try {
                destinationCoder = dynamicDestinations.getDestinationCoderWithDefault(input.getPipeline().getCoderRegistry());
            }
            catch (CannotProvideCoderException e) {
                throw new RuntimeException(e);
            }
            PCollection rowsWithDestination = ((PCollection)input.apply("PrepareWrite", new PrepareWrite<T, DestinationT>(dynamicDestinations, this.getFormatFunction()))).setCoder((Coder)KvCoder.of(destinationCoder, (Coder)TableRowJsonCoder.of()));
            if (input.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                Preconditions.checkArgument((this.getWriteDisposition() != WriteDisposition.WRITE_TRUNCATE ? 1 : 0) != 0, (Object)"WriteDisposition.WRITE_TRUNCATE is not supported for an unbounded PCollection.");
                StreamingInserts<DestinationT> streamingInserts = new StreamingInserts<DestinationT>(this.getCreateDisposition(), dynamicDestinations);
                streamingInserts.setTestServices(this.getBigQueryServices());
                return (WriteResult)rowsWithDestination.apply(streamingInserts);
            }
            BatchLoads<DestinationT> batchLoads = new BatchLoads<DestinationT>(this.getWriteDisposition(), this.getCreateDisposition(), this.getJsonTableRef() != null, dynamicDestinations, destinationCoder);
            batchLoads.setTestServices(this.getBigQueryServices());
            if (this.getMaxFilesPerBundle() != null) {
                batchLoads.setMaxNumWritersPerBundle(this.getMaxFilesPerBundle());
            }
            if (this.getMaxFileSize() != null) {
                batchLoads.setMaxFileSize(this.getMaxFileSize());
            }
            return (WriteResult)rowsWithDestination.apply(batchLoads);
        }

        protected Coder<Void> getDefaultOutputCoder() {
            return VoidCoder.of();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"table", this.getJsonTableRef()).withLabel("Table Reference"));
            if (this.getJsonSchema() != null) {
                builder.addIfNotNull(DisplayData.item((String)"schema", this.getJsonSchema()).withLabel("Table Schema"));
            } else {
                builder.add(DisplayData.item((String)"schema", (String)"Custom Schema Function").withLabel("Table Schema"));
            }
            if (this.getTableFunction() != null) {
                builder.add(DisplayData.item((String)"tableFn", this.getTableFunction().getClass()).withLabel("Table Reference Function"));
            }
            builder.add(DisplayData.item((String)"createDisposition", (String)this.getCreateDisposition().toString()).withLabel("Table CreateDisposition")).add(DisplayData.item((String)"writeDisposition", (String)this.getWriteDisposition().toString()).withLabel("Table WriteDisposition")).addIfNotDefault(DisplayData.item((String)"validation", (Boolean)this.getValidate()).withLabel("Validation Enabled"), (Object)true).addIfNotNull(DisplayData.item((String)"tableDescription", (String)this.getTableDescription()).withLabel("Table Description"));
        }

        @Nullable
        ValueProvider<TableReference> getTableWithDefaultProject(BigQueryOptions bqOptions) {
            ValueProvider<TableReference> table = this.getTable();
            if (table == null) {
                return table;
            }
            if (!table.isAccessible()) {
                LOG.info("Using a dynamic value for table input. This must contain a project in the table reference: {}", table);
                return table;
            }
            if (Strings.isNullOrEmpty((String)((TableReference)table.get()).getProjectId())) {
                TableReference tableRef = (TableReference)table.get();
                tableRef.setProjectId(bqOptions.getProject());
                return ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(tableRef)), (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableRef());
            }
            return table;
        }

        @Nullable
        public ValueProvider<TableReference> getTable() {
            return this.getJsonTableRef() == null ? null : ValueProvider.NestedValueProvider.of(this.getJsonTableRef(), (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableRef());
        }

        public static enum WriteDisposition {
            WRITE_TRUNCATE,
            WRITE_APPEND,
            WRITE_EMPTY;

        }

        public static enum CreateDisposition {
            CREATE_NEVER,
            CREATE_IF_NEEDED;

        }

        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setJsonTableRef(ValueProvider<String> var1);

            abstract Builder<T> setTableFunction(SerializableFunction<ValueInSingleWindow<T>, TableDestination> var1);

            abstract Builder<T> setFormatFunction(SerializableFunction<T, TableRow> var1);

            abstract Builder<T> setDynamicDestinations(DynamicDestinations<T, ?> var1);

            abstract Builder<T> setSchemaFromView(PCollectionView<Map<String, String>> var1);

            abstract Builder<T> setJsonSchema(ValueProvider<String> var1);

            abstract Builder<T> setCreateDisposition(CreateDisposition var1);

            abstract Builder<T> setWriteDisposition(WriteDisposition var1);

            abstract Builder<T> setTableDescription(String var1);

            abstract Builder<T> setValidate(boolean var1);

            abstract Builder<T> setBigQueryServices(BigQueryServices var1);

            abstract Builder<T> setMaxFilesPerBundle(Integer var1);

            abstract Builder<T> setMaxFileSize(Long var1);

            abstract Write<T> build();
        }
    }

    public static abstract class Read
    extends PTransform<PBegin, PCollection<TableRow>> {
        private static final String QUERY_VALIDATION_FAILURE_ERROR = "Validation of query \"%1$s\" failed. If the query depends on an earlier stage of the pipeline, This validation can be disabled using #withoutValidation.";

        @Nullable
        abstract ValueProvider<String> getJsonTableRef();

        @Nullable
        abstract ValueProvider<String> getQuery();

        abstract boolean getValidate();

        @Nullable
        abstract Boolean getFlattenResults();

        @Nullable
        abstract Boolean getUseLegacySql();

        abstract BigQueryServices getBigQueryServices();

        abstract Builder toBuilder();

        private void ensureFromNotCalledYet() {
            Preconditions.checkState((this.getJsonTableRef() == null && this.getQuery() == null ? 1 : 0) != 0, (Object)"from() or fromQuery() already called");
        }

        public Read from(String tableSpec) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableSpec));
        }

        public Read from(ValueProvider<String> tableSpec) {
            this.ensureFromNotCalledYet();
            return this.toBuilder().setJsonTableRef((ValueProvider<String>)ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.NestedValueProvider.of(tableSpec, (SerializableFunction)new BigQueryHelpers.TableSpecToTableRef()), (SerializableFunction)new BigQueryHelpers.TableRefToJson())).build();
        }

        public Read fromQuery(String query) {
            return this.fromQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public Read fromQuery(ValueProvider<String> query) {
            this.ensureFromNotCalledYet();
            return this.toBuilder().setQuery(query).setFlattenResults(true).setUseLegacySql(true).build();
        }

        public Read from(TableReference table) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toTableSpec(table)));
        }

        public Read withoutValidation() {
            return this.toBuilder().setValidate(false).build();
        }

        public Read withoutResultFlattening() {
            return this.toBuilder().setFlattenResults(false).build();
        }

        public Read usingStandardSql() {
            return this.toBuilder().setUseLegacySql(false).build();
        }

        @VisibleForTesting
        Read withTestServices(BigQueryServices testServices) {
            return this.toBuilder().setBigQueryServices(testServices).build();
        }

        public void validate(PipelineOptions options) {
            ValueProvider<TableReference> table;
            BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            String tempLocation = bqOptions.getTempLocation();
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tempLocation) ? 1 : 0) != 0, (Object)"BigQueryIO.Read needs a GCS temp location to store temp files.");
            if (this.getBigQueryServices() == null) {
                try {
                    GcsPath.fromUri((String)tempLocation);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("BigQuery temp location expected a valid 'gs://' path, but was given '%s'", tempLocation), e);
                }
            }
            Preconditions.checkState(((table = this.getTableProvider()) == null || this.getQuery() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: table reference and query may not both be set");
            Preconditions.checkState((table != null || this.getQuery() != null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: one of table reference and query must be set");
            if (table != null) {
                Preconditions.checkState((this.getFlattenResults() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies a table with a result flattening preference, which only applies to queries");
                Preconditions.checkState((this.getUseLegacySql() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies a table with a SQL dialect preference, which only applies to queries");
                if (table.isAccessible() && Strings.isNullOrEmpty((String)((TableReference)table.get()).getProjectId())) {
                    LOG.info("Project of {} not set. The value of {}.getProject() at execution time will be used.", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName());
                }
            } else {
                Preconditions.checkState((this.getFlattenResults() != null ? 1 : 0) != 0, (Object)"flattenResults should not be null if query is set");
                Preconditions.checkState((this.getUseLegacySql() != null ? 1 : 0) != 0, (Object)"useLegacySql should not be null if query is set");
            }
            if (this.getValidate() && table != null && table.isAccessible() && ((TableReference)table.get()).getProjectId() != null) {
                Preconditions.checkState((boolean)table.isAccessible(), (Object)"Cannot call validate if table is dynamically set.");
                BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(bqOptions);
                BigQueryHelpers.verifyDatasetPresence(datasetService, (TableReference)table.get());
                BigQueryHelpers.verifyTablePresence(datasetService, (TableReference)table.get());
            } else if (this.getValidate() && this.getQuery() != null) {
                Preconditions.checkState((boolean)this.getQuery().isAccessible(), (Object)"Cannot call validate if query is dynamically set.");
                BigQueryServices.JobService jobService = this.getBigQueryServices().getJobService(bqOptions);
                try {
                    jobService.dryRunQuery(bqOptions.getProject(), new JobConfigurationQuery().setQuery((String)this.getQuery().get()).setFlattenResults(this.getFlattenResults()).setUseLegacySql(this.getUseLegacySql()));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format(QUERY_VALIDATION_FAILURE_ERROR, this.getQuery().get()), e);
                }
            }
        }

        public PCollection<TableRow> expand(PBegin input) {
            final String stepUuid = BigQueryHelpers.randomUUIDString();
            BigQuerySourceBase source = this.getQuery() != null && (!this.getQuery().isAccessible() || !Strings.isNullOrEmpty((String)((String)this.getQuery().get()))) ? BigQueryQuerySource.create(stepUuid, this.getQuery(), this.getFlattenResults(), this.getUseLegacySql(), this.getBigQueryServices()) : BigQueryTableSource.create(stepUuid, this.getTableProvider(), this.getBigQueryServices());
            PassThroughThenCleanup.CleanupOperation cleanupOperation = new PassThroughThenCleanup.CleanupOperation(){

                @Override
                void cleanup(PipelineOptions options) throws Exception {
                    List<ResourceId> extractFiles;
                    BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
                    String extractDestinationDir = BigQueryHelpers.resolveTempLocation(bqOptions.getTempLocation(), "BigQueryExtractTemp", stepUuid);
                    JobReference jobRef = new JobReference().setProjectId(bqOptions.getProject()).setJobId(BigQueryHelpers.getExtractJobId(BigQueryHelpers.createJobIdToken(bqOptions.getJobName(), stepUuid)));
                    Job extractJob = Read.this.getBigQueryServices().getJobService(bqOptions).getJob(jobRef);
                    if (extractJob != null && (extractFiles = BigQueryIO.getExtractFilePaths(extractDestinationDir, extractJob)) != null && !extractFiles.isEmpty()) {
                        FileSystems.delete(extractFiles, (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
                    }
                }
            };
            return (PCollection)((PCollection)input.getPipeline().apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)source))).setCoder(this.getDefaultOutputCoder()).apply(new PassThroughThenCleanup(cleanupOperation));
        }

        protected Coder<TableRow> getDefaultOutputCoder() {
            return TableRowJsonCoder.of();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"table", BigQueryHelpers.displayTable(this.getTableProvider())).withLabel("Table")).addIfNotNull(DisplayData.item((String)"query", this.getQuery()).withLabel("Query")).addIfNotNull(DisplayData.item((String)"flattenResults", (Boolean)this.getFlattenResults()).withLabel("Flatten Query Results")).addIfNotNull(DisplayData.item((String)"useLegacySql", (Boolean)this.getUseLegacySql()).withLabel("Use Legacy SQL Dialect")).addIfNotDefault(DisplayData.item((String)"validation", (Boolean)this.getValidate()).withLabel("Validation Enabled"), (Object)true);
        }

        @Nullable
        public ValueProvider<TableReference> getTableProvider() {
            return this.getJsonTableRef() == null ? null : ValueProvider.NestedValueProvider.of(this.getJsonTableRef(), (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableRef());
        }

        @Nullable
        public TableReference getTable() {
            ValueProvider<TableReference> provider = this.getTableProvider();
            return provider == null ? null : (TableReference)provider.get();
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setJsonTableRef(ValueProvider<String> var1);

            abstract Builder setQuery(ValueProvider<String> var1);

            abstract Builder setValidate(boolean var1);

            abstract Builder setFlattenResults(Boolean var1);

            abstract Builder setUseLegacySql(Boolean var1);

            abstract Builder setBigQueryServices(BigQueryServices var1);

            abstract Read build();
        }
    }
}

