/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.storage;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.FileSystemRegistrar;
import org.apache.beam.sdk.io.gcp.storage.GcsFileSystem;
import org.apache.beam.sdk.options.GcsOptions;
import org.apache.beam.sdk.options.PipelineOptions;

@AutoService(value=FileSystemRegistrar.class)
public class GcsFileSystemRegistrar
implements FileSystemRegistrar {
    static final String GCS_SCHEME = "gs";

    public FileSystem fromOptions(@Nonnull PipelineOptions options) {
        Preconditions.checkNotNull((Object)options, (Object)"Expect the runner have called FileSystems.setDefaultConfigInWorkers().");
        return new GcsFileSystem((GcsOptions)options.as(GcsOptions.class));
    }

    public String getScheme() {
        return GCS_SCHEME;
    }
}

