/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;
import org.joda.time.Duration;

final class AutoValue_ElasticsearchIO_RetryConfiguration
extends ElasticsearchIO.RetryConfiguration {
    private final int maxAttempts;
    private final Duration maxDuration;
    private final ElasticsearchIO.RetryConfiguration.RetryPredicate retryPredicate;

    private AutoValue_ElasticsearchIO_RetryConfiguration(int maxAttempts, Duration maxDuration, ElasticsearchIO.RetryConfiguration.RetryPredicate retryPredicate) {
        this.maxAttempts = maxAttempts;
        this.maxDuration = maxDuration;
        this.retryPredicate = retryPredicate;
    }

    @Override
    int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    Duration getMaxDuration() {
        return this.maxDuration;
    }

    @Override
    ElasticsearchIO.RetryConfiguration.RetryPredicate getRetryPredicate() {
        return this.retryPredicate;
    }

    public String toString() {
        return "RetryConfiguration{maxAttempts=" + this.maxAttempts + ", maxDuration=" + this.maxDuration + ", retryPredicate=" + this.retryPredicate + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ElasticsearchIO.RetryConfiguration) {
            ElasticsearchIO.RetryConfiguration that = (ElasticsearchIO.RetryConfiguration)o;
            return this.maxAttempts == that.getMaxAttempts() && this.maxDuration.equals((Object)that.getMaxDuration()) && this.retryPredicate.equals(that.getRetryPredicate());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.maxAttempts;
        h$ *= 1000003;
        h$ ^= this.maxDuration.hashCode();
        h$ *= 1000003;
        return h$ ^= this.retryPredicate.hashCode();
    }

    @Override
    ElasticsearchIO.RetryConfiguration.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends ElasticsearchIO.RetryConfiguration.Builder {
        private Integer maxAttempts;
        private Duration maxDuration;
        private ElasticsearchIO.RetryConfiguration.RetryPredicate retryPredicate;

        Builder() {
        }

        private Builder(ElasticsearchIO.RetryConfiguration source) {
            this.maxAttempts = source.getMaxAttempts();
            this.maxDuration = source.getMaxDuration();
            this.retryPredicate = source.getRetryPredicate();
        }

        @Override
        ElasticsearchIO.RetryConfiguration.Builder setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        @Override
        ElasticsearchIO.RetryConfiguration.Builder setMaxDuration(Duration maxDuration) {
            if (maxDuration == null) {
                throw new NullPointerException("Null maxDuration");
            }
            this.maxDuration = maxDuration;
            return this;
        }

        @Override
        ElasticsearchIO.RetryConfiguration.Builder setRetryPredicate(ElasticsearchIO.RetryConfiguration.RetryPredicate retryPredicate) {
            if (retryPredicate == null) {
                throw new NullPointerException("Null retryPredicate");
            }
            this.retryPredicate = retryPredicate;
            return this;
        }

        @Override
        ElasticsearchIO.RetryConfiguration build() {
            if (this.maxAttempts == null || this.maxDuration == null || this.retryPredicate == null) {
                StringBuilder missing = new StringBuilder();
                if (this.maxAttempts == null) {
                    missing.append(" maxAttempts");
                }
                if (this.maxDuration == null) {
                    missing.append(" maxDuration");
                }
                if (this.retryPredicate == null) {
                    missing.append(" retryPredicate");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ElasticsearchIO_RetryConfiguration(this.maxAttempts, this.maxDuration, this.retryPredicate);
        }
    }
}

