/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import org.apache.beam.sdk.io.elasticsearch.ElasticsearchIO;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_ElasticsearchIO_Read
extends ElasticsearchIO.Read {
    private final @Nullable ElasticsearchIO.ConnectionConfiguration connectionConfiguration;
    private final @Nullable ValueProvider<String> query;
    private final boolean withMetadata;
    private final String scrollKeepalive;
    private final long batchSize;

    private AutoValue_ElasticsearchIO_Read(@Nullable ElasticsearchIO.ConnectionConfiguration connectionConfiguration, @Nullable ValueProvider<String> query, boolean withMetadata, String scrollKeepalive, long batchSize) {
        this.connectionConfiguration = connectionConfiguration;
        this.query = query;
        this.withMetadata = withMetadata;
        this.scrollKeepalive = scrollKeepalive;
        this.batchSize = batchSize;
    }

    @Override
    @Nullable ElasticsearchIO.ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    @Override
    @Nullable ValueProvider<String> getQuery() {
        return this.query;
    }

    @Override
    boolean isWithMetadata() {
        return this.withMetadata;
    }

    @Override
    String getScrollKeepalive() {
        return this.scrollKeepalive;
    }

    @Override
    long getBatchSize() {
        return this.batchSize;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ElasticsearchIO.Read) {
            ElasticsearchIO.Read that = (ElasticsearchIO.Read)((Object)o);
            return (this.connectionConfiguration == null ? that.getConnectionConfiguration() == null : this.connectionConfiguration.equals(that.getConnectionConfiguration())) && (this.query == null ? that.getQuery() == null : this.query.equals(that.getQuery())) && this.withMetadata == that.isWithMetadata() && this.scrollKeepalive.equals(that.getScrollKeepalive()) && this.batchSize == that.getBatchSize();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.connectionConfiguration == null ? 0 : this.connectionConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.query == null ? 0 : this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.withMetadata ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.scrollKeepalive.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(this.batchSize >>> 32 ^ this.batchSize);
    }

    @Override
    ElasticsearchIO.Read.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends ElasticsearchIO.Read.Builder {
        private @Nullable ElasticsearchIO.ConnectionConfiguration connectionConfiguration;
        private @Nullable ValueProvider<String> query;
        private Boolean withMetadata;
        private String scrollKeepalive;
        private Long batchSize;

        Builder() {
        }

        private Builder(ElasticsearchIO.Read source) {
            this.connectionConfiguration = source.getConnectionConfiguration();
            this.query = source.getQuery();
            this.withMetadata = source.isWithMetadata();
            this.scrollKeepalive = source.getScrollKeepalive();
            this.batchSize = source.getBatchSize();
        }

        @Override
        ElasticsearchIO.Read.Builder setConnectionConfiguration(ElasticsearchIO.ConnectionConfiguration connectionConfiguration) {
            this.connectionConfiguration = connectionConfiguration;
            return this;
        }

        @Override
        ElasticsearchIO.Read.Builder setQuery(ValueProvider<String> query) {
            this.query = query;
            return this;
        }

        @Override
        ElasticsearchIO.Read.Builder setWithMetadata(boolean withMetadata) {
            this.withMetadata = withMetadata;
            return this;
        }

        @Override
        ElasticsearchIO.Read.Builder setScrollKeepalive(String scrollKeepalive) {
            if (scrollKeepalive == null) {
                throw new NullPointerException("Null scrollKeepalive");
            }
            this.scrollKeepalive = scrollKeepalive;
            return this;
        }

        @Override
        ElasticsearchIO.Read.Builder setBatchSize(long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        ElasticsearchIO.Read build() {
            String missing = "";
            if (this.withMetadata == null) {
                missing = missing + " withMetadata";
            }
            if (this.scrollKeepalive == null) {
                missing = missing + " scrollKeepalive";
            }
            if (this.batchSize == null) {
                missing = missing + " batchSize";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ElasticsearchIO_Read(this.connectionConfiguration, this.query, this.withMetadata, this.scrollKeepalive, this.batchSize);
        }
    }
}

