/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.io.cassandra.CassandraIO;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ConnectionManager {
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Cluster> clusterMap = new ConcurrentHashMap();
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Session> sessionMap = new ConcurrentHashMap();

    private static @UnknownKeyFor @NonNull @Initialized String readToClusterHash(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CassandraIO.Read<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> read) {
        return ((List)Objects.requireNonNull(read.hosts()).get()).stream().reduce(",", (a, b) -> a + b) + Objects.requireNonNull(read.port()).get() + ConnectionManager.safeVPGet(read.localDc()) + ConnectionManager.safeVPGet(read.consistencyLevel());
    }

    private static @UnknownKeyFor @NonNull @Initialized String readToSessionHash(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CassandraIO.Read<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> read) {
        return ConnectionManager.readToClusterHash(read) + (String)read.keyspace().get();
    }

    static @UnknownKeyFor @NonNull @Initialized Session getSession(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CassandraIO.Read<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> read) {
        Cluster cluster = clusterMap.computeIfAbsent(ConnectionManager.readToClusterHash(read), k -> CassandraIO.getCluster(Objects.requireNonNull(read.hosts()), Objects.requireNonNull(read.port()), read.username(), read.password(), read.localDc(), read.consistencyLevel(), read.connectTimeout(), read.readTimeout()));
        return sessionMap.computeIfAbsent(ConnectionManager.readToSessionHash(read), k -> cluster.connect((String)Objects.requireNonNull(read.keyspace()).get()));
    }

    private static @UnknownKeyFor @NonNull @Initialized String safeVPGet(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> s) {
        return s != null ? (String)s.get() : "";
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (Session session : sessionMap.values()) {
                if (session.isClosed()) continue;
                session.close();
            }
        }));
    }
}

