/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.io.cassandra.RingRange;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SplitGenerator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SplitGenerator.class);
    private final @UnknownKeyFor @NonNull @Initialized String partitioner;
    private final @UnknownKeyFor @NonNull @Initialized BigInteger rangeMin;
    private final @UnknownKeyFor @NonNull @Initialized BigInteger rangeMax;
    private final @UnknownKeyFor @NonNull @Initialized BigInteger rangeSize;

    SplitGenerator(@UnknownKeyFor @NonNull @Initialized String partitioner) {
        this.rangeMin = SplitGenerator.getRangeMin(partitioner);
        this.rangeMax = SplitGenerator.getRangeMax(partitioner);
        this.rangeSize = SplitGenerator.getRangeSize(partitioner);
        this.partitioner = partitioner;
    }

    static @UnknownKeyFor @NonNull @Initialized BigInteger getRangeMin(@UnknownKeyFor @NonNull @Initialized String partitioner) {
        if (partitioner.endsWith("RandomPartitioner")) {
            return BigInteger.ZERO;
        }
        if (partitioner.endsWith("Murmur3Partitioner")) {
            return BigInteger.valueOf(2L).pow(63).negate();
        }
        throw new UnsupportedOperationException("Unsupported partitioner. Only Random and Murmur3 are supported");
    }

    static @UnknownKeyFor @NonNull @Initialized BigInteger getRangeMax(@UnknownKeyFor @NonNull @Initialized String partitioner) {
        if (partitioner.endsWith("RandomPartitioner")) {
            return BigInteger.valueOf(2L).pow(127).subtract(BigInteger.ONE);
        }
        if (partitioner.endsWith("Murmur3Partitioner")) {
            return BigInteger.valueOf(2L).pow(63).subtract(BigInteger.ONE);
        }
        throw new UnsupportedOperationException("Unsupported partitioner. Only Random and Murmur3 are supported");
    }

    static @UnknownKeyFor @NonNull @Initialized BigInteger getRangeSize(@UnknownKeyFor @NonNull @Initialized String partitioner) {
        return SplitGenerator.getRangeMax(partitioner).subtract(SplitGenerator.getRangeMin(partitioner)).add(BigInteger.ONE);
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RingRange>> generateSplits(@UnknownKeyFor @NonNull @Initialized long totalSplitCount, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BigInteger> ringTokens) {
        int tokenRangeCount = ringTokens.size();
        ArrayList<RingRange> splits = new ArrayList<RingRange>();
        for (int i = 0; i < tokenRangeCount; ++i) {
            int j;
            BigInteger start = ringTokens.get(i);
            BigInteger stop = ringTokens.get((i + 1) % tokenRangeCount);
            if (!this.isInRange(start) || !this.isInRange(stop)) {
                throw new RuntimeException(String.format("Tokens (%s,%s) not in range of %s", start, stop, this.partitioner));
            }
            if (start.equals(stop) && tokenRangeCount != 1) {
                throw new RuntimeException(String.format("Tokens (%s,%s): two nodes have the same token", start, stop));
            }
            BigInteger rs = stop.subtract(start);
            if (rs.compareTo(BigInteger.ZERO) <= 0) {
                rs = rs.add(this.rangeSize);
            }
            BigInteger[] splitCountAndRemainder = rs.multiply(BigInteger.valueOf(totalSplitCount)).divideAndRemainder(this.rangeSize);
            int splitCount = splitCountAndRemainder[0].intValue() + (splitCountAndRemainder[1].equals(BigInteger.ZERO) ? 0 : 1);
            LOG.debug("Dividing token range [{},{}) into {} splits", new Object[]{start, stop, splitCount});
            ArrayList<BigInteger> endpointTokens = new ArrayList<BigInteger>();
            for (j = 0; j <= splitCount; ++j) {
                BigInteger offset = rs.multiply(BigInteger.valueOf(j)).divide(BigInteger.valueOf(splitCount));
                BigInteger token = start.add(offset);
                if (token.compareTo(this.rangeMax) > 0) {
                    token = token.subtract(this.rangeSize);
                }
                endpointTokens.add(token.equals(BigInteger.valueOf(Long.MIN_VALUE)) ? token.add(BigInteger.ONE) : token);
            }
            for (j = 0; j < splitCount; ++j) {
                splits.add(RingRange.of((BigInteger)endpointTokens.get(j), (BigInteger)endpointTokens.get(j + 1)));
                LOG.debug("Split #{}: [{},{})", new Object[]{j + 1, endpointTokens.get(j), endpointTokens.get(j + 1)});
            }
        }
        BigInteger total = BigInteger.ZERO;
        for (RingRange split : splits) {
            BigInteger size = split.span(this.rangeSize);
            total = total.add(size);
        }
        if (!total.equals(this.rangeSize)) {
            throw new RuntimeException("Some tokens are missing from the splits. This should not happen.");
        }
        return this.coalesceSplits(this.getTargetSplitSize(totalSplitCount), splits);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isInRange(@UnknownKeyFor @NonNull @Initialized BigInteger token) {
        return token.compareTo(this.rangeMin) >= 0 && token.compareTo(this.rangeMax) <= 0;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RingRange>> coalesceSplits(@UnknownKeyFor @NonNull @Initialized BigInteger targetSplitSize, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RingRange> splits) {
        ArrayList<List<RingRange>> coalescedSplits = new ArrayList<List<RingRange>>();
        ArrayList<RingRange> tokenRangesForCurrentSplit = new ArrayList<RingRange>();
        BigInteger tokenCount = BigInteger.ZERO;
        for (RingRange tokenRange : splits) {
            if (tokenRange.span(this.rangeSize).add(tokenCount).compareTo(targetSplitSize) > 0 && !tokenRangesForCurrentSplit.isEmpty()) {
                LOG.debug("Got enough tokens for one split ({}) : {}", (Object)tokenCount, tokenRangesForCurrentSplit);
                coalescedSplits.add(tokenRangesForCurrentSplit);
                tokenRangesForCurrentSplit = new ArrayList();
                tokenCount = BigInteger.ZERO;
            }
            tokenCount = tokenCount.add(tokenRange.span(this.rangeSize));
            tokenRangesForCurrentSplit.add(tokenRange);
        }
        if (!tokenRangesForCurrentSplit.isEmpty()) {
            coalescedSplits.add(tokenRangesForCurrentSplit);
        }
        return coalescedSplits;
    }

    private @UnknownKeyFor @NonNull @Initialized BigInteger getTargetSplitSize(@UnknownKeyFor @NonNull @Initialized long splitCount) {
        return this.rangeMax.subtract(this.rangeMin).divide(BigInteger.valueOf(splitCount));
    }
}

