/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import java.io.Serializable;
import java.math.BigInteger;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public final class RingRange
implements Serializable {
    private final BigInteger start;
    private final BigInteger end;

    private RingRange(BigInteger start, BigInteger end) {
        this.start = start;
        this.end = end;
    }

    public BigInteger getStart() {
        return this.start;
    }

    public BigInteger getEnd() {
        return this.end;
    }

    BigInteger span(BigInteger ringSize) {
        return this.start.compareTo(this.end) >= 0 ? this.end.subtract(this.start).add(ringSize) : this.end.subtract(this.start);
    }

    public boolean isWrapping() {
        return this.start.compareTo(this.end) >= 0;
    }

    public String toString() {
        return String.format("(%s,%s]", this.start.toString(), this.end.toString());
    }

    public static RingRange of(BigInteger start, BigInteger end) {
        return new RingRange(start, end);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RingRange ringRange = (RingRange)o;
        if (this.getStart() != null ? !this.getStart().equals(ringRange.getStart()) : ringRange.getStart() != null) {
            return false;
        }
        return this.getEnd() != null ? this.getEnd().equals(ringRange.getEnd()) : ringRange.getEnd() == null;
    }

    public int hashCode() {
        int result = this.getStart() != null ? this.getStart().hashCode() : 0;
        result = 31 * result + (this.getEnd() != null ? this.getEnd().hashCode() : 0);
        return result;
    }
}

