/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.Token;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.cassandra.CassandraIO;
import org.apache.beam.sdk.io.cassandra.ConnectionManager;
import org.apache.beam.sdk.io.cassandra.Mapper;
import org.apache.beam.sdk.io.cassandra.RingRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadFn<T>
extends DoFn<CassandraIO.Read<T>, T> {
    private static final Logger LOG = LoggerFactory.getLogger(ReadFn.class);

    ReadFn() {
    }

    @DoFn.ProcessElement
    public void processElement(@DoFn.Element CassandraIO.Read<T> read, DoFn.OutputReceiver<T> receiver) {
        try {
            Session session = ConnectionManager.getSession(read);
            Mapper mapper = (Mapper)read.mapperFactoryFn().apply((Object)session);
            String partitionKey = session.getCluster().getMetadata().getKeyspace((String)read.keyspace().get()).getTable((String)read.table().get()).getPartitionKey().stream().map(ColumnMetadata::getName).collect(Collectors.joining(","));
            String query = ReadFn.generateRangeQuery(read, partitionKey, read.ringRanges() != null);
            PreparedStatement preparedStatement = session.prepare(query);
            Set ringRanges = read.ringRanges() == null ? Collections.emptySet() : (Set)read.ringRanges().get();
            for (RingRange rr : ringRanges) {
                Token startToken = session.getCluster().getMetadata().newToken(rr.getStart().toString());
                Token endToken = session.getCluster().getMetadata().newToken(rr.getEnd().toString());
                if (rr.isWrapping()) {
                    ReadFn.outputResults(session.execute(ReadFn.getLowestSplitQuery(read, partitionKey, rr.getEnd())), receiver, mapper);
                    ReadFn.outputResults(session.execute(ReadFn.getHighestSplitQuery(read, partitionKey, rr.getStart())), receiver, mapper);
                    continue;
                }
                ResultSet rs = session.execute((Statement)preparedStatement.bind().setToken(0, startToken).setToken(1, endToken));
                ReadFn.outputResults(rs, receiver, mapper);
            }
            if (read.ringRanges() == null) {
                ResultSet rs = session.execute((Statement)preparedStatement.bind());
                ReadFn.outputResults(rs, receiver, mapper);
            }
        }
        catch (Exception ex) {
            LOG.error("error", (Throwable)ex);
        }
    }

    private static <T> void outputResults(ResultSet rs, DoFn.OutputReceiver<T> outputReceiver, Mapper<T> mapper) {
        Iterator<T> iter = mapper.map(rs);
        while (iter.hasNext()) {
            T n = iter.next();
            outputReceiver.output(n);
        }
    }

    private static String getHighestSplitQuery(CassandraIO.Read<?> spec, String partitionKey, BigInteger highest) {
        String highestClause = String.format("(token(%s) >= %d)", partitionKey, highest);
        String finalHighQuery = spec.query() == null ? ReadFn.buildInitialQuery(spec, true) + highestClause : spec.query() + " AND " + highestClause;
        LOG.debug("CassandraIO generated a wrapAround query : {}", (Object)finalHighQuery);
        return finalHighQuery;
    }

    private static String getLowestSplitQuery(CassandraIO.Read<?> spec, String partitionKey, BigInteger lowest) {
        String lowestClause = String.format("(token(%s) < %d)", partitionKey, lowest);
        String finalLowQuery = spec.query() == null ? ReadFn.buildInitialQuery(spec, true) + lowestClause : spec.query() + " AND " + lowestClause;
        LOG.debug("CassandraIO generated a wrapAround query : {}", (Object)finalLowQuery);
        return finalLowQuery;
    }

    private static String generateRangeQuery(CassandraIO.Read<?> spec, String partitionKey, Boolean hasRingRange) {
        String rangeFilter = hasRingRange != false ? Joiner.on((String)" AND ").skipNulls().join((Object)String.format("(token(%s) >= ?)", partitionKey), (Object)String.format("(token(%s) < ?)", partitionKey), new Object[0]) : "";
        String combinedQuery = ReadFn.buildInitialQuery(spec, hasRingRange) + rangeFilter;
        LOG.debug("CassandraIO generated query : {}", (Object)combinedQuery);
        return combinedQuery;
    }

    private static String buildInitialQuery(CassandraIO.Read<?> spec, Boolean hasRingRange) {
        return spec.query() == null ? String.format("SELECT * FROM %s.%s", spec.keyspace().get(), spec.table().get()) + " WHERE " : (String)spec.query().get() + (hasRingRange != false ? " AND " : "");
    }
}

