/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.cassandra;

import java.math.BigInteger;

final class RingRange {
    private final BigInteger start;
    private final BigInteger end;

    RingRange(BigInteger start, BigInteger end) {
        this.start = start;
        this.end = end;
    }

    BigInteger getStart() {
        return this.start;
    }

    BigInteger getEnd() {
        return this.end;
    }

    BigInteger span(BigInteger ringSize) {
        return this.start.compareTo(this.end) >= 0 ? this.end.subtract(this.start).add(ringSize) : this.end.subtract(this.start);
    }

    public boolean isWrapping() {
        return this.start.compareTo(this.end) >= 0;
    }

    public String toString() {
        return String.format("(%s,%s]", this.start.toString(), this.end.toString());
    }
}

