/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.beam.fn.harness.FnApiDoFnRunner;
import org.apache.beam.fn.harness.HandlesSplits;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.fn.harness.ProgressUtils;
import org.apache.beam.fn.harness.SplitResultsWithStopIndex;
import org.apache.beam.fn.harness.WindowedSplitResult;
import org.apache.beam.fn.harness.control.BundleProgressReporter;
import org.apache.beam.fn.harness.control.BundleSplitListener;
import org.apache.beam.fn.harness.state.FnApiStateAccessor;
import org.apache.beam.fn.harness.state.FnApiTimerBundleTracker;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.LateDataUtils;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.ShortIdMap;
import org.apache.beam.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.fn.splittabledofn.RestrictionTrackers;
import org.apache.beam.sdk.fn.splittabledofn.WatermarkEstimators;
import org.apache.beam.sdk.function.ThrowingRunnable;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateBinder;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.TimerMap;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.transforms.splittabledofn.TimestampObservingWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.construction.ParDoTranslation;
import org.apache.beam.sdk.util.construction.RehydratedComponents;
import org.apache.beam.sdk.util.construction.Timer;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.Timestamp;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.util.Durations;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Table;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;

@Internal
public class FnApiDoFnRunner<InputT, RestrictionT, PositionT, WatermarkEstimatorStateT, OutputT>
implements FnApiStateAccessor.MutatingStateContext<Object, BoundedWindow> {
    private final PipelineOptions pipelineOptions;
    private final String pTransformId;
    private final RunnerApi.PTransform pTransform;
    private final DoFn<InputT, OutputT> doFn;
    private final DoFnSignature doFnSignature;
    private final TupleTag<OutputT> mainOutputTag;
    private final Coder<?> inputCoder;
    private final SchemaCoder<OutputT> mainOutputSchemaCoder;
    private final Coder<? extends BoundedWindow> windowCoder;
    private final Map<TupleTag<?>, Coder<?>> outputCoders;
    private final Map<String, KV<TimeDomain, Coder<Timer<Object>>>> timerFamilyInfos;
    private final RunnerApi.ParDoPayload parDoPayload;
    private final Map<String, FnDataReceiver<WindowedValue<?>>> localNameToConsumer;
    private final BundleSplitListener splitListener;
    private final DoFn.BundleFinalizer bundleFinalizer;
    private final FnDataReceiver<WindowedValue<OutputT>> mainOutputConsumer;
    private final String mainInputId;
    private final FnApiStateAccessor<?> stateAccessor;
    private final Map<String, FnDataReceiver<?>> outboundTimerReceivers;
    private final @Nullable FnApiTimerBundleTracker timerBundleTracker;
    private final DoFnInvoker<InputT, OutputT> doFnInvoker;
    private final StartBundleArgumentProvider startBundleArgumentProvider;
    private final ProcessBundleContextBase processContext;
    private final OnTimerContext<?> onTimerContext;
    private final OnWindowExpirationContext<?> onWindowExpirationContext;
    private final FinishBundleArgumentProvider finishBundleArgumentProvider;
    private final Duration allowedLateness;
    private final String workCompletedShortId;
    private final String workRemainingShortId;
    private final Object splitLock = new Object();
    private final DoFnSchemaInformation doFnSchemaInformation;
    private final Map<String, PCollectionView<?>> sideInputMapping;
    private WindowedValue<InputT> currentElement;
    private Object currentKey;
    private List<BoundedWindow> currentWindows;
    private int windowStopIndex;
    private int windowCurrentIndex;
    private RestrictionT currentRestriction;
    private WatermarkEstimatorStateT currentWatermarkEstimatorState;
    private Instant initialWatermark;
    private WatermarkEstimators.WatermarkAndStateObserver<WatermarkEstimatorStateT> currentWatermarkEstimator;
    private BoundedWindow currentWindow;
    private RestrictionTracker<RestrictionT, PositionT> currentTracker;
    private @Nullable AtomicBoolean currentTrackerClaimed;
    private Timer<?> currentTimer;
    private TimeDomain currentTimeDomain;

    /*
     * WARNING - void declaration
     */
    FnApiDoFnRunner(PipelineOptions pipelineOptions, ShortIdMap shortIds, String pTransformId, RunnerApi.PTransform pTransform, RunnerApi.Components components, Consumer<ThrowingRunnable> addStartFunction, Consumer<ThrowingRunnable> addFinishFunction, Consumer<ThrowingRunnable> addResetFunction, Consumer<ThrowingRunnable> addTearDownFunction, Function<String, FnDataReceiver<WindowedValue<?>>> getPCollectionConsumer, BiConsumer<String, FnDataReceiver> addPCollectionConsumer, BiFunction<String, Coder<Timer<Object>>, FnDataReceiver<Timer<Object>>> getOutgoingTimersConsumer, Consumer<BundleProgressReporter> addBundleProgressReporter, BundleSplitListener splitListener, DoFn.BundleFinalizer bundleFinalizer, FnApiStateAccessor<Object> stateAccessor) {
        boolean bl;
        void var22_50;
        void var20_38;
        void var22_45;
        String mainInput;
        void var20_32;
        Coder keyCoder;
        Object mainInputTag;
        this.pipelineOptions = pipelineOptions;
        this.pTransformId = pTransformId;
        this.pTransform = pTransform;
        try {
            void var20_24;
            RehydratedComponents rehydratedComponents = RehydratedComponents.forComponents((RunnerApi.Components)components).withPipeline(Pipeline.create());
            this.parDoPayload = RunnerApi.ParDoPayload.parseFrom((ByteString)pTransform.getSpec().getPayload());
            this.doFn = ParDoTranslation.getDoFn((RunnerApi.ParDoPayload)this.parDoPayload);
            this.doFnSignature = DoFnSignatures.signatureForDoFn(this.doFn);
            String string = pTransform.getSpec().getUrn();
            int n = -1;
            switch (string.hashCode()) {
                case 1881026324: {
                    if (!string.equals("beam:transform:sdf_process_sized_element_and_restrictions:v1")) break;
                    boolean bl2 = false;
                    break;
                }
                case -1912952382: {
                    if (!string.equals("beam:transform:pardo:v1")) break;
                    boolean bl3 = true;
                    break;
                }
                case 400474464: {
                    if (!string.equals("beam:transform:sdf_split_and_size_restrictions:v1")) break;
                    int n2 = 2;
                }
            }
            switch (var20_24) {
                case 0: 
                case 1: {
                    this.mainOutputTag = ParDoTranslation.getMainOutputTag((RunnerApi.ParDoPayload)this.parDoPayload);
                    break;
                }
                case 2: {
                    this.mainOutputTag = new TupleTag((String)Iterables.getOnlyElement(pTransform.getOutputsMap().keySet()));
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unknown urn: %s", pTransform.getSpec().getUrn()));
                }
            }
            mainInputTag = (String)Iterables.getOnlyElement((Iterable)Sets.difference(pTransform.getInputsMap().keySet(), this.parDoPayload.getSideInputsMap().keySet()));
            RunnerApi.PCollection pCollection = (RunnerApi.PCollection)components.getPcollectionsMap().get(pTransform.getInputsOrThrow((String)mainInputTag));
            Coder maybeWindowedValueInputCoder = rehydratedComponents.getCoder(pCollection.getCoderId());
            this.inputCoder = maybeWindowedValueInputCoder instanceof WindowedValues.WindowedValueCoder ? ((WindowedValues.WindowedValueCoder)maybeWindowedValueInputCoder).getValueCoder() : maybeWindowedValueInputCoder;
            keyCoder = this.inputCoder instanceof KvCoder ? ((KvCoder)this.inputCoder).getKeyCoder() : null;
            WindowingStrategy windowingStrategy = rehydratedComponents.getWindowingStrategy(pCollection.getWindowingStrategyId());
            this.windowCoder = windowingStrategy.getWindowFn().windowCoder();
            this.outputCoders = Maps.newHashMap();
            for (Map.Entry entry : pTransform.getOutputsMap().entrySet()) {
                TupleTag outputTag = new TupleTag((String)entry.getKey());
                RunnerApi.PCollection outputPCollection = (RunnerApi.PCollection)components.getPcollectionsMap().get(entry.getValue());
                Coder outputCoder = rehydratedComponents.getCoder(outputPCollection.getCoderId());
                if (outputCoder instanceof WindowedValues.WindowedValueCoder) {
                    outputCoder = ((WindowedValues.WindowedValueCoder)outputCoder).getValueCoder();
                }
                this.outputCoders.put(outputTag, outputCoder);
            }
            Coder<?> outputCoder = this.outputCoders.get(this.mainOutputTag);
            this.mainOutputSchemaCoder = outputCoder instanceof SchemaCoder ? (SchemaCoder)outputCoder : null;
            ImmutableMap.Builder timerFamilyInfosBuilder = ImmutableMap.builder();
            for (Map.Entry entry : this.parDoPayload.getTimerFamilySpecsMap().entrySet()) {
                String timerIdOrTimerFamilyId = (String)entry.getKey();
                TimeDomain timeDomain = this.translateTimeDomain(((RunnerApi.TimerFamilySpec)entry.getValue()).getTimeDomain());
                Coder timerCoder = rehydratedComponents.getCoder(((RunnerApi.TimerFamilySpec)entry.getValue()).getTimerFamilyCoderId());
                timerFamilyInfosBuilder.put((Object)timerIdOrTimerFamilyId, (Object)KV.of((Object)timeDomain, (Object)timerCoder));
            }
            this.timerFamilyInfos = timerFamilyInfosBuilder.build();
            this.mainInputId = ParDoTranslation.getMainInputName((RunnerApi.PTransformOrBuilder)pTransform);
            this.allowedLateness = rehydratedComponents.getPCollection(pTransform.getInputsOrThrow(this.mainInputId)).getWindowingStrategy().getAllowedLateness();
        }
        catch (IOException exn) {
            throw new IllegalArgumentException("Malformed ParDoPayload", exn);
        }
        ImmutableMap.Builder localNameToConsumerBuilder = ImmutableMap.builder();
        for (Map.Entry entry : pTransform.getOutputsMap().entrySet()) {
            localNameToConsumerBuilder.put((Object)((String)entry.getKey()), getPCollectionConsumer.apply((String)entry.getValue()));
        }
        this.localNameToConsumer = localNameToConsumerBuilder.build();
        this.splitListener = splitListener;
        this.bundleFinalizer = bundleFinalizer;
        this.onTimerContext = new OnTimerContext();
        this.onWindowExpirationContext = new OnWindowExpirationContext();
        this.mainOutputConsumer = this.localNameToConsumer.get(this.mainOutputTag.getId());
        this.doFnSchemaInformation = ParDoTranslation.getSchemaInformation((RunnerApi.ParDoPayload)this.parDoPayload);
        this.sideInputMapping = ParDoTranslation.getSideInputMapping((RunnerApi.ParDoPayload)this.parDoPayload);
        this.doFnInvoker = DoFnInvokers.tryInvokeSetupFor(this.doFn, (PipelineOptions)pipelineOptions);
        this.startBundleArgumentProvider = new StartBundleArgumentProvider();
        mainInputTag = pTransform.getSpec().getUrn();
        int n = -1;
        switch (((String)mainInputTag).hashCode()) {
            case -1912952382: {
                if (!((String)mainInputTag).equals("beam:transform:pardo:v1")) break;
                boolean bl4 = false;
                break;
            }
            case 1881026324: {
                if (!((String)mainInputTag).equals("beam:transform:sdf_process_sized_element_and_restrictions:v1")) break;
                boolean bl5 = true;
                break;
            }
            case 400474464: {
                if (!((String)mainInputTag).equals("beam:transform:sdf_split_and_size_restrictions:v1")) break;
                int n3 = 2;
            }
        }
        switch (var20_32) {
            case 0: 
            case 1: {
                addStartFunction.accept(this::startBundle);
                break;
            }
        }
        try {
            mainInput = ParDoTranslation.getMainInputName((RunnerApi.PTransformOrBuilder)pTransform);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Object object = pTransform.getSpec().getUrn();
        int n4 = -1;
        switch (((String)object).hashCode()) {
            case -1912952382: {
                if (!((String)object).equals("beam:transform:pardo:v1")) break;
                boolean bl6 = false;
                break;
            }
            case 1881026324: {
                if (!((String)object).equals("beam:transform:sdf_process_sized_element_and_restrictions:v1")) break;
                boolean bl7 = true;
            }
        }
        switch (var22_45) {
            case 0: {
                if (this.doFnSignature.processElement().observesWindow() || !this.sideInputMapping.isEmpty()) {
                    FnDataReceiver fnDataReceiver = this::processElementForWindowObservingParDo;
                    this.processContext = new WindowObservingProcessBundleContext();
                    break;
                }
                FnDataReceiver fnDataReceiver = this::processElementForParDo;
                this.processContext = new NonWindowObservingProcessBundleContext();
                break;
            }
            case 1: {
                if (this.doFnSignature.processElement().observesWindow() || this.doFnSignature.newTracker() != null && this.doFnSignature.newTracker().observesWindow() || this.doFnSignature.getSize() != null && this.doFnSignature.getSize().observesWindow() || this.doFnSignature.newWatermarkEstimator() != null && this.doFnSignature.newWatermarkEstimator().observesWindow() || !this.sideInputMapping.isEmpty()) {
                    SplittableFnDataReceiver splittableFnDataReceiver = new SplittableFnDataReceiver(){

                        public void accept(WindowedValue input) throws Exception {
                            FnApiDoFnRunner.this.processElementForWindowObservingSizedElementAndRestriction(input);
                        }
                    };
                    this.processContext = new WindowObservingProcessBundleContext();
                    break;
                }
                SplittableFnDataReceiver splittableFnDataReceiver = new SplittableFnDataReceiver(){

                    public void accept(WindowedValue input) throws Exception {
                        FnApiDoFnRunner.this.processElementForWindowObservingSizedElementAndRestriction(input);
                    }
                };
                this.processContext = new WindowObservingProcessBundleContext();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown urn: " + pTransform.getSpec().getUrn());
            }
        }
        addPCollectionConsumer.accept(pTransform.getInputsOrThrow(mainInput), (FnDataReceiver)var20_38);
        this.finishBundleArgumentProvider = new FinishBundleArgumentProvider();
        object = pTransform.getSpec().getUrn();
        int n5 = -1;
        switch (((String)object).hashCode()) {
            case -1912952382: {
                if (!((String)object).equals("beam:transform:pardo:v1")) break;
                boolean bl8 = false;
                break;
            }
            case 1881026324: {
                if (!((String)object).equals("beam:transform:sdf_process_sized_element_and_restrictions:v1")) break;
                boolean bl9 = true;
                break;
            }
            case 400474464: {
                if (!((String)object).equals("beam:transform:sdf_split_and_size_restrictions:v1")) break;
                int n6 = 2;
            }
        }
        switch (var22_50) {
            case 0: 
            case 1: {
                addFinishFunction.accept(this::finishBundle);
                break;
            }
        }
        addTearDownFunction.accept(this::tearDown);
        this.workCompletedShortId = shortIds.getOrCreateShortId(new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.WORK_COMPLETED).setType("beam:metrics:progress:v1").setLabel("PTRANSFORM", pTransformId).build());
        this.workRemainingShortId = shortIds.getOrCreateShortId(new SimpleMonitoringInfoBuilder().setUrn(MonitoringInfoConstants.Urns.WORK_REMAINING).setType("beam:metrics:progress:v1").setLabel("PTRANSFORM", pTransformId).build());
        object = pTransform.getSpec().getUrn();
        int n7 = -1;
        switch (((String)object).hashCode()) {
            case 1881026324: {
                if (!((String)object).equals("beam:transform:sdf_process_sized_element_and_restrictions:v1")) break;
                bl = false;
            }
        }
        switch (bl) {
            case 0: {
                addBundleProgressReporter.accept(new BundleProgressReporter(){

                    @Override
                    public void updateIntermediateMonitoringData(Map<String, ByteString> monitoringData) {
                        ByteString encodedWorkRemaining;
                        ByteString encodedWorkCompleted;
                        RestrictionTracker.Progress progress = FnApiDoFnRunner.this.getProgress();
                        if (progress == null) {
                            return;
                        }
                        try {
                            encodedWorkCompleted = this.encodeProgress(progress.getWorkCompleted());
                            encodedWorkRemaining = this.encodeProgress(progress.getWorkRemaining());
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to encode progress", e);
                        }
                        monitoringData.put(FnApiDoFnRunner.this.workCompletedShortId, encodedWorkCompleted);
                        monitoringData.put(FnApiDoFnRunner.this.workRemainingShortId, encodedWorkRemaining);
                    }

                    @Override
                    public void updateFinalMonitoringData(Map<String, ByteString> monitoringData) {
                    }

                    @Override
                    public void reset() {
                    }

                    private ByteString encodeProgress(double value) throws IOException {
                        ByteStringOutputStream output = new ByteStringOutputStream();
                        IterableCoder.of((Coder)DoubleCoder.of()).encode(Arrays.asList(value), (OutputStream)output);
                        return output.toByteString();
                    }
                });
                break;
            }
        }
        this.stateAccessor = stateAccessor;
        this.outboundTimerReceivers = new HashMap();
        if (this.timerFamilyInfos.isEmpty()) {
            this.timerBundleTracker = null;
        } else {
            this.timerBundleTracker = new FnApiTimerBundleTracker<Object>(keyCoder, this.windowCoder, this::getCurrentKey, () -> this.currentWindow);
            addResetFunction.accept(this.timerBundleTracker::reset);
            for (Map.Entry entry : this.timerFamilyInfos.entrySet()) {
                String localName = (String)entry.getKey();
                Coder timerCoder = (Coder)((KV)entry.getValue()).getValue();
                this.outboundTimerReceivers.put(localName, getOutgoingTimersConsumer.apply(localName, (Coder<Timer<Object>>)timerCoder));
            }
        }
    }

    @Override
    public Object getCurrentKey() {
        if (this.currentKey != null) {
            return this.currentKey;
        }
        if (this.currentElement != null) {
            Preconditions.checkState((boolean)(this.currentElement.getValue() instanceof KV), (String)"Accessing state in unkeyed context. Current element is not a KV: %s.", (Object)this.currentElement.getValue());
            return ((KV)this.currentElement.getValue()).getKey();
        }
        if (this.currentTimer != null) {
            return this.currentTimer.getUserKey();
        }
        return null;
    }

    @Override
    public BoundedWindow getCurrentWindow() {
        return this.currentWindow;
    }

    private void startBundle() {
        this.doFnInvoker.invokeStartBundle((DoFnInvoker.ArgumentProvider)this.startBundleArgumentProvider);
    }

    private void processElementForParDo(WindowedValue<InputT> elem) {
        this.currentElement = elem;
        try {
            this.doFnInvoker.invokeProcessElement((DoFnInvoker.ArgumentProvider)this.processContext);
        }
        finally {
            this.currentElement = null;
        }
    }

    private void processElementForWindowObservingParDo(WindowedValue<InputT> elem) {
        this.currentElement = elem;
        try {
            for (BoundedWindow this.currentWindow : elem.getWindows()) {
                this.doFnInvoker.invokeProcessElement((DoFnInvoker.ArgumentProvider)this.processContext);
            }
        }
        finally {
            this.currentElement = null;
            this.currentWindow = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processElementForWindowObservingSizedElementAndRestriction(WindowedValue<KV<KV<InputT, KV<RestrictionT, WatermarkEstimatorStateT>>, Double>> elem) {
        this.currentElement = elem.withValue(((KV)((KV)elem.getValue()).getKey()).getKey());
        this.windowCurrentIndex = -1;
        this.windowStopIndex = this.currentElement.getWindows().size();
        this.currentWindows = ImmutableList.copyOf((Collection)this.currentElement.getWindows());
        while (true) {
            Object object = this.splitLock;
            synchronized (object) {
                ++this.windowCurrentIndex;
                if (this.windowCurrentIndex >= this.windowStopIndex) {
                    this.windowCurrentIndex = -1;
                    this.windowStopIndex = 0;
                    this.currentElement = null;
                    this.currentWindows = null;
                    this.currentRestriction = null;
                    this.currentWatermarkEstimatorState = null;
                    this.currentWindow = null;
                    this.currentTracker = null;
                    this.currentWatermarkEstimator = null;
                    this.initialWatermark = null;
                    return;
                }
                this.currentRestriction = ((KV)((KV)((KV)elem.getValue()).getKey()).getValue()).getKey();
                this.currentWatermarkEstimatorState = ((KV)((KV)((KV)elem.getValue()).getKey()).getValue()).getValue();
                this.currentWindow = this.currentWindows.get(this.windowCurrentIndex);
                this.currentTrackerClaimed = new AtomicBoolean(false);
                this.currentTracker = RestrictionTrackers.observe((RestrictionTracker)this.doFnInvoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this.processContext), (RestrictionTrackers.ClaimObserver)new RestrictionTrackers.ClaimObserver<PositionT>(){
                    private final AtomicBoolean claimed;
                    {
                        this.claimed = (AtomicBoolean)Preconditions.checkNotNull((Object)FnApiDoFnRunner.this.currentTrackerClaimed);
                    }

                    public void onClaimed(PositionT position) {
                        this.claimed.lazySet(true);
                    }

                    public void onClaimFailed(PositionT position) {
                    }
                });
                this.currentWatermarkEstimator = WatermarkEstimators.threadSafe((WatermarkEstimator)this.doFnInvoker.invokeNewWatermarkEstimator((DoFnInvoker.ArgumentProvider)this.processContext));
                this.initialWatermark = (Instant)this.currentWatermarkEstimator.getWatermarkAndState().getKey();
            }
            DoFn.ProcessContinuation continuation = this.doFnInvoker.invokeProcessElement((DoFnInvoker.ArgumentProvider)this.processContext);
            if (!continuation.shouldResume()) {
                this.currentTracker.checkDone();
                continue;
            }
            HandlesSplits.SplitResult splitResult = this.trySplitForElementAndRestriction(0.0, continuation.resumeDelay(), false);
            if (splitResult == null) {
                this.currentTracker.checkDone();
                continue;
            }
            this.splitListener.split(splitResult.getPrimaryRoots(), splitResult.getResidualRoots());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestrictionTracker.Progress getProgress() {
        Object object = this.splitLock;
        synchronized (object) {
            if (this.currentTracker instanceof RestrictionTracker.HasProgress && this.currentWindow != null) {
                return ProgressUtils.scaleProgress(((RestrictionTracker.HasProgress)this.currentTracker).getProgress(), this.windowCurrentIndex, this.windowStopIndex);
            }
        }
        return null;
    }

    private WindowedSplitResult calculateRestrictionSize(final WindowedSplitResult splitResult, String errorContext) {
        double fullSize = splitResult.getResidualInUnprocessedWindowsRoot() == null && splitResult.getPrimaryInFullyProcessedWindowsRoot() == null ? 0.0 : this.doFnInvoker.invokeGetSize((DoFnInvoker.ArgumentProvider)new DoFnInvoker.DelegatingArgumentProvider<InputT, OutputT>(this.processContext, errorContext){

            public Object restriction() {
                return FnApiDoFnRunner.this.currentRestriction;
            }

            public RestrictionTracker<?, ?> restrictionTracker() {
                return FnApiDoFnRunner.this.doFnInvoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this);
            }
        });
        double primarySize = splitResult.getPrimarySplitRoot() == null ? 0.0 : this.doFnInvoker.invokeGetSize((DoFnInvoker.ArgumentProvider)new DoFnInvoker.DelegatingArgumentProvider<InputT, OutputT>(this.processContext, errorContext){

            public Object restriction() {
                return ((KV)((KV)splitResult.getPrimarySplitRoot().getValue()).getValue()).getKey();
            }

            public RestrictionTracker<?, ?> restrictionTracker() {
                return FnApiDoFnRunner.this.doFnInvoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this);
            }
        });
        double residualSize = splitResult.getResidualSplitRoot() == null ? 0.0 : this.doFnInvoker.invokeGetSize((DoFnInvoker.ArgumentProvider)new DoFnInvoker.DelegatingArgumentProvider<InputT, OutputT>(this.processContext, errorContext){

            public Object restriction() {
                return ((KV)((KV)splitResult.getResidualSplitRoot().getValue()).getValue()).getKey();
            }

            public RestrictionTracker<?, ?> restrictionTracker() {
                return FnApiDoFnRunner.this.doFnInvoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this);
            }
        });
        return WindowedSplitResult.forRoots(splitResult.getPrimaryInFullyProcessedWindowsRoot() == null ? null : WindowedValues.of((Object)KV.of((Object)splitResult.getPrimaryInFullyProcessedWindowsRoot().getValue(), (Object)fullSize), (Instant)splitResult.getPrimaryInFullyProcessedWindowsRoot().getTimestamp(), (Collection)splitResult.getPrimaryInFullyProcessedWindowsRoot().getWindows(), (PaneInfo)splitResult.getPrimaryInFullyProcessedWindowsRoot().getPaneInfo()), splitResult.getPrimarySplitRoot() == null ? null : WindowedValues.of((Object)KV.of((Object)splitResult.getPrimarySplitRoot().getValue(), (Object)primarySize), (Instant)splitResult.getPrimarySplitRoot().getTimestamp(), (Collection)splitResult.getPrimarySplitRoot().getWindows(), (PaneInfo)splitResult.getPrimarySplitRoot().getPaneInfo()), splitResult.getResidualSplitRoot() == null ? null : WindowedValues.of((Object)KV.of((Object)splitResult.getResidualSplitRoot().getValue(), (Object)residualSize), (Instant)splitResult.getResidualSplitRoot().getTimestamp(), (Collection)splitResult.getResidualSplitRoot().getWindows(), (PaneInfo)splitResult.getResidualSplitRoot().getPaneInfo()), splitResult.getResidualInUnprocessedWindowsRoot() == null ? null : WindowedValues.of((Object)KV.of((Object)splitResult.getResidualInUnprocessedWindowsRoot().getValue(), (Object)fullSize), (Instant)splitResult.getResidualInUnprocessedWindowsRoot().getTimestamp(), (Collection)splitResult.getResidualInUnprocessedWindowsRoot().getWindows(), (PaneInfo)splitResult.getResidualInUnprocessedWindowsRoot().getPaneInfo()));
    }

    private static <WatermarkEstimatorStateT> WindowedSplitResult computeWindowSplitResult(WindowedValue currentElement, Object currentRestriction, BoundedWindow currentWindow, List<BoundedWindow> windows, WatermarkEstimatorStateT currentWatermarkEstimatorState, int toIndex, int fromIndex, int stopWindowIndex, SplitResult<?> splitResult, KV<Instant, WatermarkEstimatorStateT> watermarkAndState) {
        List<BoundedWindow> primaryFullyProcessedWindows = windows.subList(0, toIndex);
        List<BoundedWindow> residualUnprocessedWindows = windows.subList(fromIndex, stopWindowIndex);
        WindowedSplitResult windowedSplitResult = WindowedSplitResult.forRoots(primaryFullyProcessedWindows.isEmpty() ? null : WindowedValues.of((Object)KV.of((Object)currentElement.getValue(), (Object)KV.of((Object)currentRestriction, currentWatermarkEstimatorState)), (Instant)currentElement.getTimestamp(), primaryFullyProcessedWindows, (PaneInfo)currentElement.getPaneInfo()), splitResult == null ? null : WindowedValues.of((Object)KV.of((Object)currentElement.getValue(), (Object)KV.of((Object)splitResult.getPrimary(), currentWatermarkEstimatorState)), (Instant)currentElement.getTimestamp(), (BoundedWindow)currentWindow, (PaneInfo)currentElement.getPaneInfo()), splitResult == null ? null : WindowedValues.of((Object)KV.of((Object)currentElement.getValue(), (Object)KV.of((Object)splitResult.getResidual(), (Object)watermarkAndState.getValue())), (Instant)currentElement.getTimestamp(), (BoundedWindow)currentWindow, (PaneInfo)currentElement.getPaneInfo()), residualUnprocessedWindows.isEmpty() ? null : WindowedValues.of((Object)KV.of((Object)currentElement.getValue(), (Object)KV.of((Object)currentRestriction, currentWatermarkEstimatorState)), (Instant)currentElement.getTimestamp(), residualUnprocessedWindows, (PaneInfo)currentElement.getPaneInfo()));
        return windowedSplitResult;
    }

    @VisibleForTesting
    static <WatermarkEstimatorStateT> SplitResultsWithStopIndex computeSplitForProcess(WindowedValue currentElement, Object currentRestriction, BoundedWindow currentWindow, List<BoundedWindow> windows, WatermarkEstimatorStateT currentWatermarkEstimatorState, double fractionOfRemainder, RestrictionTracker currentTracker, HandlesSplits splitDelegate, KV<Instant, WatermarkEstimatorStateT> watermarkAndState, int currentWindowIndex, int stopWindowIndex) {
        Preconditions.checkArgument((boolean)(currentTracker != null ^ splitDelegate != null));
        if (currentTracker != null) {
            Preconditions.checkNotNull(watermarkAndState);
        }
        WindowedSplitResult windowedSplitResult = null;
        HandlesSplits.SplitResult downstreamSplitResult = null;
        int newWindowStopIndex = stopWindowIndex;
        if (currentWindowIndex != stopWindowIndex - 1) {
            RestrictionTracker.Progress elementProgress;
            if (currentTracker != null) {
                elementProgress = currentTracker instanceof RestrictionTracker.HasProgress ? ((RestrictionTracker.HasProgress)currentTracker).getProgress() : RestrictionTracker.Progress.from((double)0.0, (double)1.0);
            } else {
                double elementCompleted = splitDelegate.getProgress();
                elementProgress = RestrictionTracker.Progress.from((double)elementCompleted, (double)(1.0 - elementCompleted));
            }
            RestrictionTracker.Progress scaledProgress = ProgressUtils.scaleProgress(elementProgress, currentWindowIndex, stopWindowIndex);
            double scaledFractionOfRemainder = scaledProgress.getWorkRemaining() * fractionOfRemainder;
            if (scaledFractionOfRemainder >= elementProgress.getWorkRemaining()) {
                newWindowStopIndex = (int)Math.min((long)(stopWindowIndex - 1), (long)currentWindowIndex + Math.max(1L, Math.round((elementProgress.getWorkCompleted() + scaledFractionOfRemainder) / (elementProgress.getWorkCompleted() + elementProgress.getWorkRemaining()))));
                windowedSplitResult = FnApiDoFnRunner.computeWindowSplitResult(currentElement, currentRestriction, currentWindow, windows, currentWatermarkEstimatorState, newWindowStopIndex, newWindowStopIndex, stopWindowIndex, null, watermarkAndState);
            } else {
                SplitResult elementSplit = null;
                if (currentTracker != null) {
                    elementSplit = currentTracker.trySplit(scaledFractionOfRemainder / elementProgress.getWorkRemaining());
                } else {
                    downstreamSplitResult = splitDelegate.trySplit(scaledFractionOfRemainder);
                }
                newWindowStopIndex = currentWindowIndex + 1;
                int toIndex = elementSplit == null && downstreamSplitResult == null ? newWindowStopIndex : currentWindowIndex;
                windowedSplitResult = FnApiDoFnRunner.computeWindowSplitResult(currentElement, currentRestriction, currentWindow, windows, currentWatermarkEstimatorState, toIndex, newWindowStopIndex, stopWindowIndex, elementSplit, watermarkAndState);
            }
        } else {
            SplitResult elementSplitResult = null;
            newWindowStopIndex = stopWindowIndex;
            if (currentTracker != null) {
                elementSplitResult = currentTracker.trySplit(fractionOfRemainder);
            } else {
                downstreamSplitResult = splitDelegate.trySplit(fractionOfRemainder);
            }
            if (elementSplitResult == null && downstreamSplitResult == null) {
                return null;
            }
            windowedSplitResult = FnApiDoFnRunner.computeWindowSplitResult(currentElement, currentRestriction, currentWindow, windows, currentWatermarkEstimatorState, currentWindowIndex, stopWindowIndex, stopWindowIndex, elementSplitResult, watermarkAndState);
        }
        return SplitResultsWithStopIndex.of(windowedSplitResult, downstreamSplitResult, newWindowStopIndex);
    }

    @VisibleForTesting
    static <WatermarkEstimatorStateT> HandlesSplits.SplitResult constructSplitResult(WindowedSplitResult windowedSplitResult, HandlesSplits.SplitResult downstreamElementSplit, Coder fullInputCoder, Instant initialWatermark, KV<Instant, WatermarkEstimatorStateT> watermarkAndState, String pTransformId, String mainInputId, Collection<String> outputIds, Duration resumeDelay) {
        Preconditions.checkArgument((windowedSplitResult == null || windowedSplitResult.getResidualSplitRoot() == null || downstreamElementSplit == null ? 1 : 0) != 0);
        ArrayList<BeamFnApi.BundleApplication> primaryRoots = new ArrayList<BeamFnApi.BundleApplication>();
        ArrayList<BeamFnApi.DelayedBundleApplication> residualRoots = new ArrayList<BeamFnApi.DelayedBundleApplication>();
        if (windowedSplitResult != null && windowedSplitResult.getPrimaryInFullyProcessedWindowsRoot() != null) {
            ByteStringOutputStream primaryInOtherWindowsBytes = new ByteStringOutputStream();
            try {
                fullInputCoder.encode(windowedSplitResult.getPrimaryInFullyProcessedWindowsRoot(), (OutputStream)primaryInOtherWindowsBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            BeamFnApi.BundleApplication.Builder primaryApplicationInOtherWindows = BeamFnApi.BundleApplication.newBuilder().setTransformId(pTransformId).setInputId(mainInputId).setElement(primaryInOtherWindowsBytes.toByteString());
            primaryRoots.add(primaryApplicationInOtherWindows.build());
        }
        if (windowedSplitResult != null && windowedSplitResult.getResidualInUnprocessedWindowsRoot() != null) {
            ByteStringOutputStream bytesOut = new ByteStringOutputStream();
            try {
                fullInputCoder.encode(windowedSplitResult.getResidualInUnprocessedWindowsRoot(), (OutputStream)bytesOut);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            BeamFnApi.BundleApplication.Builder residualInUnprocessedWindowsRoot = BeamFnApi.BundleApplication.newBuilder().setTransformId(pTransformId).setInputId(mainInputId).setElement(bytesOut.toByteString());
            HashMap<String, Timestamp> outputWatermarkMapForUnprocessedWindows = new HashMap<String, Timestamp>();
            if (!initialWatermark.equals((Object)GlobalWindow.TIMESTAMP_MIN_VALUE)) {
                Timestamp outputWatermark = Timestamp.newBuilder().setSeconds(initialWatermark.getMillis() / 1000L).setNanos((int)(initialWatermark.getMillis() % 1000L) * 1000000).build();
                for (String outputId : outputIds) {
                    outputWatermarkMapForUnprocessedWindows.put(outputId, outputWatermark);
                }
            }
            residualInUnprocessedWindowsRoot.putAllOutputWatermarks(outputWatermarkMapForUnprocessedWindows);
            residualRoots.add(BeamFnApi.DelayedBundleApplication.newBuilder().setApplication(residualInUnprocessedWindowsRoot).build());
        }
        ByteStringOutputStream primaryBytes = new ByteStringOutputStream();
        ByteStringOutputStream residualBytes = new ByteStringOutputStream();
        if (windowedSplitResult != null && windowedSplitResult.getResidualSplitRoot() != null) {
            Preconditions.checkNotNull((Object)resumeDelay);
            try {
                fullInputCoder.encode(windowedSplitResult.getPrimarySplitRoot(), (OutputStream)primaryBytes);
                fullInputCoder.encode(windowedSplitResult.getResidualSplitRoot(), (OutputStream)residualBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            primaryRoots.add(BeamFnApi.BundleApplication.newBuilder().setTransformId(pTransformId).setInputId(mainInputId).setElement(primaryBytes.toByteString()).build());
            BeamFnApi.BundleApplication.Builder residualApplication = BeamFnApi.BundleApplication.newBuilder().setTransformId(pTransformId).setInputId(mainInputId).setElement(residualBytes.toByteString());
            HashMap<String, Timestamp> outputWatermarkMap = new HashMap<String, Timestamp>();
            if (!((Instant)watermarkAndState.getKey()).equals((Object)GlobalWindow.TIMESTAMP_MIN_VALUE)) {
                Timestamp outputWatermark = Timestamp.newBuilder().setSeconds(((Instant)watermarkAndState.getKey()).getMillis() / 1000L).setNanos((int)(((Instant)watermarkAndState.getKey()).getMillis() % 1000L) * 1000000).build();
                for (String outputId : outputIds) {
                    outputWatermarkMap.put(outputId, outputWatermark);
                }
            }
            residualApplication.putAllOutputWatermarks(outputWatermarkMap);
            residualRoots.add(BeamFnApi.DelayedBundleApplication.newBuilder().setApplication(residualApplication).setRequestedTimeDelay(Durations.fromMillis((long)resumeDelay.getMillis())).build());
        } else if (downstreamElementSplit != null) {
            primaryRoots.add((BeamFnApi.BundleApplication)Iterables.getOnlyElement(downstreamElementSplit.getPrimaryRoots()));
            residualRoots.add((BeamFnApi.DelayedBundleApplication)Iterables.getOnlyElement(downstreamElementSplit.getResidualRoots()));
        }
        return HandlesSplits.SplitResult.of(primaryRoots, residualRoots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HandlesSplits.SplitResult trySplitForElementAndRestriction(double fractionOfRemainder, Duration resumeDelay, boolean requireClaimForCheckpoint) {
        WindowedSplitResult windowedSplitResult = null;
        Object object = this.splitLock;
        synchronized (object) {
            if (this.currentTracker == null) {
                return null;
            }
            if (fractionOfRemainder == 0.0 && requireClaimForCheckpoint && this.currentTrackerClaimed != null && !this.currentTrackerClaimed.get()) {
                return null;
            }
            KV watermarkAndState = this.currentWatermarkEstimator.getWatermarkAndState();
            SplitResultsWithStopIndex splitResult = FnApiDoFnRunner.computeSplitForProcess(this.currentElement, this.currentRestriction, this.currentWindow, this.currentWindows, this.currentWatermarkEstimatorState, fractionOfRemainder, this.currentTracker, null, watermarkAndState, this.windowCurrentIndex, this.windowStopIndex);
            if (splitResult == null) {
                return null;
            }
            this.windowStopIndex = splitResult.getNewWindowStopIndex();
            windowedSplitResult = this.calculateRestrictionSize(splitResult.getWindowSplit(), "beam:transform:sdf_process_sized_element_and_restrictions:v1/GetSize");
            WindowedValues.FullWindowedValueCoder fullInputCoder = WindowedValues.getFullCoder(this.inputCoder, this.windowCoder);
            return FnApiDoFnRunner.constructSplitResult(windowedSplitResult, null, (Coder)fullInputCoder, this.initialWatermark, watermarkAndState, this.pTransformId, this.mainInputId, this.pTransform.getOutputsMap().keySet(), resumeDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K> void processTimer(String timerIdOrTimerFamilyId, TimeDomain timeDomain, Timer<K> timer) {
        Preconditions.checkNotNull((Object)this.timerBundleTracker);
        try {
            this.currentKey = timer.getUserKey();
            for (BoundedWindow this.currentWindow : timer.getWindows()) {
                String timerId;
                FnApiTimerBundleTracker.Modifications bundleModifications = this.timerBundleTracker.getBundleModifications();
                Table modifiedTimerIds = bundleModifications.getModifiedTimerIds();
                NavigableSet<FnApiTimerBundleTracker.TimerInfo<K>> earlierTimers = bundleModifications.getModifiedTimersOrdered(timeDomain).headSet(FnApiTimerBundleTracker.TimerInfo.of(timer, "", timeDomain), true);
                while (!earlierTimers.isEmpty()) {
                    FnApiTimerBundleTracker.TimerInfo<K> insertedTimer = earlierTimers.pollFirst();
                    if (this.timerModified(modifiedTimerIds, insertedTimer.getTimerFamilyOrId(), insertedTimer.getTimer())) continue;
                    timerId = insertedTimer.getTimer().getDynamicTimerTag().isEmpty() ? insertedTimer.getTimerFamilyOrId() : insertedTimer.getTimer().getDynamicTimerTag();
                    String timerFamily = insertedTimer.getTimer().getDynamicTimerTag().isEmpty() ? "" : insertedTimer.getTimerFamilyOrId();
                    modifiedTimerIds.put((Object)insertedTimer.getTimerFamilyOrId(), (Object)insertedTimer.getTimer().getDynamicTimerTag(), (Object)Timer.cleared((Object)insertedTimer.getTimer().getUserKey(), (String)insertedTimer.getTimer().getDynamicTimerTag(), (Collection)insertedTimer.getTimer().getWindows()));
                    this.processTimerDirect(timerFamily, timerId, insertedTimer.getTimeDomain(), insertedTimer.getTimer());
                }
                if (this.timerModified(modifiedTimerIds, timerIdOrTimerFamilyId, timer)) continue;
                boolean isFamily = timerIdOrTimerFamilyId.startsWith("tfs-");
                timerId = isFamily ? "" : timerIdOrTimerFamilyId;
                String timerFamilyId = isFamily ? timerIdOrTimerFamilyId : "";
                this.processTimerDirect(timerFamilyId, timerId, timeDomain, timer);
            }
        }
        finally {
            this.currentKey = null;
            this.currentTimer = null;
            this.currentTimeDomain = null;
            this.currentWindow = null;
        }
    }

    private <K> boolean timerModified(Table<String, String, Timer<K>> modifiedTimerIds, String timerFamilyOrId, Timer<K> timer) {
        @Nullable Timer modifiedTimer = (Timer)modifiedTimerIds.get((Object)timerFamilyOrId, (Object)timer.getDynamicTimerTag());
        return modifiedTimer != null && !modifiedTimer.equals(timer);
    }

    private <K> void processTimerDirect(String timerFamilyId, String timerId, TimeDomain timeDomain, Timer<K> timer) {
        this.currentTimer = timer;
        this.currentTimeDomain = timeDomain;
        this.doFnInvoker.invokeOnTimer(timerId, timerFamilyId, this.onTimerContext);
    }

    private <K> void processOnWindowExpiration(Timer<K> timer) {
        try {
            this.currentKey = timer.getUserKey();
            this.currentTimer = timer;
            for (BoundedWindow this.currentWindow : timer.getWindows()) {
                this.doFnInvoker.invokeOnWindowExpiration(this.onWindowExpirationContext);
            }
        }
        finally {
            this.currentKey = null;
            this.currentTimer = null;
            this.currentWindow = null;
        }
    }

    private void finishBundle() throws Exception {
        if (this.timerBundleTracker != null) {
            this.timerBundleTracker.outputTimers(this.outboundTimerReceivers::get);
        }
        this.doFnInvoker.invokeFinishBundle((DoFnInvoker.ArgumentProvider)this.finishBundleArgumentProvider);
        this.stateAccessor.finalizeState();
    }

    private void tearDown() {
        this.doFnInvoker.invokeTeardown();
    }

    private <T> void outputTo(FnDataReceiver<WindowedValue<T>> consumer, WindowedValue<T> output) {
        if (this.currentWatermarkEstimator instanceof TimestampObservingWatermarkEstimator) {
            ((TimestampObservingWatermarkEstimator)this.currentWatermarkEstimator).observeTimestamp(output.getTimestamp());
        }
        try {
            consumer.accept(output);
        }
        catch (Throwable t) {
            throw UserCodeException.wrap((Throwable)t);
        }
    }

    private void checkTimestamp(Instant timestamp) {
        Instant lowerBound;
        try {
            lowerBound = this.currentElement.getTimestamp().minus((ReadableDuration)this.doFn.getAllowedTimestampSkew());
        }
        catch (ArithmeticException e) {
            lowerBound = BoundedWindow.TIMESTAMP_MIN_VALUE;
        }
        if (timestamp.isBefore((ReadableInstant)lowerBound) || timestamp.isAfter((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE)) {
            throw new IllegalArgumentException(String.format("Cannot output with timestamp %s. Output timestamps must be no earlier than the timestamp of the current input (%s) minus the allowed skew (%s) and no later than %s. See the DoFn#getAllowedTimestampSkew() Javadoc for details on changing the allowed skew.", timestamp, this.currentElement.getTimestamp(), this.doFn.getAllowedTimestampSkew().getMillis() >= Integer.MAX_VALUE ? this.doFn.getAllowedTimestampSkew() : PeriodFormat.getDefault().print((ReadablePeriod)this.doFn.getAllowedTimestampSkew().toPeriod()), BoundedWindow.TIMESTAMP_MAX_VALUE));
        }
    }

    private TimeDomain translateTimeDomain(RunnerApi.TimeDomain.Enum domain) {
        switch (domain) {
            case EVENT_TIME: {
                return TimeDomain.EVENT_TIME;
            }
            case PROCESSING_TIME: {
                return TimeDomain.PROCESSING_TIME;
            }
        }
        throw new IllegalArgumentException("Unknown time domain");
    }

    private class OnTimerContext<K>
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT> {
        private final Context context = new Context();
        private final DoFn.OutputReceiver<Row> mainRowOutputReceiver = FnApiDoFnRunner.access$3800(FnApiDoFnRunner.this) == null ? null : new DoFn.OutputReceiver<Row>(){
            private final SerializableFunction<Row, OutputT> fromRowFunction;
            {
                this.fromRowFunction = FnApiDoFnRunner.this.mainOutputSchemaCoder.getFromRowFunction();
            }

            public void output(Row output) {
                OnTimerContext.this.context.outputWithTimestamp(this.fromRowFunction.apply((Object)output), FnApiDoFnRunner.this.currentElement.getTimestamp());
            }

            public void outputWithTimestamp(Row output, Instant timestamp) {
                OnTimerContext.this.context.outputWithTimestamp(this.fromRowFunction.apply((Object)output), timestamp);
            }

            public void outputWindowedValue(Row output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
                OnTimerContext.this.context.outputWindowedValue(this.fromRowFunction.apply((Object)output), timestamp, windows, paneInfo);
            }
        };
        private final DoFn.MultiOutputReceiver taggedOutputReceiver = new DoFn.MultiOutputReceiver(){
            private final Map<TupleTag<?>, DoFn.OutputReceiver<?>> taggedOutputReceivers = new HashMap();
            private final Map<TupleTag<?>, DoFn.OutputReceiver<Row>> taggedRowReceivers = new HashMap();

            private <T> DoFn.OutputReceiver<T> createTaggedOutputReceiver(final TupleTag<T> tag) {
                if (tag == null || FnApiDoFnRunner.this.mainOutputTag.equals(tag)) {
                    return OnTimerContext.this.context;
                }
                return new DoFn.OutputReceiver<T>(){

                    public void output(T output) {
                        OnTimerContext.this.context.output(tag, output);
                    }

                    public void outputWithTimestamp(T output, Instant timestamp) {
                        OnTimerContext.this.context.outputWithTimestamp(tag, output, timestamp);
                    }

                    public void outputWindowedValue(T output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
                        OnTimerContext.this.context.outputWindowedValue(tag, output, timestamp, windows, paneInfo);
                    }
                };
            }

            private <T> DoFn.OutputReceiver<Row> createTaggedRowReceiver(final TupleTag<T> tag) {
                if (tag == null || FnApiDoFnRunner.this.mainOutputTag.equals(tag)) {
                    Preconditions.checkState((FnApiDoFnRunner.this.mainOutputSchemaCoder != null ? 1 : 0) != 0, (Object)("Output with tag " + FnApiDoFnRunner.this.mainOutputTag + " must have a schema in order to call getRowReceiver"));
                    return OnTimerContext.this.mainRowOutputReceiver;
                }
                final Coder outputCoder = (Coder)FnApiDoFnRunner.this.outputCoders.get(tag);
                Preconditions.checkState((outputCoder != null ? 1 : 0) != 0, (Object)("No output tag for " + tag));
                Preconditions.checkState((boolean)(outputCoder instanceof SchemaCoder), (Object)("Output with tag " + tag + " must have a schema in order to call getRowReceiver"));
                return new DoFn.OutputReceiver<Row>(){
                    private SerializableFunction<Row, T> fromRowFunction;
                    {
                        this.fromRowFunction = ((SchemaCoder)outputCoder).getFromRowFunction();
                    }

                    public void output(Row output) {
                        OnTimerContext.this.context.output(tag, this.fromRowFunction.apply((Object)output));
                    }

                    public void outputWithTimestamp(Row output, Instant timestamp) {
                        OnTimerContext.this.context.outputWithTimestamp(tag, this.fromRowFunction.apply((Object)output), timestamp);
                    }

                    public void outputWindowedValue(Row output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
                        OnTimerContext.this.context.outputWindowedValue(tag, this.fromRowFunction.apply((Object)output), timestamp, windows, paneInfo);
                    }
                };
            }

            public <T> DoFn.OutputReceiver<T> get(TupleTag<T> tag) {
                return this.taggedOutputReceivers.computeIfAbsent(tag, this::createTaggedOutputReceiver);
            }

            public <T> DoFn.OutputReceiver<Row> getRowReceiver(TupleTag<T> tag) {
                return this.taggedRowReceivers.computeIfAbsent(tag, this::createTaggedRowReceiver);
            }
        };

        private OnTimerContext() {
        }

        public BoundedWindow window() {
            return FnApiDoFnRunner.this.currentWindow;
        }

        public Instant timestamp(DoFn<InputT, OutputT> doFn) {
            return FnApiDoFnRunner.this.currentTimer.getHoldTimestamp();
        }

        public TimeDomain timeDomain(DoFn<InputT, OutputT> doFn) {
            return FnApiDoFnRunner.this.currentTimeDomain;
        }

        public K key() {
            return (K)FnApiDoFnRunner.this.currentTimer.getUserKey();
        }

        public DoFn.OutputReceiver<OutputT> outputReceiver(DoFn<InputT, OutputT> doFn) {
            return this.context;
        }

        public DoFn.OutputReceiver<Row> outputRowReceiver(DoFn<InputT, OutputT> doFn) {
            Preconditions.checkState((FnApiDoFnRunner.this.mainOutputSchemaCoder != null ? 1 : 0) != 0, (Object)("Output with tag " + FnApiDoFnRunner.this.mainOutputTag + " must have a schema in order to call getRowReceiver"));
            return this.mainRowOutputReceiver;
        }

        public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn<InputT, OutputT> doFn) {
            return this.taggedOutputReceiver;
        }

        public DoFn.OnTimerContext onTimerContext(DoFn<InputT, OutputT> doFn) {
            return this.context;
        }

        public State state(String stateId, boolean alwaysFetched) {
            StateSpec spec;
            DoFnSignature.StateDeclaration stateDeclaration = (DoFnSignature.StateDeclaration)FnApiDoFnRunner.this.doFnSignature.stateDeclarations().get(stateId);
            Preconditions.checkNotNull((Object)stateDeclaration, (String)"No state declaration found for %s", (Object)stateId);
            try {
                spec = (StateSpec)stateDeclaration.field().get(FnApiDoFnRunner.this.doFn);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            State state = spec.bind(stateId, (StateBinder)FnApiDoFnRunner.this.stateAccessor);
            if (alwaysFetched) {
                return (State)((ReadableState)state).readLater();
            }
            return state;
        }

        public org.apache.beam.sdk.state.Timer timer(String timerId) {
            TimeDomain timeDomain = FnApiDoFnRunner.this.translateTimeDomain(((RunnerApi.TimerFamilySpec)FnApiDoFnRunner.this.parDoPayload.getTimerFamilySpecsMap().get(timerId)).getTimeDomain());
            return new FnApiTimer<Object>(timerId, FnApiDoFnRunner.this.currentTimer.getUserKey(), "", FnApiDoFnRunner.this.currentWindow, FnApiDoFnRunner.this.currentTimer.getHoldTimestamp(), FnApiDoFnRunner.this.currentTimer.getFireTimestamp(), FnApiDoFnRunner.this.currentTimer.getPaneInfo(), timeDomain);
        }

        public TimerMap timerFamily(String timerFamilyId) {
            return new FnApiTimerMap<Object>(timerFamilyId, FnApiDoFnRunner.this.currentTimer.getUserKey(), FnApiDoFnRunner.this.currentWindow, FnApiDoFnRunner.this.currentTimer.getHoldTimestamp(), FnApiDoFnRunner.this.currentTimer.getFireTimestamp(), FnApiDoFnRunner.this.currentTimer.getPaneInfo());
        }

        public String timerId(DoFn<InputT, OutputT> doFn) {
            return FnApiDoFnRunner.this.currentTimer.getDynamicTimerTag();
        }

        public PipelineOptions pipelineOptions() {
            return FnApiDoFnRunner.this.pipelineOptions;
        }

        public String getErrorContext() {
            return "FnApiDoFnRunner/OnTimer";
        }

        private class Context
        extends DoFn.OnTimerContext
        implements DoFn.OutputReceiver<OutputT> {
            private Context() {
                super(FnApiDoFnRunner.this.doFn);
            }

            public PipelineOptions getPipelineOptions() {
                return FnApiDoFnRunner.this.pipelineOptions;
            }

            public BoundedWindow window() {
                return FnApiDoFnRunner.this.currentWindow;
            }

            public void output(OutputT output) {
                this.checkTimerTimestamp(FnApiDoFnRunner.this.currentTimer.getHoldTimestamp());
                FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)FnApiDoFnRunner.this.currentTimer.getHoldTimestamp(), (BoundedWindow)FnApiDoFnRunner.this.currentWindow, (PaneInfo)FnApiDoFnRunner.this.currentTimer.getPaneInfo()));
            }

            public void outputWithTimestamp(OutputT output, Instant timestamp) {
                this.checkTimerTimestamp(timestamp);
                FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, (BoundedWindow)FnApiDoFnRunner.this.currentWindow, (PaneInfo)FnApiDoFnRunner.this.currentTimer.getPaneInfo()));
            }

            public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
                this.checkTimerTimestamp(timestamp);
                FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, windows, (PaneInfo)paneInfo));
            }

            public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo, @Nullable String currentRecordId, @Nullable Long currentRecordOffset) {
                this.checkTimerTimestamp(timestamp);
                FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, windows, (PaneInfo)paneInfo, (String)currentRecordId, (Long)currentRecordOffset));
            }

            public <T> void output(TupleTag<T> tag, T output) {
                this.checkTimerTimestamp(FnApiDoFnRunner.this.currentTimer.getHoldTimestamp());
                FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
                }
                FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)FnApiDoFnRunner.this.currentTimer.getHoldTimestamp(), (BoundedWindow)FnApiDoFnRunner.this.currentWindow, (PaneInfo)FnApiDoFnRunner.this.currentTimer.getPaneInfo()));
            }

            public <T> void outputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
                this.checkTimerTimestamp(timestamp);
                FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
                }
                FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)timestamp, (BoundedWindow)FnApiDoFnRunner.this.currentWindow, (PaneInfo)FnApiDoFnRunner.this.currentTimer.getPaneInfo()));
            }

            public <T> void outputWindowedValue(TupleTag<T> tag, T output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
            }

            public <T> void outputWindowedValue(TupleTag<T> tag, T output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo, @Nullable String currentRecordId, @Nullable Long currentRecordOffset) {
            }

            public TimeDomain timeDomain() {
                return FnApiDoFnRunner.this.currentTimeDomain;
            }

            public Instant fireTimestamp() {
                return FnApiDoFnRunner.this.currentTimer.getFireTimestamp();
            }

            public Instant timestamp() {
                return FnApiDoFnRunner.this.currentTimer.getHoldTimestamp();
            }

            private void checkTimerTimestamp(Instant timestamp) {
                Instant lowerBound;
                try {
                    lowerBound = FnApiDoFnRunner.this.currentTimer.getHoldTimestamp().minus((ReadableDuration)FnApiDoFnRunner.this.doFn.getAllowedTimestampSkew());
                }
                catch (ArithmeticException e) {
                    lowerBound = BoundedWindow.TIMESTAMP_MIN_VALUE;
                }
                if (timestamp.isBefore((ReadableInstant)lowerBound) || timestamp.isAfter((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE)) {
                    throw new IllegalArgumentException(String.format("Cannot output with timestamp %s. Output timestamps must be no earlier than the timestamp of the timer (%s) minus the allowed skew (%s) and no later than %s. See the DoFn#getAllowedTimestampSkew() Javadoc for details on changing the allowed skew.", timestamp, FnApiDoFnRunner.this.currentTimer.getHoldTimestamp(), FnApiDoFnRunner.this.doFn.getAllowedTimestampSkew().getMillis() >= Integer.MAX_VALUE ? FnApiDoFnRunner.this.doFn.getAllowedTimestampSkew() : PeriodFormat.getDefault().print((ReadablePeriod)FnApiDoFnRunner.this.doFn.getAllowedTimestampSkew().toPeriod()), BoundedWindow.TIMESTAMP_MAX_VALUE));
                }
            }
        }
    }

    private class OnWindowExpirationContext<K>
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT> {
        private final Context context = new Context();
        private final DoFn.OutputReceiver<Row> mainRowOutputReceiver = FnApiDoFnRunner.access$3800(FnApiDoFnRunner.this) == null ? null : new DoFn.OutputReceiver<Row>(){
            private final SerializableFunction<Row, OutputT> fromRowFunction;
            {
                this.fromRowFunction = FnApiDoFnRunner.this.mainOutputSchemaCoder.getFromRowFunction();
            }

            public void output(Row output) {
                OnWindowExpirationContext.this.context.output(this.fromRowFunction.apply((Object)output));
            }

            public void outputWithTimestamp(Row output, Instant timestamp) {
                OnWindowExpirationContext.this.context.outputWithTimestamp(this.fromRowFunction.apply((Object)output), timestamp);
            }

            public void outputWindowedValue(Row output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
                OnWindowExpirationContext.this.context.outputWindowedValue(this.fromRowFunction.apply((Object)output), timestamp, windows, paneInfo);
            }
        };
        private final DoFn.MultiOutputReceiver taggedOutputReceiver = new DoFn.MultiOutputReceiver(){
            private final Map<TupleTag<?>, DoFn.OutputReceiver<?>> taggedOutputReceivers = new HashMap();
            private final Map<TupleTag<?>, DoFn.OutputReceiver<Row>> taggedRowReceivers = new HashMap();

            private <T> DoFn.OutputReceiver<T> createTaggedOutputReceiver(final TupleTag<T> tag) {
                if (tag == null || FnApiDoFnRunner.this.mainOutputTag.equals(tag)) {
                    return OnWindowExpirationContext.this.context;
                }
                return new DoFn.OutputReceiver<T>(){

                    public void output(T output) {
                        OnWindowExpirationContext.this.context.output(tag, output);
                    }

                    public void outputWithTimestamp(T output, Instant timestamp) {
                        OnWindowExpirationContext.this.context.outputWithTimestamp(tag, output, timestamp);
                    }

                    public void outputWindowedValue(T output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
                        OnWindowExpirationContext.this.context.outputWindowedValue(tag, output, timestamp, windows, paneInfo);
                    }
                };
            }

            private <T> DoFn.OutputReceiver<Row> createTaggedRowReceiver(final TupleTag<T> tag) {
                if (tag == null || FnApiDoFnRunner.this.mainOutputTag.equals(tag)) {
                    Preconditions.checkState((FnApiDoFnRunner.this.mainOutputSchemaCoder != null ? 1 : 0) != 0, (Object)("Output with tag " + FnApiDoFnRunner.this.mainOutputTag + " must have a schema in order to call getRowReceiver"));
                    return OnWindowExpirationContext.this.mainRowOutputReceiver;
                }
                final Coder outputCoder = (Coder)FnApiDoFnRunner.this.outputCoders.get(tag);
                Preconditions.checkState((outputCoder != null ? 1 : 0) != 0, (Object)("No output tag for " + tag));
                Preconditions.checkState((boolean)(outputCoder instanceof SchemaCoder), (Object)("Output with tag " + tag + " must have a schema in order to call getRowReceiver"));
                return new DoFn.OutputReceiver<Row>(){
                    private SerializableFunction<Row, T> fromRowFunction;
                    {
                        this.fromRowFunction = ((SchemaCoder)outputCoder).getFromRowFunction();
                    }

                    public void output(Row output) {
                        OnWindowExpirationContext.this.context.output(tag, this.fromRowFunction.apply((Object)output));
                    }

                    public void outputWithTimestamp(Row output, Instant timestamp) {
                        OnWindowExpirationContext.this.context.outputWithTimestamp(tag, this.fromRowFunction.apply((Object)output), timestamp);
                    }

                    public void outputWindowedValue(Row output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
                        OnWindowExpirationContext.this.context.outputWindowedValue(tag, this.fromRowFunction.apply((Object)output), timestamp, windows, paneInfo);
                    }
                };
            }

            public <T> DoFn.OutputReceiver<T> get(TupleTag<T> tag) {
                return this.taggedOutputReceivers.computeIfAbsent(tag, this::createTaggedOutputReceiver);
            }

            public <T> DoFn.OutputReceiver<Row> getRowReceiver(TupleTag<T> tag) {
                return this.taggedRowReceivers.computeIfAbsent(tag, this::createTaggedRowReceiver);
            }
        };

        private OnWindowExpirationContext() {
        }

        public BoundedWindow window() {
            return FnApiDoFnRunner.this.currentWindow;
        }

        public Instant timestamp(DoFn<InputT, OutputT> doFn) {
            return FnApiDoFnRunner.this.currentTimer.getHoldTimestamp();
        }

        public TimeDomain timeDomain(DoFn<InputT, OutputT> doFn) {
            return FnApiDoFnRunner.this.currentTimeDomain;
        }

        public K key() {
            return (K)FnApiDoFnRunner.this.currentTimer.getUserKey();
        }

        public DoFn.OutputReceiver<OutputT> outputReceiver(DoFn<InputT, OutputT> doFn) {
            return this.context;
        }

        public DoFn.OutputReceiver<Row> outputRowReceiver(DoFn<InputT, OutputT> doFn) {
            Preconditions.checkState((FnApiDoFnRunner.this.mainOutputSchemaCoder != null ? 1 : 0) != 0, (Object)("Output with tag " + FnApiDoFnRunner.this.mainOutputTag + " must have a schema in order to call getRowReceiver"));
            return this.mainRowOutputReceiver;
        }

        public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn<InputT, OutputT> doFn) {
            return this.taggedOutputReceiver;
        }

        public State state(String stateId, boolean alwaysFetched) {
            StateSpec spec;
            DoFnSignature.StateDeclaration stateDeclaration = (DoFnSignature.StateDeclaration)FnApiDoFnRunner.this.doFnSignature.stateDeclarations().get(stateId);
            Preconditions.checkNotNull((Object)stateDeclaration, (String)"No state declaration found for %s", (Object)stateId);
            try {
                spec = (StateSpec)stateDeclaration.field().get(FnApiDoFnRunner.this.doFn);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            State state = spec.bind(stateId, (StateBinder)FnApiDoFnRunner.this.stateAccessor);
            if (alwaysFetched) {
                return (State)((ReadableState)state).readLater();
            }
            return state;
        }

        public PipelineOptions pipelineOptions() {
            return FnApiDoFnRunner.this.pipelineOptions;
        }

        public String getErrorContext() {
            return "FnApiDoFnRunner/OnWindowExpiration";
        }

        private class Context
        extends DoFn.OnWindowExpirationContext
        implements DoFn.OutputReceiver<OutputT> {
            private Context() {
                super(FnApiDoFnRunner.this.doFn);
            }

            public PipelineOptions getPipelineOptions() {
                return FnApiDoFnRunner.this.pipelineOptions;
            }

            public BoundedWindow window() {
                return FnApiDoFnRunner.this.currentWindow;
            }

            public void output(OutputT output) {
                FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)FnApiDoFnRunner.this.currentTimer.getHoldTimestamp(), (BoundedWindow)FnApiDoFnRunner.this.currentWindow, (PaneInfo)FnApiDoFnRunner.this.currentTimer.getPaneInfo()));
            }

            public void outputWithTimestamp(OutputT output, Instant timestamp) {
                this.checkOnWindowExpirationTimestamp(timestamp);
                FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, (BoundedWindow)FnApiDoFnRunner.this.currentWindow, (PaneInfo)FnApiDoFnRunner.this.currentTimer.getPaneInfo()));
            }

            public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
                this.checkOnWindowExpirationTimestamp(timestamp);
                FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, windows, (PaneInfo)paneInfo));
            }

            public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo, @Nullable String currentRecordId, @Nullable Long currentRecordOffset) {
                this.checkOnWindowExpirationTimestamp(timestamp);
                FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, windows, (PaneInfo)paneInfo, (String)currentRecordId, (Long)currentRecordOffset));
            }

            public <T> void output(TupleTag<T> tag, T output) {
                FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
                }
                FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)FnApiDoFnRunner.this.currentTimer.getHoldTimestamp(), (BoundedWindow)FnApiDoFnRunner.this.currentWindow, (PaneInfo)FnApiDoFnRunner.this.currentTimer.getPaneInfo()));
            }

            public <T> void outputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
                this.checkOnWindowExpirationTimestamp(timestamp);
                FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
                }
                FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)timestamp, (BoundedWindow)FnApiDoFnRunner.this.currentWindow, (PaneInfo)FnApiDoFnRunner.this.currentTimer.getPaneInfo()));
            }

            public <T> void outputWindowedValue(TupleTag<T> tag, T output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
                this.outputWindowedValue(tag, output, timestamp, windows, paneInfo, null, null);
            }

            public <T> void outputWindowedValue(TupleTag<T> tag, T output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo, @Nullable String currentRecordId, @Nullable Long currentRecordOffset) {
                this.checkOnWindowExpirationTimestamp(timestamp);
                FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
                FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)timestamp, windows, (PaneInfo)paneInfo, (String)currentRecordId, (Long)currentRecordOffset));
            }

            private void checkOnWindowExpirationTimestamp(Instant timestamp) {
                Instant lowerBound;
                try {
                    lowerBound = FnApiDoFnRunner.this.currentTimer.getHoldTimestamp().minus((ReadableDuration)FnApiDoFnRunner.this.doFn.getAllowedTimestampSkew());
                }
                catch (ArithmeticException e) {
                    lowerBound = BoundedWindow.TIMESTAMP_MIN_VALUE;
                }
                if (timestamp.isBefore((ReadableInstant)lowerBound) || timestamp.isAfter((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE)) {
                    throw new IllegalArgumentException(String.format("Cannot output with timestamp %s. Output timestamps must be no earlier than the timestamp of the timer (%s) minus the allowed skew (%s) and no later than %s. See the DoFn#getAllowedTimestampSkew() Javadoc for details on changing the allowed skew.", timestamp, FnApiDoFnRunner.this.currentTimer.getHoldTimestamp(), FnApiDoFnRunner.this.doFn.getAllowedTimestampSkew().getMillis() >= Integer.MAX_VALUE ? FnApiDoFnRunner.this.doFn.getAllowedTimestampSkew() : PeriodFormat.getDefault().print((ReadablePeriod)FnApiDoFnRunner.this.doFn.getAllowedTimestampSkew().toPeriod()), BoundedWindow.TIMESTAMP_MAX_VALUE));
                }
            }
        }
    }

    private abstract class ProcessBundleContextBase
    extends DoFn.ProcessContext
    implements DoFnInvoker.ArgumentProvider<InputT, OutputT>,
    DoFn.OutputReceiver<OutputT> {
        private final DoFn.OutputReceiver<Row> mainRowOutputReceiver;
        private final DoFn.MultiOutputReceiver taggedOutputReceiver;

        private ProcessBundleContextBase() {
            super(FnApiDoFnRunner.this.doFn);
            this.mainRowOutputReceiver = FnApiDoFnRunner.this.mainOutputSchemaCoder == null ? null : new DoFn.OutputReceiver<Row>(){
                private final SerializableFunction<Row, OutputT> fromRowFunction;
                {
                    this.fromRowFunction = FnApiDoFnRunner.this.mainOutputSchemaCoder.getFromRowFunction();
                }

                public void output(Row output) {
                    ProcessBundleContextBase.this.output(this.fromRowFunction.apply((Object)output));
                }

                public void outputWithTimestamp(Row output, Instant timestamp) {
                    ProcessBundleContextBase.this.outputWithTimestamp(this.fromRowFunction.apply((Object)output), timestamp);
                }

                public void outputWindowedValue(Row output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
                    ProcessBundleContextBase.this.outputWindowedValue(this.fromRowFunction.apply((Object)output), timestamp, windows, paneInfo);
                }
            };
            this.taggedOutputReceiver = new DoFn.MultiOutputReceiver(){
                private final Map<TupleTag<?>, DoFn.OutputReceiver<?>> taggedOutputReceivers = new HashMap();
                private final Map<TupleTag<?>, DoFn.OutputReceiver<Row>> taggedRowReceivers = new HashMap();

                private <T> DoFn.OutputReceiver<T> createTaggedOutputReceiver(final TupleTag<T> tag) {
                    if (tag == null || FnApiDoFnRunner.this.mainOutputTag.equals(tag)) {
                        return ProcessBundleContextBase.this;
                    }
                    return new DoFn.OutputReceiver<T>(){

                        public void output(T output) {
                            ProcessBundleContextBase.this.output(tag, output);
                        }

                        public void outputWithTimestamp(T output, Instant timestamp) {
                            ProcessBundleContextBase.this.outputWithTimestamp(tag, output, timestamp);
                        }

                        public void outputWindowedValue(T output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
                            ProcessBundleContextBase.this.outputWindowedValue(tag, output, timestamp, windows, paneInfo);
                        }
                    };
                }

                private <T> DoFn.OutputReceiver<Row> createTaggedRowReceiver(final TupleTag<T> tag) {
                    if (tag == null || FnApiDoFnRunner.this.mainOutputTag.equals(tag)) {
                        Preconditions.checkState((FnApiDoFnRunner.this.mainOutputSchemaCoder != null ? 1 : 0) != 0, (Object)("Output with tag " + FnApiDoFnRunner.this.mainOutputTag + " must have a schema in order to call getRowReceiver"));
                        return ProcessBundleContextBase.this.mainRowOutputReceiver;
                    }
                    final Coder outputCoder = (Coder)FnApiDoFnRunner.this.outputCoders.get(tag);
                    Preconditions.checkState((outputCoder != null ? 1 : 0) != 0, (Object)("No output tag for " + tag));
                    Preconditions.checkState((boolean)(outputCoder instanceof SchemaCoder), (Object)("Output with tag " + tag + " must have a schema in order to call getRowReceiver"));
                    return new DoFn.OutputReceiver<Row>(){
                        private SerializableFunction<Row, T> fromRowFunction;
                        {
                            this.fromRowFunction = ((SchemaCoder)outputCoder).getFromRowFunction();
                        }

                        public void output(Row output) {
                            ProcessBundleContextBase.this.output(tag, this.fromRowFunction.apply((Object)output));
                        }

                        public void outputWithTimestamp(Row output, Instant timestamp) {
                            ProcessBundleContextBase.this.outputWithTimestamp(tag, this.fromRowFunction.apply((Object)output), timestamp);
                        }

                        public void outputWindowedValue(Row output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
                            ProcessBundleContextBase.this.outputWindowedValue(tag, this.fromRowFunction.apply((Object)output), timestamp, windows, paneInfo);
                        }
                    };
                }

                public <T> DoFn.OutputReceiver<T> get(TupleTag<T> tag) {
                    return this.taggedOutputReceivers.computeIfAbsent(tag, this::createTaggedOutputReceiver);
                }

                public <T> DoFn.OutputReceiver<Row> getRowReceiver(TupleTag<T> tag) {
                    return this.taggedRowReceivers.computeIfAbsent(tag, this::createTaggedRowReceiver);
                }
            };
        }

        public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
            return this.pane();
        }

        public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Cannot access StartBundleContext outside of @StartBundle method.");
        }

        public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Cannot access FinishBundleContext outside of @FinishBundle method.");
        }

        public DoFn.ProcessContext processContext(DoFn<InputT, OutputT> doFn) {
            return this;
        }

        public InputT element(DoFn<InputT, OutputT> doFn) {
            return this.element();
        }

        public Object key() {
            throw new UnsupportedOperationException("Cannot access key as parameter outside of @OnTimer method.");
        }

        public Object schemaElement(int index) {
            SerializableFunction converter = (SerializableFunction)FnApiDoFnRunner.this.doFnSchemaInformation.getElementConverters().get(index);
            return converter.apply(this.element());
        }

        public Instant timestamp(DoFn<InputT, OutputT> doFn) {
            return this.timestamp();
        }

        public String timerId(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Cannot access timerId as parameter outside of @OnTimer method.");
        }

        public TimeDomain timeDomain(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Cannot access time domain outside of @ProcessTimer method.");
        }

        public DoFn.OutputReceiver<OutputT> outputReceiver(DoFn<InputT, OutputT> doFn) {
            return this;
        }

        public DoFn.OutputReceiver<Row> outputRowReceiver(DoFn<InputT, OutputT> doFn) {
            Preconditions.checkState((FnApiDoFnRunner.this.mainOutputSchemaCoder != null ? 1 : 0) != 0, (Object)("Output with tag " + FnApiDoFnRunner.this.mainOutputTag + " must have a schema in order to call getRowReceiver"));
            return this.mainRowOutputReceiver;
        }

        public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn<InputT, OutputT> doFn) {
            return this.taggedOutputReceiver;
        }

        public DoFn.BundleFinalizer bundleFinalizer() {
            return FnApiDoFnRunner.this.bundleFinalizer;
        }

        public Object restriction() {
            return FnApiDoFnRunner.this.currentRestriction;
        }

        public DoFn.OnTimerContext onTimerContext(DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException("Cannot access OnTimerContext outside of @OnTimer methods.");
        }

        public RestrictionTracker<?, ?> restrictionTracker() {
            return FnApiDoFnRunner.this.currentTracker;
        }

        public PipelineOptions getPipelineOptions() {
            return FnApiDoFnRunner.this.pipelineOptions;
        }

        public PipelineOptions pipelineOptions() {
            return FnApiDoFnRunner.this.pipelineOptions;
        }

        public InputT element() {
            return FnApiDoFnRunner.this.currentElement.getValue();
        }

        public Instant timestamp() {
            return FnApiDoFnRunner.this.currentElement.getTimestamp();
        }

        public String currentRecordId() {
            return FnApiDoFnRunner.this.currentElement.getCurrentRecordId();
        }

        public Long currentRecordOffset() {
            return FnApiDoFnRunner.this.currentElement.getCurrentRecordOffset();
        }

        public PaneInfo pane() {
            return FnApiDoFnRunner.this.currentElement.getPaneInfo();
        }

        public Object watermarkEstimatorState() {
            return FnApiDoFnRunner.this.currentWatermarkEstimatorState;
        }

        public WatermarkEstimator<?> watermarkEstimator() {
            return FnApiDoFnRunner.this.currentWatermarkEstimator;
        }
    }

    private abstract class NonWindowObservingProcessBundleContextBase
    extends ProcessBundleContextBase {
        private NonWindowObservingProcessBundleContextBase() {
        }

        public BoundedWindow window() {
            throw new UnsupportedOperationException("Cannot access window in non-window observing context.");
        }

        public Object sideInput(String tagId) {
            throw new UnsupportedOperationException("Cannot access sideInput in non-window observing context.");
        }

        public <T> T sideInput(PCollectionView<T> view) {
            throw new UnsupportedOperationException("Cannot access sideInput in non-window observing context.");
        }

        public State state(String stateId, boolean alwaysFetched) {
            throw new UnsupportedOperationException("Cannot access state in non-window observing context.");
        }

        public org.apache.beam.sdk.state.Timer timer(String timerId) {
            throw new UnsupportedOperationException("Cannot access timer in non-window observing context.");
        }

        public TimerMap timerFamily(String timerFamilyId) {
            throw new UnsupportedOperationException("Cannot access timerFamily in non-window observing context.");
        }
    }

    private class NonWindowObservingProcessBundleContext
    extends NonWindowObservingProcessBundleContextBase {
        private NonWindowObservingProcessBundleContext() {
        }

        public void output(OutputT output) {
            if (FnApiDoFnRunner.this.currentElement == null) {
                throw new IllegalStateException("Attempting to emit an element outside of a @ProcessElement context.");
            }
            FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, FnApiDoFnRunner.this.currentElement.withValue(output));
        }

        public <T> void output(TupleTag<T> tag, T output) {
            FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
            }
            FnApiDoFnRunner.this.outputTo(consumer, FnApiDoFnRunner.this.currentElement.withValue(output));
        }

        public void outputWithTimestamp(OutputT output, Instant timestamp) {
            FnApiDoFnRunner.this.checkTimestamp(timestamp);
            FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, (Collection)FnApiDoFnRunner.this.currentElement.getWindows(), (PaneInfo)FnApiDoFnRunner.this.currentElement.getPaneInfo()));
        }

        public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
            FnApiDoFnRunner.this.checkTimestamp(timestamp);
            FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, windows, (PaneInfo)paneInfo));
        }

        public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo, @Nullable String currentRecordId, @Nullable Long currentRecordOffset) {
            FnApiDoFnRunner.this.checkTimestamp(timestamp);
            FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, windows, (PaneInfo)paneInfo, (String)currentRecordId, (Long)currentRecordOffset));
        }

        public <T> void outputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
            FnApiDoFnRunner.this.checkTimestamp(timestamp);
            FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
            }
            FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)timestamp, (Collection)FnApiDoFnRunner.this.currentElement.getWindows(), (PaneInfo)FnApiDoFnRunner.this.currentElement.getPaneInfo()));
        }

        public <T> void outputWindowedValue(TupleTag<T> tag, T output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
            FnApiDoFnRunner.this.checkTimestamp(timestamp);
            FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
            }
            FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)timestamp, windows, (PaneInfo)paneInfo));
        }

        public <T> void outputWindowedValue(TupleTag<T> tag, T output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo, @Nullable String currentRecordId, @Nullable Long currentRecordOffset) {
            FnApiDoFnRunner.this.checkTimestamp(timestamp);
            FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
            }
            FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)timestamp, windows, (PaneInfo)paneInfo, (String)currentRecordId, (Long)currentRecordOffset));
        }
    }

    private class WindowObservingProcessBundleContext
    extends WindowObservingProcessBundleContextBase {
        private WindowObservingProcessBundleContext() {
        }

        public void output(OutputT output) {
            FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)FnApiDoFnRunner.this.currentElement.getTimestamp(), (BoundedWindow)FnApiDoFnRunner.this.currentWindow, (PaneInfo)FnApiDoFnRunner.this.currentElement.getPaneInfo()));
        }

        public <T> void output(TupleTag<T> tag, T output) {
            FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
            }
            FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)FnApiDoFnRunner.this.currentElement.getTimestamp(), (BoundedWindow)FnApiDoFnRunner.this.currentWindow, (PaneInfo)FnApiDoFnRunner.this.currentElement.getPaneInfo()));
        }

        public void outputWithTimestamp(OutputT output, Instant timestamp) {
            FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, (BoundedWindow)FnApiDoFnRunner.this.currentWindow, (PaneInfo)FnApiDoFnRunner.this.currentElement.getPaneInfo()));
        }

        public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
            FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, windows, (PaneInfo)paneInfo));
        }

        public void outputWindowedValue(OutputT output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo, @Nullable String currentRecordId, @Nullable Long currentRecordOffset) {
            FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, windows, (PaneInfo)paneInfo, (String)currentRecordId, (Long)currentRecordOffset));
        }

        public <T> void outputWithTimestamp(TupleTag<T> tag, T output, Instant timestamp) {
            FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
            }
            FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)timestamp, (BoundedWindow)FnApiDoFnRunner.this.currentWindow, (PaneInfo)FnApiDoFnRunner.this.currentElement.getPaneInfo()));
        }

        public <T> void outputWindowedValue(TupleTag<T> tag, T output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo) {
            FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
            }
            FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)timestamp, windows, (PaneInfo)paneInfo));
        }

        public <T> void outputWindowedValue(TupleTag<T> tag, T output, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo paneInfo, @Nullable String currentRecordId, @Nullable Long currentRecordOffset) {
            FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
            }
            FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)timestamp, windows, (PaneInfo)paneInfo, (String)currentRecordId, (Long)currentRecordOffset));
        }

        public State state(String stateId, boolean alwaysFetched) {
            StateSpec spec;
            DoFnSignature.StateDeclaration stateDeclaration = (DoFnSignature.StateDeclaration)FnApiDoFnRunner.this.doFnSignature.stateDeclarations().get(stateId);
            Preconditions.checkNotNull((Object)stateDeclaration, (String)"No state declaration found for %s", (Object)stateId);
            try {
                spec = (StateSpec)stateDeclaration.field().get(FnApiDoFnRunner.this.doFn);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            State state = spec.bind(stateId, (StateBinder)FnApiDoFnRunner.this.stateAccessor);
            if (alwaysFetched) {
                return (State)((ReadableState)state).readLater();
            }
            return state;
        }

        public org.apache.beam.sdk.state.Timer timer(String timerId) {
            Preconditions.checkState((boolean)(FnApiDoFnRunner.this.currentElement.getValue() instanceof KV), (String)"Accessing timer in unkeyed context. Current element is not a KV: %s.", (Object)FnApiDoFnRunner.this.currentElement.getValue());
            TimeDomain timeDomain = FnApiDoFnRunner.this.translateTimeDomain(((RunnerApi.TimerFamilySpec)FnApiDoFnRunner.this.parDoPayload.getTimerFamilySpecsMap().get(timerId)).getTimeDomain());
            return new FnApiTimer<Object>(timerId, ((KV)FnApiDoFnRunner.this.currentElement.getValue()).getKey(), "", FnApiDoFnRunner.this.currentWindow, FnApiDoFnRunner.this.currentElement.getTimestamp(), FnApiDoFnRunner.this.currentElement.getTimestamp(), FnApiDoFnRunner.this.currentElement.getPaneInfo(), timeDomain);
        }

        public TimerMap timerFamily(String timerFamilyId) {
            return new FnApiTimerMap<Object>(timerFamilyId, ((KV)FnApiDoFnRunner.this.currentElement.getValue()).getKey(), FnApiDoFnRunner.this.currentWindow, FnApiDoFnRunner.this.currentElement.getTimestamp(), FnApiDoFnRunner.this.currentElement.getTimestamp(), FnApiDoFnRunner.this.currentElement.getPaneInfo());
        }
    }

    private abstract class WindowObservingProcessBundleContextBase
    extends ProcessBundleContextBase {
        private WindowObservingProcessBundleContextBase() {
        }

        public BoundedWindow window() {
            return FnApiDoFnRunner.this.currentWindow;
        }

        public Object sideInput(String tagId) {
            return this.sideInput((PCollectionView)FnApiDoFnRunner.this.sideInputMapping.get(tagId));
        }

        public <T> T sideInput(PCollectionView<T> view) {
            return FnApiDoFnRunner.this.stateAccessor.get(view, FnApiDoFnRunner.this.currentWindow);
        }
    }

    private class FinishBundleArgumentProvider
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT> {
        private final org.apache.beam.fn.harness.FnApiDoFnRunner$FinishBundleArgumentProvider.Context context = new Context();

        private FinishBundleArgumentProvider() {
        }

        public DoFn.FinishBundleContext finishBundleContext(DoFn<InputT, OutputT> doFn) {
            return this.context;
        }

        public PipelineOptions pipelineOptions() {
            return FnApiDoFnRunner.this.pipelineOptions;
        }

        public DoFn.BundleFinalizer bundleFinalizer() {
            return FnApiDoFnRunner.this.bundleFinalizer;
        }

        public String getErrorContext() {
            return "FnApiDoFnRunner/FinishBundle";
        }

        private class Context
        extends DoFn.FinishBundleContext {
            Context() {
                super(FnApiDoFnRunner.this.doFn);
            }

            public PipelineOptions getPipelineOptions() {
                return FnApiDoFnRunner.this.pipelineOptions;
            }

            public void output(OutputT output, Instant timestamp, BoundedWindow window) {
                FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, (BoundedWindow)window, (PaneInfo)PaneInfo.NO_FIRING));
            }

            public <T> void output(TupleTag<T> tag, T output, Instant timestamp, BoundedWindow window) {
                FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
                }
                FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)timestamp, (BoundedWindow)window, (PaneInfo)PaneInfo.NO_FIRING));
            }

            public void output(OutputT output, Instant timestamp, BoundedWindow window, @Nullable String currentRecordId, @Nullable Long currentRecordOffset) {
                FnApiDoFnRunner.this.outputTo(FnApiDoFnRunner.this.mainOutputConsumer, WindowedValues.of(output, (Instant)timestamp, Collections.singletonList(window), (PaneInfo)PaneInfo.NO_FIRING, (String)currentRecordId, (Long)currentRecordOffset));
            }

            public <T> void output(TupleTag<T> tag, T output, Instant timestamp, BoundedWindow window, @Nullable String currentRecordId, @Nullable Long currentRecordOffset) {
                FnDataReceiver consumer = (FnDataReceiver)FnApiDoFnRunner.this.localNameToConsumer.get(tag.getId());
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Unknown output tag %s", tag));
                }
                FnApiDoFnRunner.this.outputTo(consumer, WindowedValues.of(output, (Instant)timestamp, Collections.singletonList(window), (PaneInfo)PaneInfo.NO_FIRING, (String)currentRecordId, (Long)currentRecordOffset));
            }
        }
    }

    private class StartBundleArgumentProvider
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT> {
        private final org.apache.beam.fn.harness.FnApiDoFnRunner$StartBundleArgumentProvider.Context context = new Context();

        private StartBundleArgumentProvider() {
        }

        public DoFn.StartBundleContext startBundleContext(DoFn<InputT, OutputT> doFn) {
            return this.context;
        }

        public PipelineOptions pipelineOptions() {
            return FnApiDoFnRunner.this.pipelineOptions;
        }

        public DoFn.BundleFinalizer bundleFinalizer() {
            return FnApiDoFnRunner.this.bundleFinalizer;
        }

        public String getErrorContext() {
            return "FnApiDoFnRunner/StartBundle";
        }

        private class Context
        extends DoFn.StartBundleContext {
            Context() {
                super(FnApiDoFnRunner.this.doFn);
            }

            public PipelineOptions getPipelineOptions() {
                return FnApiDoFnRunner.this.pipelineOptions;
            }
        }
    }

    private class FnApiTimerMap<K>
    implements TimerMap {
        private final String timerFamilyId;
        private final K userKey;
        private final TimeDomain timeDomain;
        private final Instant elementTimestampOrTimerHoldTimestamp;
        private final Instant elementTimestampOrTimerFireTimestamp;
        private final BoundedWindow boundedWindow;
        private final PaneInfo paneInfo;

        FnApiTimerMap(String timerFamilyId, K userKey, BoundedWindow boundedWindow, Instant elementTimestampOrTimerHoldTimestamp, Instant elementTimestampOrTimerFireTimestamp, PaneInfo paneInfo) {
            this.timerFamilyId = timerFamilyId;
            this.userKey = userKey;
            this.elementTimestampOrTimerHoldTimestamp = elementTimestampOrTimerHoldTimestamp;
            this.elementTimestampOrTimerFireTimestamp = elementTimestampOrTimerFireTimestamp;
            this.boundedWindow = boundedWindow;
            this.paneInfo = paneInfo;
            this.timeDomain = FnApiDoFnRunner.this.translateTimeDomain(((RunnerApi.TimerFamilySpec)FnApiDoFnRunner.this.parDoPayload.getTimerFamilySpecsMap().get(timerFamilyId)).getTimeDomain());
        }

        public void set(String dynamicTimerTag, Instant absoluteTime) {
            this.get(dynamicTimerTag).set(absoluteTime);
        }

        public org.apache.beam.sdk.state.Timer get(String dynamicTimerTag) {
            return new FnApiTimer<K>(this.timerFamilyId, this.userKey, dynamicTimerTag, this.boundedWindow, this.elementTimestampOrTimerHoldTimestamp, this.elementTimestampOrTimerFireTimestamp, this.paneInfo, this.timeDomain);
        }
    }

    private class FnApiTimer<K>
    implements org.apache.beam.sdk.state.Timer {
        private final String timerIdOrFamily;
        private final K userKey;
        private final String dynamicTimerTag;
        private final TimeDomain timeDomain;
        private final Instant fireTimestamp;
        private final Instant elementTimestampOrTimerHoldTimestamp;
        private final BoundedWindow boundedWindow;
        private final PaneInfo paneInfo;
        private @Nullable Instant outputTimestamp;
        private boolean noOutputTimestamp;
        private Duration period = Duration.ZERO;
        private Duration offset = Duration.ZERO;

        FnApiTimer(String timerIdOrFamily, K userKey, String dynamicTimerTag, BoundedWindow boundedWindow, Instant elementTimestampOrTimerHoldTimestamp, Instant elementTimestampOrTimerFireTimestamp, PaneInfo paneInfo, TimeDomain timeDomain) {
            this.timerIdOrFamily = timerIdOrFamily;
            this.userKey = userKey;
            this.dynamicTimerTag = dynamicTimerTag;
            this.elementTimestampOrTimerHoldTimestamp = elementTimestampOrTimerHoldTimestamp;
            this.boundedWindow = boundedWindow;
            this.paneInfo = paneInfo;
            this.noOutputTimestamp = false;
            this.timeDomain = timeDomain;
            switch (timeDomain) {
                case EVENT_TIME: {
                    this.fireTimestamp = elementTimestampOrTimerFireTimestamp;
                    break;
                }
                case PROCESSING_TIME: {
                    this.fireTimestamp = new Instant(DateTimeUtils.currentTimeMillis());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown or unsupported time domain %s", timeDomain));
                }
            }
        }

        public void set(Instant absoluteTime) {
            Preconditions.checkNotNull((Object)FnApiDoFnRunner.this.timerBundleTracker);
            if (TimeDomain.EVENT_TIME.equals((Object)this.timeDomain)) {
                Instant windowExpiry = LateDataUtils.garbageCollectionTime(FnApiDoFnRunner.this.currentWindow, FnApiDoFnRunner.this.allowedLateness);
                Preconditions.checkArgument((!absoluteTime.isAfter((ReadableInstant)windowExpiry) ? 1 : 0) != 0, (String)"Attempted to set event time timer for %s but that is after the expiration of window %s", (Object)absoluteTime, (Object)windowExpiry);
            }
            FnApiDoFnRunner.this.timerBundleTracker.timerModified(this.timerIdOrFamily, this.timeDomain, this.getTimerForTime(absoluteTime));
        }

        public void setRelative() {
            long millisSinceStart;
            Preconditions.checkNotNull((Object)FnApiDoFnRunner.this.timerBundleTracker);
            Instant target = this.period.equals((Object)Duration.ZERO) ? this.fireTimestamp.plus((ReadableDuration)this.offset) : ((millisSinceStart = this.fireTimestamp.plus((ReadableDuration)this.offset).getMillis() % this.period.getMillis()) == 0L ? this.fireTimestamp : this.fireTimestamp.plus((ReadableDuration)this.period).minus((ReadableDuration)Duration.millis((long)millisSinceStart)));
            target = this.minTargetAndGcTime(target);
            FnApiDoFnRunner.this.timerBundleTracker.timerModified(this.timerIdOrFamily, this.timeDomain, this.getTimerForTime(target));
        }

        public void clear() {
            Preconditions.checkNotNull((Object)FnApiDoFnRunner.this.timerBundleTracker);
            FnApiDoFnRunner.this.timerBundleTracker.timerModified(this.timerIdOrFamily, this.timeDomain, this.getClearedTimer());
        }

        public org.apache.beam.sdk.state.Timer offset(Duration offset) {
            this.offset = offset;
            return this;
        }

        public org.apache.beam.sdk.state.Timer align(Duration period) {
            this.period = period;
            return this;
        }

        public org.apache.beam.sdk.state.Timer withOutputTimestamp(Instant outputTime) {
            this.outputTimestamp = outputTime;
            this.noOutputTimestamp = false;
            return this;
        }

        public org.apache.beam.sdk.state.Timer withNoOutputTimestamp() {
            this.outputTimestamp = null;
            this.noOutputTimestamp = true;
            return this;
        }

        public Instant getCurrentRelativeTime() {
            return this.fireTimestamp;
        }

        private Instant minTargetAndGcTime(Instant target) {
            Instant windowExpiry;
            if (TimeDomain.EVENT_TIME.equals((Object)this.timeDomain) && target.isAfter((ReadableInstant)(windowExpiry = LateDataUtils.garbageCollectionTime(FnApiDoFnRunner.this.currentWindow, FnApiDoFnRunner.this.allowedLateness)))) {
                return windowExpiry;
            }
            return target;
        }

        private Timer<K> getClearedTimer() {
            return Timer.cleared(this.userKey, (String)this.dynamicTimerTag, Collections.singletonList(this.boundedWindow));
        }

        private Timer<K> getTimerForTime(Instant scheduledTime) {
            if (this.outputTimestamp != null) {
                Instant lowerBound;
                try {
                    lowerBound = this.elementTimestampOrTimerHoldTimestamp.minus((ReadableDuration)FnApiDoFnRunner.this.doFn.getAllowedTimestampSkew());
                }
                catch (ArithmeticException e) {
                    lowerBound = BoundedWindow.TIMESTAMP_MIN_VALUE;
                }
                if (this.outputTimestamp.isBefore((ReadableInstant)lowerBound) || this.outputTimestamp.isAfter((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE)) {
                    throw new IllegalArgumentException(String.format("Cannot output timer with output timestamp %s. Output timestamps must be no earlier than the timestamp of the current input (%s) minus the allowed skew (%s) and no later than %s. See the DoFn#getAllowedTimestampSkew() Javadoc for details on changing the allowed skew.", this.outputTimestamp, this.elementTimestampOrTimerHoldTimestamp, FnApiDoFnRunner.this.doFn.getAllowedTimestampSkew().getMillis() >= Integer.MAX_VALUE ? FnApiDoFnRunner.this.doFn.getAllowedTimestampSkew() : PeriodFormat.getDefault().print((ReadablePeriod)FnApiDoFnRunner.this.doFn.getAllowedTimestampSkew().toPeriod()), BoundedWindow.TIMESTAMP_MAX_VALUE));
                }
            }
            if (!this.noOutputTimestamp && this.outputTimestamp == null && TimeDomain.EVENT_TIME.equals((Object)this.timeDomain)) {
                this.outputTimestamp = scheduledTime;
            }
            if (!this.noOutputTimestamp && this.outputTimestamp == null) {
                this.outputTimestamp = this.elementTimestampOrTimerHoldTimestamp;
            }
            if (this.outputTimestamp != null) {
                Instant windowExpiry = LateDataUtils.garbageCollectionTime(FnApiDoFnRunner.this.currentWindow, FnApiDoFnRunner.this.allowedLateness);
                if (TimeDomain.EVENT_TIME.equals((Object)this.timeDomain)) {
                    Preconditions.checkArgument((!this.outputTimestamp.isAfter((ReadableInstant)scheduledTime) ? 1 : 0) != 0, (String)"Attempted to set an event-time timer with an output timestamp of %s that is after the timer firing timestamp %s", (Object)this.outputTimestamp, (Object)scheduledTime);
                    Preconditions.checkArgument((!scheduledTime.isAfter((ReadableInstant)windowExpiry) ? 1 : 0) != 0, (String)"Attempted to set an event-time timer with a firing timestamp of %s that is after the expiration of window %s", (Object)scheduledTime, (Object)windowExpiry);
                } else {
                    Preconditions.checkArgument((!this.outputTimestamp.isAfter((ReadableInstant)windowExpiry) ? 1 : 0) != 0, (String)"Attempted to set a processing-time timer with an output timestamp of %s that is after the expiration of window %s", (Object)this.outputTimestamp, (Object)windowExpiry);
                }
            } else {
                this.outputTimestamp = BoundedWindow.TIMESTAMP_MAX_VALUE.plus((ReadableDuration)Duration.millis((long)1L));
            }
            return Timer.of(this.userKey, (String)this.dynamicTimerTag, Collections.singletonList(this.boundedWindow), (Instant)scheduledTime, (Instant)this.outputTimestamp, (PaneInfo)this.paneInfo);
        }
    }

    private abstract class SplittableFnDataReceiver
    implements HandlesSplits,
    FnDataReceiver<WindowedValue> {
        private SplittableFnDataReceiver() {
        }

        @Override
        public HandlesSplits.SplitResult trySplit(double fractionOfRemainder) {
            return FnApiDoFnRunner.this.trySplitForElementAndRestriction(fractionOfRemainder, Duration.ZERO, true);
        }

        @Override
        public double getProgress() {
            double totalWork;
            RestrictionTracker.Progress progress = FnApiDoFnRunner.this.getProgress();
            if (progress != null && (totalWork = progress.getWorkCompleted() + progress.getWorkRemaining()) > 0.0) {
                return progress.getWorkCompleted() / totalWork;
            }
            return 0.0;
        }
    }

    static class Factory<InputT, RestrictionT, PositionT, WatermarkEstimatorStateT, OutputT>
    implements PTransformRunnerFactory {
        Factory() {
        }

        @Override
        public final void addRunnerForPTransform(PTransformRunnerFactory.Context context) throws IOException {
            FnApiStateAccessor<Object> stateAccessor = FnApiStateAccessor.Factory.factoryForPTransformContext(context).create();
            FnApiDoFnRunner runner = new FnApiDoFnRunner(context.getPipelineOptions(), context.getShortIdMap(), context.getPTransformId(), context.getPTransform(), context.getComponents(), context::addStartBundleFunction, context::addFinishBundleFunction, context::addResetFunction, context::addTearDownFunction, context::getPCollectionConsumer, context::addPCollectionConsumer, context::addOutgoingTimersEndpoint, context::addBundleProgressReporter, context.getSplitListener(), context.getBundleFinalizer(), stateAccessor);
            stateAccessor.setKeyAndWindowContext(runner);
            for (Map.Entry entry : runner.timerFamilyInfos.entrySet()) {
                String localName = (String)entry.getKey();
                TimeDomain timeDomain = (TimeDomain)((KV)entry.getValue()).getKey();
                Coder coder = (Coder)((KV)entry.getValue()).getValue();
                if (!localName.equals("") && localName.equals(runner.parDoPayload.getOnWindowExpirationTimerFamilySpec())) {
                    context.addIncomingTimerEndpoint(localName, coder, x$0 -> runner.processOnWindowExpiration(x$0));
                    continue;
                }
                context.addIncomingTimerEndpoint(localName, coder, timer -> runner.processTimer(localName, timeDomain, timer));
            }
        }
    }

    @AutoService(value={PTransformRunnerFactory.Registrar.class})
    public static class Registrar
    implements PTransformRunnerFactory.Registrar {
        @Override
        public Map<String, PTransformRunnerFactory> getPTransformRunnerFactories() {
            Factory factory = new Factory();
            return ImmutableMap.builder().put((Object)"beam:transform:pardo:v1", factory).put((Object)"beam:transform:sdf_process_sized_element_and_restrictions:v1", factory).build();
        }
    }
}

