/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.collection;

import java.util.Collection;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironment;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlSingleElementExpression
extends BeamSqlExpression {
    public BeamSqlSingleElementExpression(List<BeamSqlExpression> operands, SqlTypeName sqlTypeName) {
        super(operands, sqlTypeName);
    }

    @Override
    public boolean accept() {
        return this.operands.size() == 1;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, BeamSqlExpressionEnvironment env) {
        Collection collection = (Collection)this.opValueEvaluated(0, inputRow, window, env);
        if (collection.size() <= 1) {
            return collection.isEmpty() ? BeamSqlPrimitive.of(this.outputType, null) : BeamSqlPrimitive.of(this.outputType, collection.iterator().next());
        }
        throw new IllegalArgumentException("ELEMENT expression accepts either empty collections or collections with a single element. Received collection with " + collection.size() + " elements");
    }
}

