/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.MoreObjects;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironment;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlExpressionEnvironments {
    public static BeamSqlExpressionEnvironment empty() {
        return new EmptyEnvironment();
    }

    public static BeamSqlExpressionEnvironment forRow(Row row, BoundedWindow window) {
        return new ListEnvironment(row, window, new ArrayList<Row>(), new ArrayList<BeamSqlExpression>());
    }

    public static BeamSqlExpressionEnvironment forRowAndCorrelVariables(Row row, BoundedWindow window, List<Row> correlVariables) {
        return new ListEnvironment(row, window, correlVariables, new ArrayList<BeamSqlExpression>());
    }

    private static class EmptyEnvironment
    implements BeamSqlExpressionEnvironment {
        private EmptyEnvironment() {
        }

        @Override
        public BeamSqlPrimitive<?> getLocalRef(int localRefIndex) {
            throw new UnsupportedOperationException(String.format("%s does not support local references", this.getClass().getSimpleName()));
        }

        @Override
        public Row getCorrelVariable(int correlVariableId) {
            throw new UnsupportedOperationException(String.format("%s does not support correlation variables", this.getClass().getSimpleName()));
        }

        @Override
        public BeamSqlExpressionEnvironment copyWithLocalRefExprs(List<BeamSqlExpression> localRefExprs) {
            throw new UnsupportedOperationException(String.format("%s does not support local references", this.getClass().getSimpleName()));
        }
    }

    private static class ListEnvironment
    implements BeamSqlExpressionEnvironment {
        private final Row inputRow;
        private final BoundedWindow window;
        private final List<BeamSqlExpression> localRefExprs;
        private final List<Row> correlVariables;

        public ListEnvironment(Row inputRow, BoundedWindow window, List<Row> correlVariables, List<BeamSqlExpression> localRefExprs) {
            this.inputRow = inputRow;
            this.window = window;
            this.correlVariables = correlVariables;
            this.localRefExprs = new ArrayList<BeamSqlExpression>(localRefExprs);
        }

        @Override
        public BeamSqlPrimitive<?> getLocalRef(int localRefIndex) {
            Preconditions.checkArgument(localRefIndex < this.localRefExprs.size(), "Local ref %s not found in %s", localRefIndex, (Object)this);
            BeamSqlExpression expr = this.localRefExprs.get(localRefIndex);
            BeamSqlPrimitive value = expr.evaluate(this.inputRow, this.window, this);
            if (!(expr instanceof BeamSqlPrimitive)) {
                this.localRefExprs.set(localRefIndex, value);
            }
            return value;
        }

        @Override
        public Row getCorrelVariable(int correlVariableId) {
            Preconditions.checkArgument(correlVariableId < this.correlVariables.size(), "Correlation variable %s not found in %s", correlVariableId, (Object)this);
            return this.correlVariables.get(correlVariableId);
        }

        @Override
        public BeamSqlExpressionEnvironment copyWithLocalRefExprs(List<BeamSqlExpression> localRefExprs) {
            return new ListEnvironment(this.inputRow, this.window, this.correlVariables, localRefExprs);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("inputRow", this.inputRow).add("window", this.window).add("correlVariables", this.correlVariables).add("localRefExprs", this.localRefExprs).toString();
        }
    }
}

