/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.Function;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.FunctionParameter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.ReflectUtil;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;

public abstract class UdfImplReflectiveFunctionBase
implements Function {
    public final Method method;
    public final List<FunctionParameter> parameters;

    public UdfImplReflectiveFunctionBase(Method method) {
        this.method = method;
        this.parameters = UdfImplReflectiveFunctionBase.builder().addMethodParameters(method).build();
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }

    static boolean classHasPublicZeroArgsConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }

    static Method findMethod(Class<?> clazz, String name) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name) || method.isBridge()) continue;
            return method;
        }
        return null;
    }

    public static ParameterListBuilder builder() {
        return new ParameterListBuilder();
    }

    public static class ParameterListBuilder {
        final List<FunctionParameter> builder = new ArrayList<FunctionParameter>();

        public ImmutableList<FunctionParameter> build() {
            return ImmutableList.copyOf(this.builder);
        }

        public ParameterListBuilder add(Class<?> type, String name) {
            return this.add(type, name, false);
        }

        public ParameterListBuilder add(final Class<?> type, final String name, final boolean optional) {
            final int ordinal = this.builder.size();
            this.builder.add(new FunctionParameter(){

                @Override
                public int getOrdinal() {
                    return ordinal;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public RelDataType getType(RelDataTypeFactory typeFactory) {
                    return CalciteUtils.sqlTypeWithAutoCast(typeFactory, type);
                }

                @Override
                public boolean isOptional() {
                    return optional;
                }
            });
            return this;
        }

        public ParameterListBuilder addMethodParameters(Method method) {
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                this.add(types[i], ReflectUtil.getParameterName(method, i), ReflectUtil.isParameterOptional(method, i));
            }
            return this;
        }
    }
}

