/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.mapping;

import java.util.AbstractList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.Utilities;

public class IntPair {
    public final int source;
    public final int target;

    public IntPair(int source, int target) {
        this.source = source;
        this.target = target;
    }

    public static IntPair of(int left, int right) {
        return new IntPair(left, right);
    }

    public String toString() {
        return this.source + "-" + this.target;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntPair) {
            IntPair that = (IntPair)obj;
            return this.source == that.source && this.target == that.target;
        }
        return false;
    }

    public int hashCode() {
        return Utilities.hash(this.source, this.target);
    }

    public static List<IntPair> zip(List<? extends Number> lefts, List<? extends Number> rights) {
        return IntPair.zip(lefts, rights, false);
    }

    public static List<IntPair> zip(final List<? extends Number> lefts, final List<? extends Number> rights, boolean strict) {
        int size;
        if (strict) {
            if (lefts.size() != rights.size()) {
                throw new AssertionError();
            }
            size = lefts.size();
        } else {
            size = Math.min(lefts.size(), rights.size());
        }
        return new AbstractList<IntPair>(){

            @Override
            public IntPair get(int index) {
                return IntPair.of(((Number)lefts.get(index)).intValue(), ((Number)rights.get(index)).intValue());
            }

            @Override
            public int size() {
                return size;
            }
        };
    }
}

