/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.graph.DefaultEdge;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.graph.DirectedGraph;

public class TopologicalOrderIterator<V, E extends DefaultEdge>
implements Iterator<V> {
    final Map<V, int[]> countMap = new HashMap<V, int[]>();
    final List<V> empties = new ArrayList<V>();
    private final DefaultDirectedGraph<V, E> graph;

    public TopologicalOrderIterator(DirectedGraph<V, E> graph) {
        this.graph = (DefaultDirectedGraph)graph;
        this.populate(this.countMap, this.empties);
    }

    public static <V, E extends DefaultEdge> Iterable<V> of(DirectedGraph<V, E> graph) {
        return () -> new TopologicalOrderIterator(graph);
    }

    private void populate(Map<V, int[]> countMap, List<V> empties) {
        for (Object v : this.graph.vertexMap.keySet()) {
            countMap.put((int[])v, new int[]{0});
        }
        for (DefaultDirectedGraph.VertexInfo vertexInfo : this.graph.vertexMap.values()) {
            for (DefaultEdge edge : vertexInfo.outEdges) {
                int[] ints = countMap.get(edge.target);
                ints[0] = ints[0] + 1;
            }
        }
        for (Map.Entry entry : countMap.entrySet()) {
            if (((int[])entry.getValue())[0] != 0) continue;
            empties.add(entry.getKey());
        }
        countMap.keySet().removeAll(empties);
    }

    @Override
    public boolean hasNext() {
        return !this.empties.isEmpty();
    }

    @Override
    public V next() {
        V v = this.empties.remove(0);
        for (DefaultEdge o : this.graph.vertexMap.get(v).outEdges) {
            Object target = o.target;
            int[] nArray = this.countMap.get(target);
            nArray[0] = nArray[0] - 1;
            if (nArray[0] != 0) continue;
            this.countMap.remove(target);
            this.empties.add(target);
        }
        return v;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    Set<V> findCycles() {
        while (this.hasNext()) {
            this.next();
        }
        return this.countMap.keySet();
    }
}

