/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import com.alibaba.fastjson.JSONObject;
import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.MoreObjects;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableSet;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.TextTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.commons.csv.CSVFormat;

@AutoService(value=TableProvider.class)
public class TextTableProvider
extends InMemoryMetaTableProvider {
    @Override
    public String getTableType() {
        return "text";
    }

    @Override
    public BeamSqlTable buildBeamSqlTable(Table table) {
        Schema schema = table.getSchema();
        String filePattern = table.getLocation();
        JSONObject properties = table.getProperties();
        String format = MoreObjects.firstNonNull(properties.getString("format"), "csv");
        String legacyCsvFormat = null;
        if (!ImmutableSet.of("csv", "lines").contains(format)) {
            legacyCsvFormat = format;
            format = "csv";
        }
        switch (format) {
            case "csv": {
                String specifiedCsvFormat = properties.getString("csvformat");
                CSVFormat csvFormat = specifiedCsvFormat != null ? CSVFormat.valueOf((String)specifiedCsvFormat) : (legacyCsvFormat != null ? CSVFormat.valueOf((String)legacyCsvFormat) : CSVFormat.DEFAULT);
                return new TextTable(schema, filePattern, new CsvToRow(schema, csvFormat), new RowToCsv(csvFormat));
            }
            case "lines": {
                Preconditions.checkArgument(schema.getFieldCount() == 1 && schema.getField(0).getType().equals((Object)Schema.FieldType.STRING), "Table with type 'text' and format 'lines' must have exactly one STRING/VARCHAR/CHAR column");
                return new TextTable(schema, filePattern, new LinesReadConverter(), new LinesWriteConverter());
            }
        }
        throw new IllegalArgumentException("Table with type 'text' must have format 'csv' or 'lines'");
    }

    @VisibleForTesting
    public static class CsvToRow
    extends PTransform<PCollection<String>, PCollection<Row>>
    implements Serializable {
        private Schema schema;
        private CSVFormat csvFormat;

        @VisibleForTesting
        public CSVFormat getCsvFormat() {
            return this.csvFormat;
        }

        public CsvToRow(Schema schema, CSVFormat csvFormat) {
            this.schema = schema;
            this.csvFormat = csvFormat;
        }

        public PCollection<Row> expand(PCollection<String> input) {
            return ((PCollection)input.apply("csvToRow", (PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)s -> BeamTableUtils.csvLines2BeamRows(this.csvFormat, s, this.schema)))).setRowSchema(this.schema);
        }
    }

    @VisibleForTesting
    static class RowToCsv
    extends PTransform<PCollection<Row>, PCollection<String>>
    implements Serializable {
        private CSVFormat csvFormat;

        public RowToCsv(CSVFormat csvFormat) {
            this.csvFormat = csvFormat;
        }

        @VisibleForTesting
        public CSVFormat getCsvFormat() {
            return this.csvFormat;
        }

        public PCollection<String> expand(PCollection<Row> input) {
            return (PCollection)input.apply("rowToCsv", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)row -> BeamTableUtils.beamRow2CsvLine(row, this.csvFormat)));
        }
    }

    public static class LinesReadConverter
    extends PTransform<PCollection<String>, PCollection<Row>>
    implements Serializable {
        private static final Schema SCHEMA = Schema.builder().addStringField("line").build();

        public PCollection<Row> expand(PCollection<String> input) {
            return ((PCollection)input.apply("linesToRows", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)s -> Row.withSchema((Schema)SCHEMA).addValue(s).build()))).setRowSchema(SCHEMA);
        }
    }

    public static class LinesWriteConverter
    extends PTransform<PCollection<Row>, PCollection<String>>
    implements Serializable {
        private static final Schema SCHEMA = Schema.builder().addStringField("line").build();

        public PCollection<String> expand(PCollection<Row> input) {
            return (PCollection)input.apply("rowsToLines", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)row -> row.getString(0) + "\n"));
        }
    }
}

