/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTrait;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.TableScan;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;

public class BeamIOSourceRel
extends TableScan
implements BeamRelNode {
    private final BeamSqlTable sqlTable;
    private final Map<String, String> pipelineOptions;

    public BeamIOSourceRel(RelOptCluster cluster, RelOptTable table, BeamSqlTable sqlTable, Map<String, String> pipelineOptions) {
        super(cluster, cluster.traitSetOf((RelTrait)BeamLogicalConvention.INSTANCE), table);
        this.sqlTable = sqlTable;
        this.pipelineOptions = pipelineOptions;
    }

    @Override
    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    protected BeamSqlTable getBeamSqlTable() {
        return this.sqlTable;
    }

    @Override
    public Map<String, String> getPipelineOptions() {
        return this.pipelineOptions;
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> input) {
            Preconditions.checkArgument(input.size() == 0, "Should not have received input for %s: %s", (Object)BeamIOSourceRel.class.getSimpleName(), input);
            return BeamIOSourceRel.this.sqlTable.buildIOReader(input.getPipeline().begin());
        }
    }
}

