/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.SqlFunctions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math.BeamSqlMathBinaryExpression;

public class BeamSqlTruncateExpression
extends BeamSqlMathBinaryExpression {
    public BeamSqlTruncateExpression(List<BeamSqlExpression> operands) {
        super(operands, operands.get(0).getOutputType());
    }

    @Override
    public BeamSqlPrimitive<? extends Number> calculate(BeamSqlPrimitive leftOp, BeamSqlPrimitive rightOp) {
        BeamSqlPrimitive<Number> result = null;
        int rightIntOperand = SqlFunctions.toInt(rightOp.getValue());
        switch (leftOp.getOutputType()) {
            case SMALLINT: {
                result = BeamSqlPrimitive.of(SqlTypeName.SMALLINT, (short)SqlFunctions.struncate(SqlFunctions.toInt(leftOp.getValue()), rightIntOperand));
                break;
            }
            case TINYINT: {
                result = BeamSqlPrimitive.of(SqlTypeName.TINYINT, (byte)SqlFunctions.struncate(SqlFunctions.toInt(leftOp.getValue()), rightIntOperand));
                break;
            }
            case INTEGER: {
                result = BeamSqlPrimitive.of(SqlTypeName.INTEGER, SqlFunctions.struncate(SqlFunctions.toInt(leftOp.getValue()), rightIntOperand));
                break;
            }
            case BIGINT: {
                result = BeamSqlPrimitive.of(SqlTypeName.BIGINT, SqlFunctions.struncate(leftOp.getLong(), rightIntOperand));
                break;
            }
            case FLOAT: {
                result = BeamSqlPrimitive.of(SqlTypeName.FLOAT, Float.valueOf((float)SqlFunctions.struncate(SqlFunctions.toFloat(leftOp.getValue()), rightIntOperand)));
                break;
            }
            case DOUBLE: {
                result = BeamSqlPrimitive.of(SqlTypeName.DOUBLE, SqlFunctions.struncate(SqlFunctions.toDouble(leftOp.getValue()), rightIntOperand));
                break;
            }
            case DECIMAL: {
                result = BeamSqlPrimitive.of(SqlTypeName.DECIMAL, SqlFunctions.struncate(leftOp.getDecimal(), rightIntOperand));
                break;
            }
        }
        return result;
    }
}

