/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datagen;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

class AdvancingTimestampFn
implements SerializableFunction<Long, Instant> {
    private final @UnknownKeyFor @NonNull @Initialized long maxOutOfOrdernessMs;
    private final @UnknownKeyFor @NonNull @Initialized Instant baseTime = Instant.now();

    AdvancingTimestampFn(@UnknownKeyFor @NonNull @Initialized long maxOutOfOrdernessMs) {
        this.maxOutOfOrdernessMs = maxOutOfOrdernessMs;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant apply(@UnknownKeyFor @NonNull @Initialized Long index) {
        long delay = (long)(ThreadLocalRandom.current().nextDouble() * (double)this.maxOutOfOrdernessMs);
        return this.baseTime.plus((ReadableDuration)Duration.millis((long)(index * 1000L))).minus((ReadableDuration)Duration.millis((long)delay));
    }
}

